/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;

public class TngInformationListener {
    private JComponent parent;
    private KeyStroke keyStroke;

    public TngInformationListener(JComponent parent) {
        this(parent, KeyStroke.getKeyStroke(123, 128));
    }

    public TngInformationListener(JComponent parent, KeyStroke keyStroke) {
        this.parent = parent;
        this.keyStroke = keyStroke;
        this.addInformationListener();
    }

    private void addInformationListener() {
        this.parent.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String info = TngInformationListener.this.getInfo();
                TngInformationListener.this.showInfo(info);
            }
        }, this.keyStroke, 2);
    }

    protected String getInfo() {
        String packageName = TngUtilities.getPackageName(this.parent);
        String className = TngUtilities.getClassName(this.parent);
        String msg = Nat.x("Bal\u00edk: %1", packageName == null ? "---" : packageName);
        msg = msg + "\n" + Nat.x("Trieda: %1", className == null ? "---" : className);
        return msg;
    }

    protected void showInfo(String msg) {
        if (msg != null) {
            TngSwing.msgOK(msg);
        }
    }
}

