/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing;

import com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import tangram.exception.TngExceptionAbort;
import tangram.exception.TngExceptionSql;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.swing.component.TngLabel;
import tangram.swing.component.TngListRendererCell;
import tangram.swing.component.TngPicture;
import tangram.swing.icon.TngImageFilterGrayscale;
import tangram.swing.icon.TngImageFilterMonochrome;
import tangram.swing.panel.TngDlg;
import tangram.swing.panel.TngPanelException;
import tangram.swing.panel.TngPanelExceptionSql;
import tangram.swing.panel.TngPanelHtml;
import tangram.swing.panel.TngPanelText;
import tangram.swing.table.renderer.TngTableRendererCell;

public final class TngSwing {
    public static Color colorNotCanNull = new Color(181, 255, 181);
    public static Color colorNotEditable = new Color(235, 235, 235);
    public static Color colorWizardHighlight = new Color(132, 132, 255);
    public static Color colorErrorMark = new Color(255, 99, 99);
    public static Color colorErrorPopupBackground = new Color(255, 99, 99);
    public static Color colorErrorPopupForeground = new Color(0, 0, 0);
    public static final Color colorDesignInfo = new Color(158, 33, 255);
    public static Color themeLight = new Color(165, 195, 220);
    public static Color themeDark = new Color(130, 170, 210);
    public static boolean enterFocusTransfer = true;
    public static JFrame mainWindow = null;
    public static boolean designMode = true;
    public static final String VARIANT_SIZE_MINI = "mini";
    public static final String VARIANT_SIZE_SMALL = "small";
    public static final String VARIANT_SIZE_REGULAR = "regular";
    public static final String VARIANT_SIZE_LARGE = "large";
    public static String variantSize = "regular";
    public static Font variantDefaultFont = new JPasswordField().getFont();
    private static final int MARGIN = 200;
    private static Font fontBase;

    private TngSwing() {
    }

    public static void initialize(String application, String[] applicationArgs) {
        TngUtilities.initialize(application, applicationArgs);
        try {
            designMode = false;
            UIManager.setLookAndFeel((LookAndFeel)new NimbusLookAndFeel(){

                public UIDefaults getDefaults() {
                    UIDefaults ret = super.getDefaults();
                    return ret;
                }
            });
            TngSwing.setLafThemeColors(themeDark, themeLight);
            TngSwing.changeVariantSize(VARIANT_SIZE_REGULAR);
            System.setProperty("swing.aatext", "true");
            System.setProperty("sun.awt.noerasebackground", "true");
            UIManager.put("FileChooser.cancelButtonText", Nat.x("Zru\u0161i\u0165"));
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(Nat.x("Look&Feel Nimbus nebol aktivovan\u00fd"), e2);
        }
    }

    public static void setLafThemeColors(Color dark, Color light) {
        themeDark = dark;
        themeLight = light;
        UIManager.put("Tree.selectionBackground", themeLight);
        TngTableRendererCell.selectionBackground = themeDark;
        TngTableRendererCell.selectionBackgroundNoFocus = themeLight;
        TngListRendererCell.selectionBackground = themeDark;
        TngListRendererCell.selectionBackgroundNoFocus = themeLight;
        TngListRendererCell.selectionBackgroundOdd = UIManager.getColor("Table.alternateRowColor");
    }

    public static void changeVariantSize(String variantSize) {
        TngSwing.variantSize = variantSize;
        JPasswordField field = new JPasswordField();
        variantDefaultFont = field.getFont();
    }

    public static void setVariantSize(JComponent component) {
        component.putClientProperty("JComponent.sizeVariant", variantSize);
        SwingUtilities.updateComponentTreeUI(component);
    }

    public static void setVariantFontSize(JComponent component) {
        component.setFont(variantDefaultFont);
    }

    public static void windowCenter(JDialog frame) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public static void windowCenter(JFrame frame) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public static void waitCursorOn(Component c2) {
        if (c2 != null) {
            c2.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public static HashMap<Component, Cursor> waitCursorOnRecursive(Container w2) {
        HashMap<Component, Cursor> cursors = new HashMap<Component, Cursor>();
        if (w2 != null) {
            List<Component> all = TngSwing.getAllComponents(w2);
            for (Component comp : all) {
                cursors.put(comp, comp.getCursor());
                if (comp.getCursor() == null) continue;
                comp.setCursor(null);
            }
            w2.setCursor(Cursor.getPredefinedCursor(3));
        }
        return cursors;
    }

    public static List<Component> getAllComponents(Container c2) {
        Component[] comps = c2.getComponents();
        ArrayList<Component> compList = new ArrayList<Component>();
        for (Component comp : comps) {
            compList.add(comp);
            if (!(comp instanceof Container)) continue;
            compList.addAll(TngSwing.getAllComponents((Container)comp));
        }
        return compList;
    }

    public static void waitCursorOffRecursive(Container w2, HashMap<Component, Cursor> cursors) {
        if (w2 != null) {
            w2.setCursor(Cursor.getDefaultCursor());
        }
        if (cursors != null && cursors.size() != 0) {
            Set<Component> keySet = cursors.keySet();
            Component[] comps = new Component[keySet.size()];
            keySet.toArray(comps);
            for (Component c2 : comps) {
                c2.setCursor(cursors.get(c2));
            }
        }
    }

    public static void waitCursorOff(Component c2) {
        if (c2 != null) {
            c2.setCursor(Cursor.getDefaultCursor());
        }
    }

    public static void exceptionShow(Throwable e2) {
        TngSwing.exceptionShow(null, e2);
    }

    public static void exceptionShow(String title, Throwable e2) {
        if (e2 == null) {
            return;
        }
        TngUtilities.exceptionLog(e2);
        if (e2 instanceof TngExceptionAbort) {
            TngSwing.msgWarning(e2.getMessage());
        } else if (e2 instanceof TngExceptionSql) {
            TngPanelExceptionSql p2 = new TngPanelExceptionSql();
            p2.setData(title, (TngExceptionSql)e2);
            TngDlg.runModal(p2, 6);
        } else {
            TngPanelException p3 = new TngPanelException();
            p3.setData(title, e2);
            TngDlg.runModal(p3, 6);
        }
    }

    public static void msgError(String text) {
        JOptionPane.showMessageDialog(mainWindow, text, Nat.x("Chyba"), 0);
    }

    public static void msgWarning(String text) {
        JOptionPane.showMessageDialog(mainWindow, text, Nat.x("Pozor"), 2);
    }

    public static void msgOK(String text) {
        JOptionPane.showMessageDialog(mainWindow, text, Nat.x("OK"), 1);
    }

    public static boolean msgNovalid(String text) {
        return TngSwing.msgNovalid(text, null);
    }

    public static boolean msgNovalid(String text, Component focus) {
        JOptionPane.showMessageDialog(mainWindow, text, Nat.x("Nespr\u00e1vna hodnota"), 2);
        if (focus != null) {
            focus.requestFocus();
        }
        return false;
    }

    public static boolean msgAsk(String text) {
        return TngSwing.msgAsk(TngUtilities.application, text);
    }

    public static boolean msgAsk(String title, String ask) {
        Object[] options = new String[]{Nat.x("\u00c1no"), Nat.x("Nie")};
        int r2 = JOptionPane.showOptionDialog(mainWindow, ask, title, -1, 3, null, options, options[0]);
        return r2 == 0;
    }

    public static int msgAsk(String text, Object[] options, int defOption) {
        return JOptionPane.showOptionDialog(mainWindow, text, TngUtilities.application, -1, 3, null, options, options[defOption]);
    }

    public static int msgWarning(String text, Object[] options, int defOption) {
        return JOptionPane.showOptionDialog(mainWindow, text, TngUtilities.application, -1, 2, null, options, options[defOption]);
    }

    public static void textShow(String title, String text) {
        if (text == null) {
            return;
        }
        TngPanelText p2 = new TngPanelText();
        p2.setTitle(title);
        p2.setData(text);
        TngDlg.runModal(p2, 2);
    }

    public static void htmlShow(String title, String html) {
        if (html == null) {
            return;
        }
        TngPanelHtml p2 = new TngPanelHtml();
        p2.setTitle(title);
        p2.setData(html);
        TngDlg.runModal(p2, 2);
    }

    public static void msgErrorSys(String text) {
        TngUtilities.errorLog(text);
        JOptionPane.showMessageDialog(null, text, Nat.x("Chyba"), 0);
    }

    public static void msgErrorSys(Throwable e2) {
        e2.printStackTrace();
        TngUtilities.exceptionLog(e2);
        JOptionPane.showMessageDialog(null, e2.toString(), Nat.x("Chyba"), 0);
    }

    public static void setOptimalHeightMax(JPanel panel, int maxHeight) {
        if (panel.getLayout() == null) {
            return;
        }
        Dimension sizeW = panel.getSize();
        panel.setSize(new Dimension(sizeW.width, -1));
        Dimension sizeH = panel.getLayout().preferredLayoutSize(panel);
        TngSwing.setOptimalSize(panel, new Dimension(sizeW.width, maxHeight > sizeH.height ? sizeH.height : maxHeight));
    }

    public static void setOptimalHeight(JPanel panel) {
        if (panel.getLayout() == null) {
            return;
        }
        Dimension sizeW = panel.getSize();
        panel.setSize(new Dimension(sizeW.width, -1));
        Dimension sizeH = panel.getLayout().preferredLayoutSize(panel);
        TngSwing.setOptimalSize(panel, new Dimension(sizeW.width, sizeH.height));
    }

    public static void setOptimalSize(JPanel panel) {
        if (panel.getLayout() == null) {
            return;
        }
        panel.setSize(new Dimension(-1, -1));
        Dimension size = panel.getLayout().preferredLayoutSize(panel);
        TngSwing.setOptimalSize(panel, new Dimension(size));
    }

    private static void setOptimalSize(JPanel panel, Dimension size) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension minSize = panel.getMinimumSize();
        size.width = Math.min(size.width, screenSize.width - 200);
        size.width = Math.max(size.width, minSize.width);
        size.height = Math.min(size.height, screenSize.height - 200);
        size.height = Math.max(size.height, minSize.height);
        panel.setSize(size);
    }

    public static Icon iconToGrayscale(Icon icon) {
        return TngSwing.iconCreate(icon, new TngImageFilterGrayscale());
    }

    public static Icon iconToGrayscale(Icon icon, Color base) {
        return TngSwing.iconCreate(icon, new TngImageFilterMonochrome(base));
    }

    public static Icon iconCreate(Icon icon, ImageFilter filter) {
        Icon gray = icon;
        if (icon instanceof ImageIcon) {
            Image image = ((ImageIcon)icon).getImage();
            FilteredImageSource producer = new FilteredImageSource(image.getSource(), filter);
            image = Toolkit.getDefaultToolkit().createImage(producer);
            gray = new ImageIcon(image);
        }
        return gray;
    }

    public static Image imageToGrayscale(Image image) {
        return TngSwing.imageCreate(image, new TngImageFilterGrayscale());
    }

    public static Image imageToMonochrome(Image image, Color base) {
        return TngSwing.imageCreate(image, new TngImageFilterMonochrome(base));
    }

    public static Image imageCreate(Image image, ImageFilter filter) {
        FilteredImageSource producer = new FilteredImageSource(image.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(producer);
    }

    public static ImageIcon imageResize(ImageIcon helpImage, Dimension helpDim) {
        Image img = helpImage.getImage();
        BufferedImage bi = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D g2 = bi.createGraphics();
        g2.drawImage(img, 0, 0, null);
        BufferedImage helpBuff = TngPicture.resizeProportional(bi, helpDim.width, helpDim.height);
        return new ImageIcon(helpBuff);
    }

    public static Component getPreviousComponent(Component component) {
        Container container = component.getParent();
        Component[] comps = container.getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            Component c2 = comps[i2];
            if (c2 != component) continue;
            if (i2 == 0) {
                return null;
            }
            return comps[i2 - 1];
        }
        return null;
    }

    public static Font getBaseFont() {
        if (fontBase == null) {
            fontBase = new TngLabel().getFont();
        }
        return fontBase;
    }

    public static Font createFontAbsolute(int style, int size) {
        return TngSwing.createFontAbsolute(TngSwing.getBaseFont(), style, size);
    }

    public static Font createFontRelative(int style, float factor) {
        return TngSwing.createFontRelative(TngSwing.getBaseFont(), style, factor);
    }

    public static Font createFontAbsolute(Font font, int style, int size) {
        if (style < 0) {
            style = font.getStyle();
        }
        if (size < 0) {
            size = font.getSize();
        }
        return new Font(font.getFamily(), style, size);
    }

    public static Font createFontRelative(Font font, int style, float factor) {
        if (style < 0) {
            style = font.getStyle();
        }
        int size = font.getSize();
        if (factor >= 0.0f) {
            size = (int)((float)size * factor);
        }
        return new Font(font.getFamily(), style, size);
    }

    public static Font calcMaxFittingFont(Graphics g2, Font font, String string, int width, int height) {
        Font curFont = font;
        float minSize = 0.0f;
        float maxSize = 288.0f;
        float curSize = font.getSize();
        while (maxSize - minSize > 2.0f) {
            curFont = font.deriveFont(curSize);
            FontMetrics fm = g2.getFontMetrics(curFont);
            int fontWidth = fm.stringWidth(string);
            int fontHeight = fm.getLeading() + fm.getMaxAscent() + fm.getMaxDescent();
            if (fontWidth > width || fontHeight > height) {
                maxSize = curSize;
                curSize = (maxSize + minSize) / 2.0f;
                continue;
            }
            minSize = curSize;
            curSize = (minSize + maxSize) / 2.0f;
        }
        return curFont;
    }
}

