/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.component;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import tangram.interfaces.TngParamable;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;
import tangram.swing.component.field.TngFieldString;

public class TngComboBox
extends JComboBox
implements TngParamable {
    protected boolean enterFocusTransfer = TngSwing.enterFocusTransfer;
    private String paramName;

    public TngComboBox() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngUtilities.exceptionLog(e2);
        }
    }

    private void jbInit() throws Exception {
        TngSwing.setVariantSize(this);
        this.setEditor(new TngComboBoxEditor());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e2) {
                int keyCode = e2.getKeyCode();
                if (TngComboBox.this.enterFocusTransfer && keyCode == 10) {
                    e2.consume();
                    if (e2.isShiftDown()) {
                        TngComboBox.this.transferFocusBackward();
                    } else {
                        TngComboBox.this.transferFocus();
                    }
                }
            }
        });
    }

    public boolean getEnterFocusTransfer() {
        return this.enterFocusTransfer;
    }

    public void setEnterFocusTransfer(boolean enterFocusTransfer) {
        this.enterFocusTransfer = enterFocusTransfer;
    }

    public String getText() {
        Object o2 = null;
        if (this.isEditable()) {
            ComboBoxEditor ed = this.getEditor();
            o2 = ed.getItem();
        } else {
            o2 = this.getSelectedItem();
        }
        if (o2 == null) {
            return "";
        }
        return o2.toString();
    }

    @Override
    public void setEnabled(boolean b2) {
        Component a2 = (Component)((Object)this.getRenderer());
        a2.setEnabled(b2);
        super.setEnabled(b2);
    }

    public boolean setSelectedItem(Object anObject, int defIndex) {
        if (anObject == null) {
            this.setSelectedItem(null);
            return true;
        }
        this.setSelectedItem(anObject);
        Object selected = this.getSelectedItem();
        if (anObject.equals(selected)) {
            return true;
        }
        this.setSelectedIndex(defIndex);
        return false;
    }

    public TngFieldString getEditorComponent() {
        TngComboBoxEditor editor = (TngComboBoxEditor)this.getEditor();
        return editor.getEditorComponent();
    }

    @Override
    public String getParamName() {
        return this.paramName;
    }

    @Override
    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public static class TngComboBoxEditor
    extends BasicComboBoxEditor {
        @Override
        protected TngFieldString createEditorComponent() {
            TngFieldString editor = new TngFieldString();
            editor.setBorder(new EmptyBorder(new Insets(0, 5, 0, 5)));
            return editor;
        }

        @Override
        public TngFieldString getEditorComponent() {
            return (TngFieldString)this.editor;
        }
    }
}

