/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.component;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class TngPicture
extends JComponent {
    private BufferedImage imageOriginal = null;
    private BufferedImage imageActual = null;
    private Insets margin = null;
    private int imageX;
    private int imageY;
    private boolean proportional = true;
    private boolean grow = true;
    private int horizontalAlignment = 0;
    private int verticalAlignment = 0;

    public void setImage(String file) {
        this.setImage(TngPicture.loadImage(file));
    }

    public void setImage(BufferedImage image) {
        this.imageOriginal = image;
        this.imageActual = null;
        this.revalidate();
        this.repaint();
    }

    public void setImage(ImageIcon icon) {
        Image img = icon.getImage();
        BufferedImage image = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D g2 = image.createGraphics();
        g2.drawImage(img, 0, 0, null);
        this.setImage(image);
    }

    public BufferedImage getImage() {
        return this.imageOriginal;
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
        this.repaint();
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setProportional(boolean proportional) {
        this.proportional = proportional;
        this.repaint();
    }

    public boolean getProportional() {
        return this.proportional;
    }

    public void setGrow(boolean grow) {
        this.grow = grow;
        this.repaint();
    }

    public boolean getGrow() {
        return this.grow;
    }

    @Override
    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        Graphics2D g22 = (Graphics2D)g2;
        this.actualizeImage();
        if (this.isBackgroundSet() && this.isOpaque()) {
            g22.setBackground(this.getBackground());
            g22.clearRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.imageActual != null) {
            g22.drawImage((Image)this.imageActual, this.imageX, this.imageY, null);
        }
    }

    private void actualizeImage() {
        Border border;
        this.imageX = 0;
        this.imageY = 0;
        if (this.imageOriginal == null) {
            this.imageActual = null;
            return;
        }
        int left = 0;
        int top = 0;
        int w2 = this.getWidth();
        int h2 = this.getHeight();
        if (this.margin != null) {
            left += this.margin.left;
            top += this.margin.top;
            w2 -= this.margin.left + this.margin.right;
            h2 -= this.margin.top + this.margin.bottom;
        }
        if ((border = this.getBorder()) != null) {
            Insets m2 = border.getBorderInsets(this);
            left += m2.left;
            top += m2.top;
            w2 -= m2.left + m2.right;
            h2 -= m2.top + m2.bottom;
        }
        if (this.imageActual == null || this.imageActual.getWidth() != w2 || this.imageActual.getHeight() != h2) {
            this.imageActual = TngPicture.resize(this.imageOriginal, w2, h2, this.proportional, this.grow);
        }
        this.imageX = left;
        if (this.horizontalAlignment == 0) {
            this.imageX = left + (w2 - this.imageActual.getWidth()) >> 1;
        } else if (this.horizontalAlignment == 4) {
            this.imageX = left + (w2 - this.imageActual.getWidth());
        }
        this.imageY = top;
        if (this.verticalAlignment == 0) {
            this.imageY = top + (h2 - this.imageActual.getHeight()) >> 1;
        } else if (this.verticalAlignment == 3) {
            this.imageY = top + (h2 - this.imageActual.getHeight());
        }
    }

    public static BufferedImage loadImage(String file) {
        if (file == null || file.length() == 0) {
            return null;
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(file));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    public static boolean imageOversized(BufferedImage image, int newW, int newH) {
        return image.getWidth() < newW && image.getHeight() < newH;
    }

    public static BufferedImage resize(BufferedImage image, int newW, int newH, boolean proportional, boolean grow) {
        if (!grow && TngPicture.imageOversized(image, newW, newH)) {
            return image;
        }
        if (proportional) {
            return TngPicture.resizeProportional(image, newW, newH);
        }
        return TngPicture.resizeNonproportional(image, newW, newH);
    }

    public static BufferedImage resizeNonproportional(BufferedImage image, int newW, int newH) {
        int w2 = image.getWidth();
        int h2 = image.getHeight();
        if (w2 == newW && h2 == newH) {
            return image;
        }
        if (newW <= 0 || newH <= 0) {
            return image;
        }
        BufferedImage newImage = new BufferedImage(newW, newH, 2);
        Graphics2D g2 = newImage.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(image, 0, 0, newW, newH, 0, 0, w2, h2, null);
        g2.dispose();
        return newImage;
    }

    public static BufferedImage resizeProportional(BufferedImage image, int newW, int newH) {
        int w2 = image.getWidth();
        int h2 = image.getHeight();
        if (w2 == newW && h2 == newH) {
            return image;
        }
        double fx = (double)newW / (double)w2;
        double fy = (double)newH / (double)h2;
        if (fx < fy) {
            newH = (int)((double)h2 * fx);
        } else {
            newW = (int)((double)w2 * fy);
        }
        return TngPicture.resizeNonproportional(image, newW, newH);
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int alignment) {
        if (alignment == this.verticalAlignment) {
            return;
        }
        this.verticalAlignment = alignment;
        this.repaint();
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int alignment) {
        if (alignment == this.horizontalAlignment) {
            return;
        }
        this.horizontalAlignment = alignment;
        this.repaint();
    }
}

