/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.component.button;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;

public class TngButton
extends JButton {
    public Object userObject;
    private boolean intoAction = false;

    public TngButton() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngUtilities.exceptionLog(e2);
        }
    }

    private void jbInit() throws Exception {
        TngSwing.setVariantSize(this);
        this.setFocusable(false);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngButton.this.doClick();
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
    }

    @Override
    protected void fireActionPerformed(ActionEvent event) {
        if (this.intoAction) {
            return;
        }
        try {
            this.intoAction = true;
            Dimension size = this.getSize();
            this.paintImmediately(0, 0, size.width, size.height);
            super.fireActionPerformed(event);
        }
        catch (Throwable e2) {
            TngSwing.exceptionShow(e2);
        }
        finally {
            this.intoAction = false;
        }
    }

    public void setHightByComponent(Component component) {
        if (component != null) {
            Dimension d2 = new Dimension(this.getPreferredSize().width, component.getPreferredSize().height);
            this.setPreferredSize(d2);
            this.setMinimumSize(d2);
        }
    }

    public void setHightByComponent(Component component, int width) {
        if (component != null) {
            Dimension d2 = new Dimension(width, component.getPreferredSize().height);
            this.setPreferredSize(d2);
            this.setMinimumSize(d2);
        }
    }

    public void changeFontAbsolute(int style, int size) {
        Font font = TngSwing.createFontAbsolute(this.getFont(), style, size);
        this.setFont(font);
    }

    public void changeFontRelative(int style, float factor) {
        Font font = TngSwing.createFontRelative(this.getFont(), style, factor);
        this.setFont(font);
    }
}

