/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.component.field;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.math.BigDecimal;
import tangram.exception.TngExceptionNovalid;
import tangram.interfaces.TngValuable;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;
import tangram.swing.component.field.TngField;

public class TngFieldDecimal
extends TngField
implements TngValuable {
    protected BigDecimal valueDecimal;
    protected boolean valueCanZero = true;
    protected BigDecimal valueMin;
    protected BigDecimal valueMax;
    protected int valueSize;
    protected int valueScale;
    protected int valueShowDecimals;
    protected BigDecimal restrictionMin;
    protected BigDecimal restrictionMax;

    public TngFieldDecimal() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
        this.setHorizontalAlignment(4);
        this.calcRestricitonMinMax();
    }

    public Class getValueClass() {
        return BigDecimal.class;
    }

    @Override
    public Object getValue() throws Exception {
        return this.getDecimal();
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof BigDecimal) {
            this.setDecimal((BigDecimal)value);
        } else {
            this.setTextAndCheck(value == null ? null : value.toString());
        }
    }

    public BigDecimal getDecimal() throws TngExceptionNovalid {
        this.check();
        if (this.valueError != null) {
            throw new TngExceptionNovalid(this, this.valueError);
        }
        return this.valueDecimal;
    }

    public BigDecimal getDecimalDef(BigDecimal def) {
        this.check();
        if (this.valueError != null) {
            return def;
        }
        return this.valueDecimal;
    }

    public void setDecimal(BigDecimal value) {
        value = TngUtilities.fixDecimals(value, this.valueShowDecimals);
        this.setTextAndCheck(TngUtilities.numberToString(value));
    }

    public void setDecimalWithRound(BigDecimal value) {
        value = TngUtilities.trimDecimals(value, this.valueShowDecimals, this.valueScale);
        this.setTextAndCheck(TngUtilities.numberToString(value));
    }

    public BigDecimal getRestrictionMin() {
        return this.restrictionMin;
    }

    public BigDecimal getRestricitonMax() {
        return this.restrictionMax;
    }

    public void setValueCanZero(boolean canZero) {
        if (this.valueCanZero != canZero) {
            this.valueCanZero = canZero;
            this.lastCheckedText = null;
        }
    }

    public boolean getValueCanZero() {
        return this.valueCanZero;
    }

    public void setValueMin(String m2) {
        if (m2 == null || m2.length() == 0) {
            this.setValueMin((BigDecimal)null);
        } else {
            this.setValueMin(new BigDecimal(m2));
        }
    }

    public String getValueMin() {
        return this.valueMin == null ? "" : this.valueMin.toString();
    }

    public void setValueMin(BigDecimal min) {
        if (TngFieldDecimal.decimalsNotEquals(this.valueMin, min)) {
            this.valueMin = min;
            this.calcRestricitonMinMax();
        }
    }

    public BigDecimal getValueMinDecimal() {
        return this.valueMin;
    }

    public void setValueMax(String m2) {
        if (m2 == null || m2.length() == 0) {
            this.setValueMax((BigDecimal)null);
        } else {
            this.setValueMax(new BigDecimal(m2));
        }
    }

    public String getValueMax() {
        return this.valueMax == null ? "" : this.valueMax.toString();
    }

    public void setValueMax(BigDecimal max) {
        if (TngFieldDecimal.decimalsNotEquals(this.valueMax, max)) {
            this.valueMax = max;
            this.calcRestricitonMinMax();
        }
    }

    public BigDecimal getValueMaxDecimal() {
        return this.valueMax;
    }

    public void setValueSize(Dimension s2) {
        if (s2 == null) {
            this.setValueSize(0, 0);
        } else {
            this.setValueSize(s2.width, s2.height);
        }
    }

    public void setValueSize(int size, int scale) {
        if (size < 0 || scale < 0 || size < scale) {
            throw new IllegalArgumentException("Size or scale is bad.");
        }
        if (this.valueSize != size || this.valueScale != scale) {
            this.valueSize = size;
            this.valueScale = scale;
            this.calcRestricitonMinMax();
            this.setColumns(size + (scale == 0 ? 0 : 1) + (this.restrictionMin != null && this.restrictionMin.signum() >= 0 ? 0 : 1));
        }
    }

    public Dimension getValueSize() {
        return new Dimension(this.valueSize, this.valueScale);
    }

    public void setValueShowDecimals(int showDecimals) {
        if (showDecimals < 0) {
            throw new IllegalArgumentException("Show decimals is bad.");
        }
        if (this.valueShowDecimals != showDecimals) {
            this.valueShowDecimals = showDecimals;
            this.repaint();
        }
    }

    public int getValueShowDecimals() {
        return this.valueShowDecimals;
    }

    protected void calcRestricitonMinMax() {
        BigDecimal sizeMax = TngFieldDecimal.calcMaxValueForSize(this.valueSize, this.valueScale);
        BigDecimal sizeMin = sizeMax == null ? null : sizeMax.negate();
        BigDecimal newMin = TngFieldDecimal.decimalsMax(this.valueMin, sizeMin);
        BigDecimal newMax = TngFieldDecimal.decimalsMin(this.valueMax, sizeMax);
        if (TngFieldDecimal.decimalsNotEquals(this.restrictionMin, newMin) || TngFieldDecimal.decimalsNotEquals(this.restrictionMax, newMax)) {
            this.restrictionMin = newMin;
            this.restrictionMax = newMax;
            this.lastCheckedText = null;
        }
    }

    public static final BigDecimal calcMaxValueForSize(int size, int scale) {
        int i2;
        if (size <= 0 || scale >= size) {
            return null;
        }
        StringBuilder h2 = new StringBuilder(size + 1);
        for (i2 = 0; i2 < size - scale; ++i2) {
            h2.append('9');
        }
        if (scale > 0) {
            h2.append('.');
        }
        for (i2 = 0; i2 < scale; ++i2) {
            h2.append('9');
        }
        return new BigDecimal(h2.toString());
    }

    public static final boolean decimalsNotEquals(BigDecimal a2, BigDecimal b2) {
        if (a2 == null && b2 == null) {
            return true;
        }
        if (a2 == null && b2 != null || a2 != null && b2 == null) {
            return true;
        }
        return a2.compareTo(b2) != 0;
    }

    public static final BigDecimal decimalsMin(BigDecimal a2, BigDecimal b2) {
        if (a2 == null) {
            return b2;
        }
        if (b2 == null) {
            return a2;
        }
        if (a2.compareTo(b2) < 0) {
            return a2;
        }
        return b2;
    }

    public static BigDecimal decimalsMax(BigDecimal a2, BigDecimal b2) {
        if (a2 == null) {
            return b2;
        }
        if (b2 == null) {
            return a2;
        }
        if (a2.compareTo(b2) > 0) {
            return a2;
        }
        return b2;
    }

    @Override
    protected String getDesignInfo() {
        String h2 = super.getDesignInfo();
        if (this.valueSize > 0) {
            h2 = h2 + " decimal(" + this.valueSize + "," + this.valueScale + ")";
        }
        if (this.valueShowDecimals > 0) {
            h2 = h2 + " #" + this.valueShowDecimals;
        }
        if (this.restrictionMin != null && this.restrictionMax != null && this.restrictionMin.compareTo(this.restrictionMax) > 0) {
            h2 = h2 + " <EMPTY>";
        } else if (this.restrictionMin == null && this.restrictionMax == null) {
            h2 = h2 + " <ALL>";
        } else {
            String min = this.restrictionMin == null ? ".." : this.restrictionMin.toString();
            String max = this.restrictionMax == null ? ".." : this.restrictionMax.toString();
            h2 = h2 + " <" + min + "," + max + ">";
        }
        if (!this.valueCanZero) {
            h2 = h2 + " except 0";
        }
        return h2;
    }

    @Override
    protected String valueCheck(String text) {
        this.valueDecimal = null;
        String e2 = super.valueCheck(text);
        if (e2 != null) {
            return e2;
        }
        if (text.length() == 0) {
            return null;
        }
        BigDecimal v2 = TngUtilities.stringToNumber(text);
        if (v2 == null) {
            return Nat.x("Hodnota nie je \u010d\u00edslo");
        }
        v2 = TngUtilities.fixDecimals(v2, 0);
        if (this.restrictionMin != null && this.restrictionMin.compareTo(v2) > 0) {
            return Nat.x("Hodnota je men\u0161ia ako %1", this.restrictionMin);
        }
        if (this.restrictionMax != null && this.restrictionMax.compareTo(v2) < 0) {
            return Nat.x("Hodnota je v\u00e4\u010d\u0161ia ako %1", this.restrictionMax);
        }
        if (this.valueSize > 0 && v2.scale() > this.valueScale) {
            if (this.valueScale == 0) {
                return Nat.x("Polo\u017eka nesmie obsahova\u0165 desatinn\u00e9 \u010d\u00edsla");
            }
            return Nat.x("Po\u010det desatinn\u00fdch \u010d\u00edsiel presiahlo maximum %1", this.valueScale);
        }
        if (!this.valueCanZero && v2.signum() == 0) {
            return Nat.x("Hodnota nesmie by\u0165 0");
        }
        this.valueDecimal = TngUtilities.fixDecimals(v2, this.valueShowDecimals);
        return null;
    }

    @Override
    protected void openWizardDef(String text) {
        try {
            Runtime.getRuntime().exec("calc");
        }
        catch (Exception e2) {
            this.beep();
        }
    }

    @Override
    protected int inputCheck(char c2, StringBuilder text, int position) {
        if (this.valueSize > 0 && text.length() >= this.valueSize + (this.valueScale == 0 ? 0 : 1) + (this.restrictionMin != null && this.restrictionMin.signum() >= 0 ? 0 : 1)) {
            return -1;
        }
        if (c2 == '-') {
            if (position != 0 || this.restrictionMin != null && this.restrictionMin.signum() >= 0 || text.indexOf("-") >= 0) {
                return -1;
            }
            text.insert(position, c2);
            return position + 1;
        }
        if (c2 == '.' || c2 == ',') {
            if (this.valueSize > 0 && this.valueScale == 0) {
                return -1;
            }
            if (position == 0 && text.length() > 0 && text.charAt(0) == '-') {
                return -1;
            }
            int x2 = text.indexOf(",");
            if (x2 >= 0) {
                text.delete(x2, x2 + 1);
                if (x2 < position) {
                    --position;
                }
            }
            text.insert(position, ",");
            return position + 1;
        }
        if (c2 < '0' || c2 > '9') {
            return -1;
        }
        if (position == 0 && text.length() > 0 && text.charAt(0) == '-') {
            return -1;
        }
        text.insert(position, c2);
        return position + 1;
    }

    @Override
    protected void reformat() {
        if (this.valueDecimal != null) {
            this.setTextWithoutCheck(TngUtilities.numberToString(this.valueDecimal));
        }
    }

    @Override
    protected int getColumnWidth() {
        if (this.columnWidth == 0) {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            this.columnWidth = metrics.charWidth('8');
        }
        return this.columnWidth;
    }
}

