/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.component.field;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import tangram.interfaces.TngValuable;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;
import tangram.swing.component.field.TngFieldString;
import tangram.swing.panel.TngDlg;
import tangram.swing.table.component.TngTable;
import tangram.swing.table.component.TngTableColumn;
import tangram.swing.table.component.TngTablePanel;
import tangram.swing.table.model.TngTableModel;
import tangram.swing.valuable.TngValueAdapter;
import tangram.swing.valuable.TngValueEvent;

public class TngFieldLink
extends TngFieldString
implements TngValuable {
    protected TngTablePanel tablePanel;
    protected boolean filterLink;
    private String keyColumn;
    private String keyColumnUser;
    protected TngFieldString valueField;
    protected String valueFieldExpression;

    public TngFieldLink() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
        this.setValueWizard(true);
        this.setValueFormat(3);
        this.setColumns(10);
        this.addValueListener(new TngValueAdapter(){

            @Override
            public void valueChangedEvery(TngValueEvent e2) {
                TngFieldLink.this.valueFieldChanged(e2);
            }
        });
    }

    public void setTablePanel(TngTablePanel tablePanel) {
        this.tablePanel = tablePanel;
    }

    public TngTablePanel getTablePanel() {
        return this.tablePanel;
    }

    public TngTableModel getTableModel() {
        TngTablePanel tablePanel = this.getTablePanel();
        return tablePanel == null ? null : tablePanel.getTableModel();
    }

    public TngTable getTable() {
        TngTablePanel tablePanel = this.getTablePanel();
        return tablePanel == null ? null : tablePanel.getTable();
    }

    public void setValueField(TngFieldString valueField) {
        this.valueField = valueField;
    }

    public TngFieldString getValueField() {
        return this.valueField;
    }

    public void setValueFieldExpression(String valueFieldExpression) {
        this.valueFieldExpression = valueFieldExpression;
    }

    public String getValueFieldExpression() {
        return this.valueFieldExpression;
    }

    public void setFilterLink(boolean filterLink) {
        this.filterLink = filterLink;
    }

    public boolean isFilterLink() {
        return this.filterLink;
    }

    public void setKeyColumnUser(String keyColumnUser) {
        this.keyColumnUser = keyColumnUser;
    }

    public String getKeyColumnUser() {
        return this.keyColumnUser;
    }

    protected String getKeyColumn() {
        String keyColumnUser = this.getKeyColumnUser();
        if (!TngUtilities.isEmpty(keyColumnUser)) {
            return keyColumnUser;
        }
        if (TngUtilities.isEmpty(this.keyColumn)) {
            this.keyColumn = this.keyColumnResolve();
        }
        return this.keyColumn;
    }

    protected String keyColumnResolve() {
        return null;
    }

    @Override
    protected String getDesignInfo() {
        String h2 = super.getDesignInfo();
        h2 = h2 + " link";
        return h2;
    }

    @Override
    protected String valueCheck(String text) {
        String e2 = super.valueCheck(text);
        if (e2 != null) {
            return e2;
        }
        if (text.length() == 0 || this.isFilterLink()) {
            return null;
        }
        return this.valueCheckLink(text);
    }

    private String valueCheckLink(String text) {
        if (this.getTablePanel() == null) {
            return Nat.x("Nedefinovan\u00fd \u010d\u00edseln\u00edk");
        }
        if (this.getTablePanel().getTableModel() == null) {
            return Nat.x("Nedefinovan\u00fd tabu\u013ekov\u00fd model \u010d\u00edseln\u00edka");
        }
        return this.valueCheckLinkValue(text);
    }

    protected String valueCheckLinkValue(String text) {
        return null;
    }

    @Override
    protected void openWizardDef(String text) {
        if (this.getTablePanel() == null || this.getTable() == null || this.getTableModel() == null) {
            return;
        }
        this.linkOpen(text);
    }

    protected void linkOpen(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TngTablePanel tablePanel = TngFieldLink.this.getTablePanel();
                TngTableModel tableModel = TngFieldLink.this.getTableModel();
                TngTable table = TngFieldLink.this.getTable();
                int keyColumnPosition = tableModel.getColumnPosition(TngFieldLink.this.getKeyColumn());
                tablePanel.tableRefresh();
                if (!TngUtilities.isEmpty(text)) {
                    if (tablePanel.isMultiSelectEnabled()) {
                        table.findMulti(keyColumnPosition, text);
                    } else {
                        table.findSingle(keyColumnPosition, text);
                    }
                }
                if (TngDlg.runModal(tablePanel, 0)) {
                    TngFieldLink.this.linkOpened(TngFieldLink.this.loadLinkValues());
                }
                TngFieldLink.this.inCheckForRecursive = false;
                TngFieldLink.this.lastCheckedText = null;
                TngFieldLink.this.setString(TngFieldLink.this.getText());
            }
        });
    }

    protected List<Map<String, String>> loadLinkValues() {
        TngTableModel tableModel = this.getTableModel();
        TngTable table = this.getTable();
        ArrayList<Map<String, String>> linkValues = new ArrayList<Map<String, String>>();
        Iterator<Integer> iter = tableModel.getIteratorMarkSelect();
        if (iter.hasNext()) {
            while (iter.hasNext()) {
                int ir = iter.next();
                int row = tableModel.getTabularRow(ir);
                linkValues.add(this.loadSingleRowLinkValues(row));
            }
        } else {
            linkValues.add(this.loadSingleRowLinkValues(table.getSelectedRow()));
        }
        return linkValues;
    }

    protected Map<String, String> loadSingleRowLinkValues(int rowIndex) {
        TngTableModel tableModel = this.getTableModel();
        TngTable table = this.getTable();
        HashMap<String, String> rowLinkValues = new HashMap<String, String>();
        int columnIndex = 0;
        for (TngTableColumn column : tableModel.getColumns()) {
            String columnName = column.name;
            String columnValue = table.getColumnValueAsString(rowIndex, columnIndex++);
            rowLinkValues.put(columnName, columnValue);
        }
        return rowLinkValues;
    }

    protected void linkOpened(List<Map<String, String>> linkValues) {
        if (linkValues == null || linkValues.size() == 0) {
            return;
        }
        TngTableModel tableModel = this.getTableModel();
        int keyColumnPosition = tableModel.getColumnPosition(this.getKeyColumn());
        TngTableColumn tableColumn = tableModel.getColumns()[keyColumnPosition];
        if (tableColumn == null) {
            return;
        }
        String keyColumnName = tableColumn.name;
        String linkValue = "";
        if (linkValues.size() == 1) {
            Map<String, String> rowLinkValues = linkValues.get(0);
            linkValue = rowLinkValues.get(keyColumnName);
        } else {
            StringBuilder linkValueBuilder = new StringBuilder();
            for (int i2 = 0; i2 < linkValues.size(); ++i2) {
                Map<String, String> rowLinkValues = linkValues.get(i2);
                linkValueBuilder.append(rowLinkValues.get(keyColumnName));
                if (i2 >= linkValues.size() - 1) continue;
                linkValueBuilder.append(",");
            }
            linkValue = linkValueBuilder.toString();
        }
        if (!TngUtilities.isEmpty(linkValue)) {
            this.setString(linkValue);
        }
    }

    protected void valueFieldChanged(TngValueEvent e2) {
    }
}

