/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.component.field;

import java.awt.FontMetrics;
import tangram.exception.TngExceptionNovalid;
import tangram.interfaces.TngValuable;
import tangram.library.Nat;
import tangram.swing.component.field.TngField;

public class TngFieldPassword
extends TngField
implements TngValuable {
    protected int valueSize = 0;

    public TngFieldPassword() {
        this.setEchoChar('*');
    }

    public Class getValueClass() {
        return String.class;
    }

    @Override
    public Object getValue() throws Exception {
        return this.getPsswd();
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof String) {
            this.setPsswd((String)value);
        } else {
            this.setPsswd(value == null ? null : value.toString());
        }
    }

    @Override
    @Deprecated
    public char[] getPassword() {
        return super.getPassword();
    }

    public String getPsswd() throws TngExceptionNovalid {
        this.check();
        if (this.valueError != null) {
            throw new TngExceptionNovalid(this, this.valueError);
        }
        return this.getTextTrimed();
    }

    public String getPsswdDef(String def) {
        this.check();
        if (this.valueError != null) {
            return def;
        }
        return this.getTextTrimed();
    }

    public void setPsswd(String value) {
        this.setTextAndCheck(value);
    }

    public int getValueSize() {
        return this.valueSize;
    }

    public void setValueSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Size is bad.");
        }
        if (this.valueSize != size) {
            this.lastCheckedText = null;
            this.valueSize = size;
            this.setColumns(size);
        }
    }

    @Override
    protected String getDesignInfo() {
        String h2 = super.getDesignInfo();
        h2 = h2 + " password(" + this.valueSize + ")";
        return h2;
    }

    @Override
    protected String valueCheck(String text) {
        String e2 = super.valueCheck(text);
        if (e2 != null) {
            return e2;
        }
        if (this.valueSize > 0 && text.length() > this.valueSize) {
            return Nat.x("D\u013a\u017eka hesla presiahla maximum %1 znakov", this.valueSize);
        }
        return null;
    }

    @Override
    protected int inputCheck(char c2, StringBuilder text, int position) {
        if (this.valueSize > 0 && text.length() >= this.valueSize) {
            return -1;
        }
        text.insert(position, c2);
        return position + 1;
    }

    @Override
    public void cut() {
        this.beep();
    }

    @Override
    public void copy() {
        this.beep();
    }

    @Override
    protected boolean canCopy() {
        return false;
    }

    @Override
    protected boolean canCut() {
        return false;
    }

    @Override
    protected int getColumnWidth() {
        if (this.columnWidth == 0) {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            this.columnWidth = metrics.charWidth('W') + 1;
        }
        return this.columnWidth;
    }
}

