/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.component.field;

import java.awt.FontMetrics;
import java.text.Normalizer;
import tangram.exception.TngExceptionNovalid;
import tangram.interfaces.TngValuable;
import tangram.library.Nat;
import tangram.swing.component.field.TngField;

public class TngFieldString
extends TngField
implements TngValuable {
    public static final int FORMAT_TEXT = 0;
    public static final int FORMAT_UPPERCASE = 1;
    public static final int FORMAT_LOWERCASE = 2;
    public static final int FORMAT_CODE = 3;
    public static final int FORMAT_NUMERAL = 4;
    protected int valueSize = 0;
    protected int valueFormat = 0;
    private static final String CODE_CHAR_NOT_ALLOWED = "'`\"\\";
    private static final String[] formatNamesUser = new String[]{Nat.x("text"), Nat.x("ve\u013ek\u00e9 p\u00edsmen\u00e1"), Nat.x("mal\u00e9 p\u00edsmen\u00e1"), Nat.x("k\u00f3d"), Nat.x("\u010d\u00edslice")};
    private static final String[] formatNamesDesign = new String[]{"text", "uppercase", "lowercase", "code", "numeral"};

    public Class getValueClass() {
        return String.class;
    }

    @Override
    public Object getValue() throws Exception {
        return this.getString();
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof String) {
            this.setString((String)value);
        } else {
            this.setTextAndCheck(value == null ? null : value.toString());
        }
    }

    public String getString() throws TngExceptionNovalid {
        this.check();
        if (this.valueError != null) {
            throw new TngExceptionNovalid(this, this.valueError);
        }
        return this.getTextTrimed();
    }

    public String getStringDef(String def) {
        this.check();
        if (this.valueError != null) {
            return def;
        }
        return this.getTextTrimed();
    }

    public void setString(String value) {
        this.setTextAndCheck(value);
    }

    public void setStringWithCut(String value) {
        if (this.valueSize > 0 && value != null && value.length() > this.valueSize) {
            value = value.substring(0, this.valueSize);
        }
        this.setTextAndCheck(value);
    }

    public int getValueSize() {
        return this.valueSize;
    }

    public void setValueSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size less than zero.");
        }
        if (this.valueSize != size) {
            this.lastCheckedText = null;
            this.valueSize = size;
            this.setColumns(size);
        }
    }

    public int getValueFormat() {
        return this.valueFormat;
    }

    public void setValueFormat(int format) {
        if (this.valueFormat != format) {
            this.lastCheckedText = null;
            this.valueFormat = format;
            this.columnWidth = 0;
        }
    }

    public int checkText(String text) {
        if (text == null || text.length() == 0) {
            return -1;
        }
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char c2 = text.charAt(i2);
            if (c2 == this.reformatChar(c2)) continue;
            return i2;
        }
        return -1;
    }

    public char reformatChar(char c2) {
        if (this.valueFormat == 1) {
            return Character.toUpperCase(c2);
        }
        if (this.valueFormat == 2) {
            return Character.toLowerCase(c2);
        }
        if (this.valueFormat == 3) {
            return TngFieldString.toCodeChar(c2);
        }
        if (this.valueFormat == 4) {
            return this.toNumberChar(c2);
        }
        return c2;
    }

    public String reformatText(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        if (this.valueSize > 0 && text.length() > this.valueSize) {
            text = text.substring(0, this.valueSize);
        }
        if (this.valueFormat == 1) {
            return text.toUpperCase();
        }
        if (this.valueFormat == 2) {
            return text.toUpperCase();
        }
        if (this.valueFormat == 3) {
            return TngFieldString.toCode(text);
        }
        if (this.valueFormat == 4) {
            return this.toNumber(text);
        }
        return text;
    }

    public static String toCode(String text) {
        StringBuilder code = new StringBuilder(text.length());
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char c2 = TngFieldString.toCodeChar(text.charAt(i2));
            if (c2 == '\u0000') {
                c2 = '?';
            }
            code.append(c2);
        }
        return code.toString();
    }

    public static char toCodeChar(char c2) {
        if (c2 < ' ') {
            return '\u0000';
        }
        if (c2 <= '~') {
            if (CODE_CHAR_NOT_ALLOWED.indexOf(c2) >= 0) {
                return '\u0000';
            }
            return Character.toUpperCase(c2);
        }
        StringBuilder s2 = new StringBuilder(1);
        s2.append(c2);
        String nfd = Normalizer.normalize(s2, Normalizer.Form.NFD);
        if (nfd != null && nfd.length() > 0 && nfd.charAt(0) != '?') {
            return Character.toUpperCase(nfd.charAt(0));
        }
        return '\u0000';
    }

    private char toNumberChar(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2;
        }
        return '\u0000';
    }

    private String toNumber(String text) {
        StringBuilder code = new StringBuilder(text.length());
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char c2 = this.toNumberChar(text.charAt(i2));
            if (c2 == '\u0000') continue;
            code.append(c2);
        }
        return code.toString();
    }

    public String getFormatNameUser() {
        int i2 = this.valueFormat > formatNamesUser.length ? 0 : this.valueFormat;
        return formatNamesUser[i2];
    }

    public String getFormatNameDesign() {
        int i2 = this.valueFormat > formatNamesDesign.length ? 0 : this.valueFormat;
        return formatNamesDesign[i2];
    }

    @Override
    protected String getDesignInfo() {
        String h2 = super.getDesignInfo();
        h2 = h2 + " char(" + this.valueSize + ")";
        h2 = h2 + " " + this.getFormatNameDesign();
        return h2;
    }

    @Override
    protected String valueCheck(String text) {
        String e2 = super.valueCheck(text);
        if (e2 != null) {
            return e2;
        }
        if (this.valueSize > 0 && text.length() > this.valueSize) {
            return Nat.x("D\u013a\u017eka textu presiahla maximum %1 znakov", this.valueSize);
        }
        int invalidCharPos = this.checkText(text);
        if (invalidCharPos >= 0) {
            char invalidChar = text.charAt(invalidCharPos);
            return Nat.x("Na %1. poz\u00edcii je neplatn\u00fd znak %2 pre form\u00e1t %3", invalidCharPos + 1, Character.valueOf(invalidChar), this.getFormatNameUser());
        }
        return null;
    }

    @Override
    protected void openWizardDef(String text) {
        this.beep();
    }

    @Override
    protected int inputCheck(char c2, StringBuilder text, int position) {
        if (this.valueSize > 0 && text.length() >= this.valueSize) {
            return -1;
        }
        if ((c2 = this.reformatChar(c2)) == '\u0000') {
            return -1;
        }
        text.insert(position, c2);
        return position + 1;
    }

    @Override
    protected int getColumnWidth() {
        if (this.columnWidth == 0) {
            char ch = this.valueFormat == 2 ? (char)'w' : 'W';
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            this.columnWidth = metrics.charWidth(ch) + 1;
        }
        return this.columnWidth;
    }
}

