/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.container;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import tangram.interfaces.TngContextable;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;
import tangram.swing.container.TngMenuItem;
import tangram.swing.container.TngPopupMenu;
import tangram.swing.icon.TngIcon;

public class TngContextMenu
extends TngPopupMenu
implements PopupMenuListener {
    private TngMenuItem undo = new TngMenuItem();
    private TngMenuItem redo = new TngMenuItem();
    private TngMenuItem cut = new TngMenuItem();
    private TngMenuItem copy = new TngMenuItem();
    private TngMenuItem paste = new TngMenuItem();
    private TngMenuItem wizard = new TngMenuItem();
    private TngContextable component;

    public TngContextMenu(TngContextable component) {
        this.component = component;
        try {
            this.jbInit();
            this.addPopupMenuListener(this);
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
        this.undo.setText(Nat.x("&Sp\u00e4\u0165"));
        this.undo.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.undo.setIcon(TngIcon.getIcon("popup_undo.png"));
        this.undo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngContextMenu.this.doContextAction(1);
            }
        });
        this.redo.setText(Nat.x("&Znovu"));
        this.redo.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.redo.setIcon(TngIcon.getIcon("popup_redo.png"));
        this.redo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngContextMenu.this.doContextAction(2);
            }
        });
        this.cut.setText(Nat.x("Vys&trihn\u00fa\u0165"));
        this.cut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.cut.setIcon(TngIcon.getIcon("popup_cut.png"));
        this.cut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngContextMenu.this.doContextAction(3);
            }
        });
        this.copy.setText(Nat.x("&Kop\u00edrova\u0165"));
        this.copy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.copy.setIcon(TngIcon.getIcon("popup_copy.png"));
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngContextMenu.this.doContextAction(4);
            }
        });
        this.paste.setText(Nat.x("&Vlo\u017ei\u0165"));
        this.paste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.paste.setIcon(TngIcon.getIcon("popup_paste.png"));
        this.paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngContextMenu.this.doContextAction(5);
            }
        });
        this.wizard.setText(Nat.x("&Pomocn\u00edk"));
        this.wizard.setAccelerator(KeyStroke.getKeyStroke(155, 0));
        this.wizard.setIcon(TngIcon.getIcon("wizard.png"));
        this.wizard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngContextMenu.this.doContextAction(6);
            }
        });
        this.add(this.undo);
        this.add(this.redo);
        this.addSeparator();
        this.add(this.cut);
        this.add(this.copy);
        this.add(this.paste);
        this.addSeparator();
        this.add(this.wizard);
    }

    private void doContextAction(int actionId) {
        this.component.doContextAction(actionId);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
        this.undo.setEnabled(this.component.isContextActionEnabled(1));
        this.redo.setEnabled(this.component.isContextActionEnabled(2));
        this.cut.setEnabled(this.component.isContextActionEnabled(3));
        this.copy.setEnabled(this.component.isContextActionEnabled(4));
        this.paste.setEnabled(this.component.isContextActionEnabled(5) && TngUtilities.getClipboardAsString() != null);
        this.wizard.setEnabled(this.component.isContextActionEnabled(6));
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e2) {
    }
}

