/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.icon;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;

public class TngIcon {
    private static final Class defaultResourceObject = new TngIcon().getClass();
    private static String customPath;
    private static Class resourceObject;
    private static ImageIcon unknownIcon;
    private static HashMap<String, ImageIcon> icons;

    public static void setResources(String custom, Class resource) {
        icons.clear();
        resourceObject = resource;
        customPath = custom;
        unknownIcon = TngIcon.loadIconResource(resourceObject, "unknown.png");
    }

    public static ImageIcon getIcon(String name) {
        if (name == null || name.length() == 0) {
            return unknownIcon;
        }
        ImageIcon icon = icons.get(name);
        if (icon != null) {
            return icon;
        }
        icon = TngIcon.getIconNoCached(name);
        icons.put(name, icon);
        return icon;
    }

    public static ImageIcon getIconNoCached(String name) {
        if (name == null || name.length() == 0) {
            return unknownIcon;
        }
        ImageIcon icon = TngIcon.loadIconByPath(customPath, name);
        if (icon != null) {
            return icon;
        }
        icon = TngIcon.loadIconResource(resourceObject, name);
        if (icon != null) {
            return icon;
        }
        icon = TngIcon.loadIconResource(defaultResourceObject, name);
        if (icon != null) {
            return icon;
        }
        return unknownIcon;
    }

    public static ImageIcon loadIconByPath(String path, String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (path != null && path.length() != 0) {
            name = path + "/" + name;
        }
        if (!new File(name).exists()) {
            return null;
        }
        ImageIcon icon = new ImageIcon(name);
        return icon;
    }

    public static ImageIcon loadIconResource(Class resource, String name) {
        if (resource == null || name == null || name.length() == 0) {
            return null;
        }
        URL url = resource.getResource("images/" + name);
        if (url == null) {
            return null;
        }
        ImageIcon icon = new ImageIcon(url);
        return icon;
    }

    static {
        resourceObject = defaultResourceObject;
        icons = new HashMap();
    }
}

