/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.panel;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.swing.TngActionListenerLater;
import tangram.swing.TngInformationListener;
import tangram.swing.TngSwing;
import tangram.swing.TngValidationError;
import tangram.swing.component.button.TngButton;
import tangram.swing.component.button.TngButtonCancel;
import tangram.swing.component.button.TngButtonCustom;
import tangram.swing.component.button.TngButtonOK;
import tangram.swing.panel.TngPanel;

public class TngDlg
extends JDialog {
    public static final int FLAG_NONE = 0;
    public static final int FLAG_OK = 1;
    public static final int FLAG_CANCEL = 2;
    public static final int FLAG_CUSTOM = 4;
    public static final int FLAG_KEYBOARD = 8;
    public static final int FLAG_NORESIZE = 16;
    public static final int FLAG_SAVE_ON_ENTER = 32;
    public static final int FLAG_EXCEPTION = 64;
    public static final int FLAG_UNDECORATED = 128;
    public static final int ACTION_SAVE = 1;
    public static final int ACTION_CUSTOM = 2;
    private int flag = 0;
    private boolean saved = false;
    private JPanel bottomPanel = new JPanel();
    protected JComponent jContent = new JButton();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private TngButtonOK jOk = new TngButtonOK();
    private TngButtonCancel jCancel = new TngButtonCancel();
    private TngButtonCustom jCustom = new TngButtonCustom();
    private TngButton jClose;
    private static int counter = 0;
    private int saveAction = 1;

    public static boolean runModal(JComponent content) {
        return TngDlg.runModal(content, 3);
    }

    public static boolean runModal(JComponent content, int flag) {
        TngDlg d2 = new TngDlg(TngSwing.mainWindow, content, null, flag);
        TngSwing.windowCenter(d2);
        return d2.showModal();
    }

    public TngDlg() {
    }

    public TngDlg(JDialog parent, JComponent content, String title, int flag) {
        super((Dialog)parent, TngDlg.resolveTitle(title, content));
        this.jContent = content;
        this.flag = flag;
        try {
            this.jbInit();
        }
        catch (Throwable e2) {
            if ((flag & 0x40) != 0) {
                e2.printStackTrace();
            }
            TngSwing.exceptionShow(e2);
        }
    }

    public TngDlg(JFrame parent, JComponent content, String title, int flag) {
        super((Frame)parent, TngDlg.resolveTitle(title, content));
        this.jContent = content;
        this.flag = flag;
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            if ((flag & 0x40) != 0) {
                e2.printStackTrace();
            }
            TngSwing.exceptionShow(e2);
        }
    }

    public TngDlg(JFrame parent, JComponent content, boolean noShowException) {
        super((Frame)parent, TngDlg.resolveTitle(null, content));
        this.jContent = content;
        this.flag = 2;
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            if (noShowException) {
                e2.printStackTrace();
            }
            TngSwing.exceptionShow(e2);
        }
    }

    public static String resolveTitle(String def, Component content) {
        if (def != null) {
            return def;
        }
        if (content instanceof TngPanel) {
            return ((TngPanel)content).getTitle();
        }
        return null;
    }

    public boolean isOk() {
        return (this.flag & 1) != 0;
    }

    public boolean isCancel() {
        return (this.flag & 2) != 0;
    }

    public boolean isCustom() {
        return (this.flag & 4) != 0;
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.gridBagLayout3);
        this.setDefaultCloseOperation(0);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e2) {
                TngDlg.this.this_componentShown(e2);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                if (TngDlg.this.jClose != null) {
                    TngDlg.this.jClose.doClick();
                } else if (TngDlg.this.isCancel()) {
                    TngDlg.this.buttonCancelPressed();
                } else if (TngDlg.this.isOk()) {
                    TngDlg.this.buttonOkPressed();
                }
            }
        });
        this.bottomPanel.setLayout(this.gridBagLayout1);
        this.jOk.addActionListener(new TngActionListenerLater(){

            @Override
            public void actionPerformedLater(ActionEvent e2) {
                TngDlg.this.buttonOkPressed();
            }
        });
        this.jCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngDlg.this.buttonCancelPressed();
            }
        });
        this.jCustom.addActionListener(new TngActionListenerLater(){

            @Override
            public void actionPerformedLater(ActionEvent e2) {
                TngDlg.this.buttonCustomPressed();
            }
        });
        this.bottomPanel.add((Component)this.jCustom, new GridBagConstraints(0, 0, 1, 1, this.isCustom() && (this.isOk() || this.isCancel()) ? 1.0 : 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 3), 0, 0));
        this.bottomPanel.add((Component)this.jOk, new GridBagConstraints(1, 0, 1, 1, !this.isCustom() && this.isCancel() ? 1.0 : 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 3), 0, 0));
        this.bottomPanel.add((Component)this.jCancel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 7), 0, 0));
        this.getContentPane().add((Component)this.bottomPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.getContentPane().add((Component)this.jContent, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 6, 3, 6), 0, 0));
        this.resolveButtons();
        this.resolveSize();
        this.resolveInfoListener();
    }

    private void resolveSize() {
        Dimension s2 = this.jContent.getSize();
        if (s2 != null && s2.width > 0 && s2.height > 0) {
            this.jContent.setPreferredSize(s2);
        }
        this.setResizable((this.flag & 0x10) == 0);
        this.setUndecorated((this.flag & 0x80) != 0);
        this.pack();
    }

    private void resolveButtons() {
        this.jCancel.setVisible(this.isCancel());
        this.jOk.setVisible(this.isOk());
        this.jCustom.setVisible(this.isCustom());
        this.bottomPanel.setVisible(this.isCustom() || this.isCancel() || this.isOk());
        if ((this.flag & 0x20) != 0) {
            this.jOk.saveOnEnter();
        }
        if (this.isOk() && !this.isCancel()) {
            this.jOk.setText(Nat.x("Zavrie\u0165"));
            this.jOk.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    TngDlg.this.jOk.doClick();
                }
            }, KeyStroke.getKeyStroke(27, 0), 2);
        }
        if (!this.isOk() && this.isCancel()) {
            this.jCancel.setText(Nat.x("Zavrie\u0165"));
        }
    }

    public void setCloseButton(TngButton closeButton) {
        this.jClose = closeButton;
    }

    private void resolveInfoListener() {
        new TngInformationListener(this.jContent){

            @Override
            protected String getInfo() {
                StringBuilder infoBuilder = new StringBuilder();
                try {
                    TngDlg.this.doDebugInfo(infoBuilder);
                }
                catch (Exception e2) {
                    infoBuilder.append(TngUtilities.exceptionText(e2));
                }
                return infoBuilder.toString();
            }

            @Override
            protected void showInfo(String msg) {
                if (msg != null) {
                    TngSwing.htmlShow("DEBUG info", msg);
                }
            }
        };
    }

    public static boolean isAnyActive() {
        return counter > 0;
    }

    public boolean showModal() {
        Frame frame = (Frame)this.getParent();
        this.setLocationRelativeTo(frame);
        ++counter;
        this.saved = false;
        this.setModal(true);
        if (!TngPanel.beforeShowAll(this)) {
            this.buttonCancelPressed();
        } else {
            this.setVisible(true);
        }
        --counter;
        return this.saved;
    }

    public void showNomodal() {
        Frame frame = (Frame)this.getParent();
        this.setLocationRelativeTo(frame);
        this.saved = false;
        this.setModal(false);
        if (!TngPanel.beforeShowAll(this)) {
            this.buttonCancelPressed();
        } else {
            this.setVisible(true);
        }
    }

    public void setSaved() {
        this.saved = true;
    }

    public boolean isSaved() {
        return this.saved;
    }

    protected void doValidate(TngValidationError errors) {
        TngPanel.validateAll(this, errors);
    }

    protected boolean doSave() throws Exception {
        this.saveAction = 1;
        return TngPanel.saveAll(this);
    }

    protected boolean doCancel() throws Exception {
        return TngPanel.cancelAll(this);
    }

    protected boolean doCustom() throws Exception {
        this.saveAction = 2;
        return TngPanel.saveAll(this);
    }

    protected void doDebugInfo(StringBuilder info) throws Exception {
        TngPanel.debugInfoAll(this, info);
    }

    public int getSaveAction() {
        return this.saveAction;
    }

    public void setSaveAction(int action) {
        this.saveAction = action;
    }

    private void this_componentShown(ComponentEvent e2) {
        TngPanel.afterShowAll(this);
    }

    public TngButton getOkButton() {
        return this.jOk;
    }

    public void buttonOkAction() {
        this.jOk.doClick();
    }

    public TngButton getCancelButton() {
        return this.jCancel;
    }

    public void buttonCancelAction() {
        this.jCancel.doClick();
    }

    public TngButton getCustomButton() {
        return this.jCustom;
    }

    public void buttonCustomAction() {
        this.jCustom.doClick();
    }

    protected void buttonOkPressed() {
        try {
            TngPanel topPanel;
            if (this.jContent instanceof TngPanel && !(topPanel = (TngPanel)this.jContent).doInitSaveTopPanel()) {
                return;
            }
            TngValidationError errors = new TngValidationError();
            this.doValidate(errors);
            if (errors.hasError()) {
                TngSwing.msgNovalid(errors.getError(0), errors.getComponent(0));
                return;
            }
            if (!this.doSave()) {
                return;
            }
            this.saved = true;
            this.dispose();
        }
        catch (Throwable e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    protected void buttonCancelPressed() {
        try {
            if (!this.doCancel()) {
                return;
            }
            this.dispose();
        }
        catch (Throwable e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    protected void buttonCustomPressed() {
        try {
            if (!this.doCustom()) {
                return;
            }
            this.dispose();
        }
        catch (Throwable e2) {
            TngSwing.exceptionShow(e2);
        }
    }
}

