/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tangram.library.Nat;
import tangram.library.TngOrderNamed;
import tangram.swing.TngSwing;
import tangram.swing.component.TngLabel;
import tangram.swing.component.TngList;
import tangram.swing.component.button.TngButton;
import tangram.swing.component.field.TngFieldString;
import tangram.swing.container.TngScrollPane;
import tangram.swing.panel.TngDlg;
import tangram.swing.panel.TngPanel;
import tangram.swing.panel.TngPanelWizardOrder;
import tangram.swing.table.component.TngTableColumn;

public class TngPanelOrder
extends TngPanel {
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private TngScrollPane jScrollPane1 = new TngScrollPane();
    private TngList jNames = new TngList();
    private TngButton jOrderWizard = new TngButton();
    private TngFieldString jActualOrderInfo = new TngFieldString();
    private TngLabel jLabel1 = new TngLabel();
    private TngLabel jLabel2 = new TngLabel();
    private DefaultListModel dlm = new DefaultListModel();
    private TngOrderNamed[] names;
    private TngTableColumn[] columns;
    private TngOrderNamed other;

    public TngPanelOrder(TngOrderNamed[] names, TngTableColumn[] columns, String order) {
        try {
            this.jbInit();
            this.setData(names, columns, order);
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(345, 285));
        this.setTitle(Nat.x("Usporiadanie"));
        this.setLayout(this.gridBagLayout1);
        this.jOrderWizard.setText(Nat.x("Zmeni\u0165 usporiadanie"));
        this.jOrderWizard.setToolTipText(Nat.x("Zmeni\u0165 usporiadanie") + Nat.nox("<F9>"));
        this.jOrderWizard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngPanelOrder.this.jOrderWizard_actionPerformed(e2);
            }
        });
        this.jOrderWizard.setFocusable(true);
        this.jOrderWizard.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngPanelOrder.this.wizard();
            }
        }, KeyStroke.getKeyStroke(120, 0), 2);
        this.jActualOrderInfo.setEditable(false);
        this.jActualOrderInfo.setFocusable(false);
        this.jLabel1.setText(Nat.x("Aktu\u00e1lne usporiadanie"));
        this.jLabel2.setText(Nat.x("Mo\u017enosti usporiadania"));
        this.jScrollPane1.getViewport().add((Component)this.jNames, null);
        this.add((Component)this.jScrollPane1, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jOrderWizard, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.jActualOrderInfo, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.jLabel1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 16, 0, new Insets(6, 0, 0, 0), 0, 0));
        this.add((Component)this.jLabel2, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jNames.setModel(this.dlm);
        this.jNames.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                TngPanelOrder.this.jNames_valueChanged(e2);
            }
        });
    }

    private void jOrderWizard_actionPerformed(ActionEvent e2) {
        this.wizard();
    }

    public String getOrder() {
        TngOrderNamed o2 = (TngOrderNamed)this.jNames.getSelectedValue();
        if (o2 == null) {
            return "";
        }
        return o2.getOrder();
    }

    public String getOrderDescription() {
        return TngOrderNamed.createDescription(this.columns, this.getOrder());
    }

    public void setData(TngOrderNamed[] names, TngTableColumn[] columns, String order) {
        this.columns = columns;
        this.jOrderWizard.setEnabled(columns != null && columns.length != 0);
        this.setNames(names);
        int i2 = TngOrderNamed.find(names, order);
        if (i2 >= 0) {
            this.jNames.setSelectedIndex(i2);
        } else if (order != null && order.length() != 0) {
            this.setOtherOrder(order);
        }
    }

    private void setNames(TngOrderNamed[] names) {
        this.dlm.clear();
        if (names == null) {
            return;
        }
        for (int i2 = 0; i2 < names.length; ++i2) {
            this.dlm.addElement(names[i2]);
        }
    }

    private void setOtherOrder(String order) {
        int i2 = this.dlm.indexOf(this.other);
        this.other = new TngOrderNamed(Nat.x("Vlastn\u00e9 usporiadanie"), order);
        if (i2 < 0) {
            this.dlm.addElement(this.other);
        } else {
            this.dlm.setElementAt(this.other, i2);
        }
        this.jNames.setSelectedValue(this.other, true);
        this.orderChanged();
    }

    private void orderChanged() {
        String info = this.getOrder();
        if (this.columns != null) {
            info = TngOrderNamed.createDescription(this.columns, info);
        }
        this.jActualOrderInfo.setString(info);
    }

    private void wizard() {
        TngPanelWizardOrder p2 = new TngPanelWizardOrder();
        p2.setTitle(Nat.x("Vlastn\u00e9 usporiadanie"));
        p2.setData(this.columns, this.getOrder(), true);
        if (!TngDlg.runModal(p2)) {
            return;
        }
        this.setOtherOrder(p2.getOrder());
    }

    private void jNames_valueChanged(ListSelectionEvent e2) {
        if (!e2.getValueIsAdjusting()) {
            this.orderChanged();
        }
    }
}

