/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.progress;

import javax.swing.JProgressBar;

public class TngProgressBar
extends JProgressBar {
    private int segments;
    private int segment;
    private int granulation;
    private double resize;
    private int offset;
    private long delta;
    private long segmax;
    private long valueActual;
    private long valueSpeed;

    public void setMaximum(int segments, int segment, long n2) {
        this.segments = segments;
        this.segment = segment;
        this.segmax = n2;
        this.granulation = 100;
        this.valueActual = 0L;
        this.valueSpeed = 0L;
        if (n2 < 0L) {
            this.resize = 0.0;
            this.delta = 0L;
            this.offset = 0;
            this.setIndeterminate(true);
            this.setStringPainted(false);
            super.setMaximum(0);
            super.setValue(0);
        } else {
            this.resize = (double)this.granulation / (double)n2;
            this.delta = n2 < (long)this.granulation ? 1L : n2 / (long)this.granulation;
            this.offset = segment < 1 ? 0 : (segment - 1) * this.granulation;
            this.setIndeterminate(false);
            this.setStringPainted(true);
            super.setMaximum(segments * this.granulation);
            super.setValue(this.offset);
        }
    }

    @Override
    public String getString() {
        String t2;
        String string = t2 = this.progressString == null ? "" : this.progressString;
        if (this.segments > 1) {
            t2 = t2 + " " + this.segment + "/" + this.segments;
        }
        if (this.isIndeterminate()) {
            return t2;
        }
        int p2 = (int)(this.getPercentComplete() * 100.0);
        return p2 + "% " + t2;
    }

    @Override
    public void setMaximum(int n2) {
        this.setMaximum(1, 1, n2);
    }

    public void setMaximum(long n2) {
        this.setMaximum(1, 1, n2);
    }

    public void addValue(long n2) {
        this.setValue(this.valueActual + n2);
    }

    @Override
    public void setValue(int n2) {
        this.setValue((long)n2);
    }

    public void setValue(long n2) {
        this.valueActual = n2;
        if (this.delta > 0L) {
            if (n2 >= this.segmax) {
                super.setValue(this.offset + this.granulation);
            } else if (n2 >= this.valueSpeed + this.delta) {
                this.valueSpeed = n2;
                int p2 = this.offset + (int)((double)n2 * this.resize);
                super.setValue(p2);
            }
        }
    }
}

