/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.progress;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.swing.component.TngLabel;
import tangram.swing.icon.TngIcon;
import tangram.swing.progress.TngProgressInterface;

public class TngProgressDouble
extends JDialog
implements TngProgressInterface {
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private TngLabel jOperation = new TngLabel();
    private TngLabel jStatus = new TngLabel();
    private JProgressBar jProgressBar = new JProgressBar();
    private JButton jCancel = new JButton();
    private JProgressBar jProgressBar1 = new JProgressBar();
    private TngLabel jStatus1 = new TngLabel();
    private TngLabel jOperation1 = new TngLabel();
    private int level = -1;
    private int prgLast = 0;
    private int prgDelta = 0;
    private int prgLast1 = 0;
    private int prgDelta1 = 0;
    private boolean canceled = false;

    public TngProgressDouble(Frame parent) {
        super(parent, Nat.x("Priebeh oper\u00e1cie"), false);
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngUtilities.exceptionLog(e2);
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(330, 204));
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.setDefaultCloseOperation(0);
        this.jOperation.setText(Nat.nox("operation"));
        this.jOperation.setFont(new Font("Dialog", 1, 11));
        this.jOperation.setHorizontalAlignment(0);
        this.jStatus.setText(Nat.nox("status"));
        this.jStatus.setHorizontalAlignment(0);
        this.jCancel.setText(Nat.x("Preru\u0161i\u0165"));
        this.jCancel.setIcon(TngIcon.getIcon("cancel.png"));
        this.jCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngProgressDouble.this.jCancel_actionPerformed(e2);
            }
        });
        this.jCancel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngProgressDouble.this.jCancel_actionPerformed(e2);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.jStatus1.setText(Nat.nox("status"));
        this.jStatus1.setHorizontalAlignment(0);
        this.jOperation1.setText(Nat.nox("operation"));
        this.jOperation1.setFont(new Font("Dialog", 1, 11));
        this.jOperation1.setHorizontalAlignment(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                TngProgressDouble.this.this_windowClosing(e2);
            }
        });
        this.getContentPane().add((Component)this.jOperation, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(6, 6, 0, 6), 200, 0));
        this.getContentPane().add((Component)this.jStatus, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(1, 6, 0, 6), 0, 0));
        this.getContentPane().add((Component)this.jProgressBar, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 6, 0, 6), 0, 3));
        this.getContentPane().add((Component)this.jCancel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 0, 6, 0), 0, 0));
        this.getContentPane().add((Component)this.jProgressBar1, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 6, 0, 6), 0, 3));
        this.getContentPane().add((Component)this.jStatus1, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.jOperation1, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(6, 6, 0, 6), 0, 0));
        this.setResizable(true);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void jCancel_actionPerformed(ActionEvent e2) {
        this.cancel();
    }

    private void this_windowClosing(WindowEvent e2) {
        this.cancel();
    }

    @Override
    public void start(String operation) {
        ++this.level;
        if (this.level == 0) {
            this.setVisible(true);
            this.jOperation.setText(operation);
            this.canceled = false;
            this.prgLast = 0;
            this.prgDelta = 0;
            this.jProgressBar.setMaximum(0);
            this.jProgressBar.setValue(0);
            this.jProgressBar.setIndeterminate(false);
            this.jProgressBar.setStringPainted(false);
            this.jStatus.setText(" ");
        }
        if (this.level == 1) {
            this.jOperation1.setText(operation);
            this.prgLast1 = 0;
            this.prgDelta1 = 0;
            this.jProgressBar1.setMaximum(0);
            this.jProgressBar1.setValue(0);
            this.jProgressBar1.setIndeterminate(false);
            this.jProgressBar1.setStringPainted(false);
            this.jStatus1.setText(" ");
        }
    }

    @Override
    public void end() {
        if (this.level < 0) {
            return;
        }
        if (--this.level >= 0) {
            return;
        }
    }

    @Override
    public void close() {
        this.dispose();
    }

    @Override
    public void setStatus(String status) {
        if (this.level == 0) {
            this.jStatus.setText(status == null && status.length() == 0 ? " " : status);
        } else if (this.level == 1) {
            this.jStatus1.setText(status == null && status.length() == 0 ? " " : status);
        }
    }

    @Override
    public boolean setProgress(int value) {
        if (this.level == 0 && this.prgDelta > 0 && value >= this.prgLast + this.prgDelta) {
            this.prgLast = value;
            this.jProgressBar.setValue(value);
        }
        if (this.level == 1 && this.prgDelta1 > 0 && value >= this.prgLast1 + this.prgDelta1) {
            this.prgLast1 = value;
            this.jProgressBar1.setValue(value);
        }
        return this.canceled;
    }

    public void discancel() {
        this.canceled = false;
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void setMax(int max) {
        if (this.level == 0) {
            this.prgDelta = this.setMaxLevel(this.jProgressBar, max);
        } else if (this.level == 1) {
            this.prgDelta1 = this.setMaxLevel(this.jProgressBar1, max);
        }
    }

    private int setMaxLevel(JProgressBar progress, int max) {
        int delta;
        if (max > 0) {
            progress.setMaximum(max);
            progress.setIndeterminate(false);
            progress.setStringPainted(true);
            delta = max / 100;
            if (delta < 1) {
                delta = 1;
            }
        } else {
            progress.setMaximum(0);
            progress.setIndeterminate(true);
            progress.setStringPainted(false);
            delta = 0;
        }
        return delta;
    }

    @Override
    public int getMax() {
        if (this.level == 0) {
            return this.jProgressBar.getMaximum();
        }
        if (this.level == 1) {
            return this.jProgressBar1.getMaximum();
        }
        return -1;
    }

    @Override
    public int getLevel() {
        return this.level;
    }
}

