/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.table.component;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import tangram.swing.table.component.TngTable;
import tangram.swing.table.model.TngTableModel;
import tangram.swing.table.model.TngTableModelRowHeader;
import tangram.swing.table.renderer.TngTableRendererRowHeader;

public class TngTableRowHeader
extends JList {
    protected TngTable table;

    public TngTableRowHeader(TngTable table) {
        super(new TngTableModelRowHeader(table));
        this.table = table;
        this.setFocusable(false);
        this.setBackground(null);
        this.setRowWidth(40);
        this.setRowHeight(table.getRowHeight());
        this.setCellRenderer(new TngTableRendererRowHeader());
        this.setSelectionModel(table.getSelectionModel());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                if (TngTableRowHeader.this.table.isRowMarkable()) {
                    TngTableRowHeader.this.markRowSelect();
                }
            }
        });
        this.setOpaque(false);
    }

    public TngTableModel getTableModel() {
        return this.table.getTableModel();
    }

    public void setRowWidth(int rowWidth) {
        this.setFixedCellWidth(rowWidth);
    }

    public void setRowHeight(int rowHeight) {
        this.setFixedCellHeight(rowHeight);
    }

    public void setRowBackground(Color bgColor) {
        this.setBackground(bgColor);
    }

    @Override
    public Rectangle getCellBounds(int index0, int index1) {
        int height;
        int y;
        Rectangle rect0 = this.table.getCellRect(index0, 0, true);
        Rectangle rect1 = this.table.getCellRect(index1, 0, true);
        if (rect0.y < rect1.y) {
            y = rect0.y;
            height = rect1.y + rect1.height - y;
        } else {
            y = rect1.y;
            height = rect0.y + rect0.height - y;
        }
        return new Rectangle(0, y, this.getFixedCellWidth(), height);
    }

    public void markRowSelect() {
        this.table.markRowSelect();
    }
}

