/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.table.component;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import tangram.swing.table.component.TngTable;
import tangram.swing.table.component.TngTableColumn;

public class TngTableUtils {
    public static int maxResizeColumn = 500;
    private static final int DEFAULT_ROWS_COUNT = 50;

    public static void tableAutoresizeAll(TngTable table, boolean canShrink) {
        int firstRow = 0;
        int lastRow = table.getRowCount() - 1;
        TngTableUtils.tableAutoresize(table, canShrink, true, firstRow, lastRow);
    }

    public static void tableAutoresizeVisible(TngTable table, boolean canShrink) {
        Rectangle vis = table.getVisibleRect();
        int firstRow = table.rowAtPoint(new Point(0, vis.y));
        int lastRow = -1;
        if (table.getHeight() > 0) {
            lastRow = table.rowAtPoint(new Point(0, vis.y + vis.height - 1));
        }
        if (lastRow < 0 && (lastRow = firstRow + 50) >= table.getRowCount()) {
            lastRow = table.getRowCount() - 1;
        }
        TngTableUtils.tableAutoresize(table, canShrink, true, firstRow, lastRow);
    }

    public static void tableAutoresizeVisibleLater(final TngTable table, final boolean canShrink) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TngTableUtils.tableAutoresizeVisible(table, canShrink);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public static void tableAutoresize(TngTable table, boolean canShrink, boolean withHeader, int firstRow, int lastRow) {
        DefaultTableColumnModel mc = (DefaultTableColumnModel)table.getColumnModel();
        int[] widths = new int[mc.getColumnCount()];
        for (int i2 = 0; i2 < widths.length; ++i2) {
            widths[i2] = canShrink ? 0 : mc.getColumn(i2).getPreferredWidth();
        }
        if (withHeader) {
            int width;
            Component c2;
            JTableHeader hdr = table.getTableHeader();
            for (int i3 = 0; i3 < widths.length; ++i3) {
                TableColumn col = mc.getColumn(i3);
                TableCellRenderer rend = col.getHeaderRenderer();
                if (rend == null) {
                    rend = hdr.getDefaultRenderer();
                }
                if (!((c2 = rend.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, i3)) instanceof JLabel)) continue;
                width = TngTableUtils.computeJLabelWidth((JLabel)c2) + 20;
                width = Math.min(width, maxResizeColumn);
                widths[i3] = Math.max(widths[i3], width);
            }
            if (firstRow < 0) {
                lastRow = -2;
            }
            int gap = ((DefaultTableColumnModel)table.getColumnModel()).getColumnMargin();
            for (int r2 = firstRow; r2 <= lastRow; ++r2) {
                for (int i4 = 0; i4 < widths.length; ++i4) {
                    c2 = table.prepareRenderer(table.getCellRenderer(r2, i4), r2, i4);
                    if (!(c2 instanceof JLabel)) continue;
                    width = TngTableUtils.computeJLabelWidth((JLabel)c2) + gap;
                    width = Math.min(width, maxResizeColumn);
                    widths[i4] = Math.max(widths[i4], width);
                }
            }
            for (int i5 = 0; i5 < widths.length; ++i5) {
                TngTableColumn c3 = table.getTableModel().getColumns()[i5];
                if (!c3.isVisible()) {
                    mc.getColumn(i5).setPreferredWidth(0);
                    mc.getColumn(i5).setMinWidth(0);
                    mc.getColumn(i5).setMaxWidth(0);
                    continue;
                }
                mc.getColumn(i5).setPreferredWidth(widths[i5]);
            }
        }
    }

    public static int computeJLabelWidth(JLabel component) {
        FontMetrics fm = component.getFontMetrics(component.getFont());
        int width = SwingUtilities.computeStringWidth(fm, component.getText());
        Insets is = component.getBorder().getBorderInsets(component);
        width += is.left + is.right + 2;
        if (component.getIcon() != null) {
            width += component.getIcon().getIconWidth() + component.getIconTextGap();
        }
        return width;
    }

    public static int getVisibleFirstRows(TngTable table) {
        Rectangle vis = table.getVisibleRect();
        if (vis.height == 0) {
            return 0;
        }
        return table.rowAtPoint(new Point(0, vis.y));
    }

    public static int getVisibleLastRows(TngTable table) {
        Rectangle vis = table.getVisibleRect();
        if (vis.height == 0) {
            return 0;
        }
        return table.rowAtPoint(new Point(0, vis.y + vis.height - 1));
    }

    public static int getVisibleRows(TngTable table) {
        return TngTableUtils.getVisibleLastRows(table) - TngTableUtils.getVisibleFirstRows(table);
    }

    public static void toFirstRow(TngTable table) {
        TngTableUtils.toRow(table, 0);
    }

    public static void toLastRow(TngTable table) {
        TngTableUtils.toRow(table, table.getRowCount() - 1);
    }

    public static void toRow(TngTable table, int row) {
        int count;
        if (row < 0) {
            row = 0;
        }
        if (row >= (count = table.getRowCount())) {
            row = count - 1;
        }
        if (row >= 0) {
            table.setRowSelectionInterval(row, row);
            TngTableUtils.scrollToRow(table, row);
        }
    }

    public static void toPrevRow(TngTable table) {
        int row = table.getSelectedRow();
        if (row > 0) {
            TngTableUtils.toRow(table, row - 1);
        }
    }

    public static void toNextRow(TngTable table) {
        int row = table.getSelectedRow();
        if (row + 1 < table.getRowCount()) {
            TngTableUtils.toRow(table, row + 1);
        }
    }

    public static void scrollRight(TngTable table) {
        int row = TngTableUtils.getVisibleFirstRows(table);
        Rectangle vis = table.getVisibleRect();
        int cell = table.columnAtPoint(new Point(vis.x + vis.width, 0));
        if (cell == -1) {
            cell = table.getColumnCount() - 1;
        }
        Rectangle r2 = new Rectangle(table.getCellRect(row, cell, false));
        r2.x += 6;
        table.scrollRectToVisible(r2);
    }

    public static void scrollLeft(TngTable table) {
        int row = TngTableUtils.getVisibleFirstRows(table);
        Rectangle vis = table.getVisibleRect();
        int cell = table.columnAtPoint(new Point(vis.x, 0));
        Rectangle r2 = new Rectangle(table.getCellRect(row, cell, false));
        r2.x -= 6;
        table.scrollRectToVisible(r2);
    }

    public static void toPrevPage(TngTable table) {
        if (TngTableUtils.scrollPrevPage(table)) {
            TngTableUtils.toRow(table, TngTableUtils.getVisibleFirstRows(table));
        } else {
            TngTableUtils.toFirstRow(table);
        }
    }

    public static void toNextPage(TngTable table) {
        if (TngTableUtils.scrollNextPage(table)) {
            TngTableUtils.toRow(table, TngTableUtils.getVisibleFirstRows(table));
        } else {
            TngTableUtils.toLastRow(table);
        }
    }

    public static boolean scrollPrevPage(TngTable table) {
        int row = TngTableUtils.getVisibleFirstRows(table);
        if ((row -= TngTableUtils.getVisibleRows(table)) < 0) {
            row = 0;
        }
        TngTableUtils.scrollToRow(table, row);
        return row > 0;
    }

    public static boolean scrollNextPage(TngTable table) {
        int row = TngTableUtils.getVisibleFirstRows(table);
        if ((row += 2 * TngTableUtils.getVisibleRows(table)) > table.getRowCount() - 1) {
            row = table.getRowCount() - 1;
        }
        TngTableUtils.scrollToRow(table, row);
        return row < table.getRowCount() - 1;
    }

    public static void scrollToRow(TngTable table, int row) {
        TngTableUtils.scrollToRowAndColumn(table, row, -1);
    }

    public static void scrollToRowAndColumn(TngTable table, int row, int column) {
        Rectangle vis = table.getVisibleRect();
        Rectangle r2 = new Rectangle(table.getCellRect(row, column, false));
        r2.x = vis.x;
        r2.width = 1;
        table.scrollRectToVisible(r2);
    }
}

