/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.table.export;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import tangram.TngLibParams;
import tangram.library.Nat;
import tangram.library.TngParams;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;
import tangram.swing.component.TngComboBox;
import tangram.swing.component.TngLabel;
import tangram.swing.component.field.TngFieldDirectory;
import tangram.swing.component.field.TngFieldFileSave;
import tangram.swing.panel.TngDlg;
import tangram.swing.panel.TngPanel;
import tangram.swing.table.component.TngTableColumn;
import tangram.swing.table.export.TngTableExportPanelColumns;
import tangram.swing.table.export.TngTableExportType;
import tangram.swing.table.export.TngTableExporter;

public class TngTableExportPanel
extends TngPanel {
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private TngLabel jLabel1 = new TngLabel();
    private TngLabel jLabel2 = new TngLabel();
    private TngLabel jLabel3 = new TngLabel();
    private TngComboBox jExportType = new TngComboBox();
    private TngFieldDirectory jExportDir = new TngFieldDirectory();
    private TngFieldFileSave jFileName = new TngFieldFileSave();
    private String tableTitle;
    private TngTableColumn[] allTableColumns = new TngTableColumn[0];
    private List<String> exportedTableColumns = new ArrayList<String>();
    private TngTableExporter tableExporter;

    public TngTableExportPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    public void setData(String tableTitle, TngTableColumn[] allTableColumns) {
        this.tableTitle = tableTitle;
        this.allTableColumns = allTableColumns;
        this.exportedTableColumns.clear();
        for (TngTableColumn tableColumn : allTableColumns) {
            this.exportedTableColumns.add(tableColumn.name);
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(449, 92));
        this.setTitle(Nat.x("Z\u00e1pis do s\u00faboru"));
        this.setLayout(this.gridBagLayout1);
        this.setAutoMnemonic(true);
        this.jLabel1.setText(Nat.x("Typ exportu"));
        this.jLabel2.setText(Nat.x("Do adres\u00e1ra"));
        this.jLabel3.setText(Nat.x("S\u00fabor"));
        this.jExportType.setModel(new DefaultComboBoxModel<TngTableExportType>(TngTableExportType.values()));
        this.jExportType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                if (e2.getStateChange() != 1) {
                    return;
                }
                TngTableExportPanel.this.applyFilter();
            }
        });
        this.jExportType.setParamName("exportType");
        this.jExportDir.setValueCanNull(false);
        this.jExportDir.setParamName("exportDir");
        this.jFileName.setValueCanNull(false);
        this.jFileName.setFieldDirectory(this.jExportDir);
        this.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.add((Component)this.jExportType, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.add((Component)this.jExportDir, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.add((Component)this.jFileName, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
        TngSwing.setOptimalHeight(this);
    }

    @Override
    public String getSubparamsName() {
        return TngUtilities.strExt(super.getSubparamsNameLib(), "/", this.tableTitle);
    }

    @Override
    public void doParamsLoad(TngLibParams libParams) {
        TngParams paramsSqlTngvarUser = libParams.getParamsSqlTngvarUser();
        TngTableExportType exportType = TngUtilities.valueOf(paramsSqlTngvarUser.getString(this.jExportType.getParamName()), TngTableExportType.values()[0]);
        this.jExportType.setSelectedItem((Object)exportType);
        this.jExportDir.setFile(new File(paramsSqlTngvarUser.getString(this.jExportDir.getParamName(), System.getProperty("user.dir"))));
        this.jFileName.setDefaultDirectory(this.jExportDir.getFileDef(null));
        this.jFileName.setFileNameOnly(new File(this.tableTitle + "." + exportType.getExtension()));
        String exportColumns = paramsSqlTngvarUser.getString("exportColumns");
        String[] exportColumnsTokens = TngUtilities.strTokenizeNotNull(exportColumns, ',');
        if (exportColumnsTokens.length != 0) {
            this.exportedTableColumns.clear();
            this.exportedTableColumns.addAll(Arrays.asList(exportColumnsTokens));
        }
    }

    @Override
    public void doParamsSave(TngLibParams libParams) throws Exception {
        libParams.getParamsSqlTngvarUser().clear();
        libParams.getParamsSqlTngvarUser().setString(this.jExportType.getParamName(), ((TngTableExportType)((Object)this.jExportType.getSelectedItem())).name());
        libParams.getParamsSqlTngvarUser().setString(this.jExportDir.getParamName(), this.jExportDir.getTextTrimed());
        TngTableColumn[] usedTableColumns = this.getUsedTableColumns();
        String paramExportColumn = "";
        for (int i2 = 0; i2 < usedTableColumns.length; ++i2) {
            paramExportColumn = paramExportColumn + usedTableColumns[i2].name;
            if (i2 == usedTableColumns.length - 1) continue;
            paramExportColumn = paramExportColumn + ",";
        }
        if (!TngUtilities.isEmpty(paramExportColumn)) {
            libParams.getParamsSqlTngvarUser().setString("exportColumns", paramExportColumn);
        }
        libParams.getParamsSqlTngvarUser().save();
    }

    @Override
    public String getCustomText() {
        return Nat.x("Konfigur\u00e1cia st\u013apcov");
    }

    @Override
    public boolean doBeforeShow() {
        this.applyFilter();
        return true;
    }

    private void applyFilter() {
        TngTableExportType writerType = (TngTableExportType)((Object)this.jExportType.getSelectedItem());
        this.jFileName.fileFilterReset();
        this.jFileName.fileFilterAddExtension(writerType.toString(), writerType.getExtension());
        String fileName = this.jFileName.getTextTrimed();
        int indexOfPoint = fileName.lastIndexOf(".");
        if (indexOfPoint != -1) {
            this.jFileName.setFileNameOnly(new File(fileName.substring(0, indexOfPoint) + "." + writerType.getExtension()));
        }
        this.jFileName.check();
    }

    @Override
    public boolean doSave() throws Exception {
        TngTableExportType writerType = (TngTableExportType)((Object)this.jExportType.getSelectedItem());
        this.tableExporter = writerType.getExporter();
        if (this.tableExporter == null) {
            return TngSwing.msgNovalid(Nat.x("Vyberte si typ exportu"), this.jExportType);
        }
        this.tableExporter.setUsedTableColumns(this.getUsedTableColumns());
        File exportFile = new File(this.jExportDir.getFile(), this.jFileName.getTextTrimed());
        this.tableExporter.setFile(exportFile);
        return true;
    }

    @Override
    public boolean doCustom() {
        TngTableExportPanelColumns p2 = new TngTableExportPanelColumns();
        p2.setData(this.allTableColumns, this.exportedTableColumns);
        if (TngDlg.runModal(p2, 7)) {
            this.exportedTableColumns = p2.getExportedColumns();
        }
        return false;
    }

    private TngTableColumn[] getUsedTableColumns() {
        ArrayList<TngTableColumn> usedTableColumns = new ArrayList<TngTableColumn>();
        for (String exportedTableColumn : this.exportedTableColumns) {
            for (TngTableColumn allTableColumn : this.allTableColumns) {
                if (!exportedTableColumn.equals(allTableColumn.name)) continue;
                usedTableColumns.add(allTableColumn);
            }
        }
        return usedTableColumns.toArray(new TngTableColumn[usedTableColumns.size()]);
    }

    public TngTableExporter getExporter() {
        return this.tableExporter;
    }
}

