/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.table.export;

import tangram.library.Nat;
import tangram.swing.table.export.TngTableExporter;
import tangram.swing.table.export.TngTableExporterCSV;
import tangram.swing.table.export.TngTableExporterDBF;
import tangram.swing.table.export.TngTableExporterTDF;
import tangram.swing.table.export.TngTableExporterXLS;
import tangram.swing.table.export.TngTableExporterXML;

public enum TngTableExportType {
    TDF("tdf", Nat.x("Tangram datab\u00e1zov\u00fd s\u00fabor"), TngTableExporterTDF.class),
    XLS("xls", Nat.x("Excel XLS s\u00fabor"), TngTableExporterXLS.class),
    XLSX("xlsx", Nat.x("Excel XLSX s\u00fabor"), TngTableExporterXLS.class),
    CSV("csv", Nat.x("Excel CSV s\u00fabor"), TngTableExporterCSV.class),
    XML("xml", Nat.x("XML s\u00fabor"), TngTableExporterXML.class),
    DBF("dbf", Nat.x("Dbase datab\u00e1zov\u00fd s\u00fabor"), TngTableExporterDBF.class);

    private final String extension;
    private final String description;
    private final Class<? extends TngTableExporter> exporterClass;

    private TngTableExportType(String extension, String description, Class<? extends TngTableExporter> exporterClass) {
        this.extension = extension;
        this.description = description;
        this.exporterClass = exporterClass;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getDescription() {
        return this.description;
    }

    public TngTableExporter getExporter() throws Exception {
        return this.exporterClass.newInstance();
    }

    public String toString() {
        return this.description + " (*." + this.extension + ")";
    }
}

