/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.table.export;

import java.io.BufferedWriter;
import java.io.FileWriter;
import tangram.library.TngUtilities;
import tangram.swing.table.component.TngTableColumn;
import tangram.swing.table.component.TngTableColumnType;
import tangram.swing.table.export.TngTableExporter;

public class TngTableExporterCSV
extends TngTableExporter {
    private StringBuilder data = new StringBuilder();
    private BufferedWriter fileWriter;

    @Override
    protected void processBefore() throws Exception {
        this.fileWriter = new BufferedWriter(new FileWriter(this.getFile()));
        this.writeHeader();
    }

    @Override
    protected void processTableRowValues(String[] transformedTableRowValues) throws Exception {
        this.data.setLength(0);
        for (int col = 0; col < transformedTableRowValues.length; ++col) {
            String value = transformedTableRowValues[col];
            this.data.append(value);
            if (col == transformedTableRowValues.length - 1) continue;
            this.data.append(";");
        }
        this.fileWrite(this.data.toString());
    }

    @Override
    protected String transformTableRowValue(TngTableColumn tableColumn, String tableRowValue) throws Exception {
        if (TngUtilities.isEmpty(tableRowValue)) {
            return "";
        }
        if (tableColumn.type == TngTableColumnType.STRING) {
            tableRowValue = "\"" + tableRowValue + "\"";
        }
        return tableRowValue;
    }

    @Override
    protected void processAfter() throws Exception {
        if (this.fileWriter != null) {
            this.fileWriter.close();
        }
    }

    private void writeHeader() throws Exception {
        this.data.setLength(0);
        for (int col = 0; col < this.getUsedTableColumns().length; ++col) {
            TngTableColumn usedTableColumn = this.getUsedTableColumns()[col];
            this.data.append("\"" + usedTableColumn.title + "\"");
            if (col == this.getUsedTableColumns().length - 1) continue;
            this.data.append(";");
        }
        this.fileWrite(this.data.toString());
    }

    private void fileWrite(String text) throws Exception {
        this.fileWriter.append(text);
        this.fileWriter.newLine();
    }
}

