/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.table.export;

import java.awt.Dimension;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import tangram.dbf.TngDbfField;
import tangram.dbf.TngDbfFieldBoolean;
import tangram.dbf.TngDbfFieldDate;
import tangram.dbf.TngDbfFieldNumber;
import tangram.dbf.TngDbfFieldString;
import tangram.dbf.TngDbfWriter;
import tangram.library.TngUtilities;
import tangram.swing.table.component.TngTableColumn;
import tangram.swing.table.component.TngTableColumnType;
import tangram.swing.table.export.TngTableExporter;
import tangram.swing.table.export.TngTableExporterColumn;

public class TngTableExporterDBF
extends TngTableExporter {
    private List<DbfColumn> dbfColumns = new ArrayList<DbfColumn>();
    private TngDbfWriter dbfWriter;

    @Override
    protected void processBefore() throws Exception {
        this.loadDbfColumns();
        this.createDbfWriter();
    }

    @Override
    protected void processTableRowValues(String[] transformedTableRowValues) throws Exception {
        Object[] retObj = new Object[this.dbfColumns.size()];
        for (int col = 0; col < transformedTableRowValues.length; ++col) {
            String value = transformedTableRowValues[col];
            retObj[col] = this.dbfColumns.get(col).resolveValue(value);
        }
        this.dbfWriter.addRecord(retObj);
    }

    @Override
    protected String getRenderedTableRowColumnValue(int tableColumnIndex, Object tableRowValue) throws Exception {
        if (this.dbfColumns.get((int)tableColumnIndex).type != TngTableColumnType.BOOLEAN) {
            return super.getRenderedTableRowColumnValue(tableColumnIndex, tableRowValue);
        }
        return tableRowValue != null && !TngUtilities.isEmpty(tableRowValue.toString()) && "A".equals(tableRowValue.toString()) ? "TRUE" : "FALSE";
    }

    @Override
    protected void processAfter() throws Exception {
        this.dbfWriter.write(new FileOutputStream(this.getFile()));
    }

    private void loadDbfColumns() throws Exception {
        TngTableColumn[] usedTableColumns;
        this.dbfColumns.clear();
        for (TngTableColumn usedTableColumn : usedTableColumns = this.getUsedTableColumns()) {
            DbfColumn dbfColumn = new DbfColumn();
            dbfColumn.resolveColumn(usedTableColumn);
            this.dbfColumns.add(dbfColumn);
        }
    }

    private void createDbfWriter() throws Exception {
        this.dbfWriter = new TngDbfWriter();
        this.dbfWriter.setCharactersetName("Windows-1250");
        this.dbfWriter.getHeader().setNumberOfRecords(this.getTableRowCount());
        TngDbfField[] fields = new TngDbfField[this.dbfColumns.size()];
        for (int i2 = 0; i2 < fields.length; ++i2) {
            fields[i2] = this.dbfColumns.get(i2).resolveField();
        }
        this.dbfWriter.setFields(fields);
    }

    private class DbfColumn
    extends TngTableExporterColumn {
        private DbfColumn() {
        }

        @Override
        protected void resolveName() {
            this.name = this.tableColumn.title.toUpperCase();
            this.name = TngUtilities.strLeft(this.name, 10);
        }

        @Override
        protected void resolveDimension() {
            Dimension dim = TngTableExporterDBF.this.resolveDimensionByModel(this.tableColumn);
            this.precision = dim.width;
            this.scale = dim.height;
        }

        private TngDbfField resolveField() {
            if (this.type == TngTableColumnType.BOOLEAN) {
                return new TngDbfFieldBoolean(this.name, false);
            }
            if (this.type == TngTableColumnType.DECIMAL) {
                return new TngDbfFieldNumber(this.name, this.precision <= 0 ? 8 : this.precision, this.scale <= 0 ? 0 : this.scale, new Double("0"));
            }
            if (this.type == TngTableColumnType.DATE) {
                return new TngDbfFieldDate(this.name, null);
            }
            return new TngDbfFieldString(this.name, this.precision <= 0 ? 255 : this.precision, "");
        }

        private Object resolveValue(String value) {
            if (value == null) {
                return null;
            }
            if (this.type == TngTableColumnType.BOOLEAN) {
                Boolean valueBoolean = Boolean.valueOf(value);
                return valueBoolean;
            }
            if (this.type == TngTableColumnType.DECIMAL) {
                BigDecimal valueDecimal = TngUtilities.stringToNumber(value);
                valueDecimal = TngUtilities.numberOrZero(valueDecimal);
                return new Double(valueDecimal.doubleValue());
            }
            if (this.tableColumn.type == TngTableColumnType.DATE) {
                return TngUtilities.strToDate(value);
            }
            return value;
        }
    }
}

