/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.table.model;

import java.util.ArrayList;
import tangram.swing.table.component.TngTableRow;
import tangram.swing.table.model.TngTableModel;

public class TngTableModelAsyncLoader
implements Runnable {
    private TngTableModel model;
    private Thread thread;
    private boolean running;
    private ArrayList<TngTableRow> rows = new ArrayList(150);

    public TngTableModelAsyncLoader(TngTableModel model) {
        this.model = model;
    }

    public synchronized void close() {
        this.running = false;
        Thread t2 = this.thread;
        if (t2 != null) {
            t2.interrupt();
        }
    }

    public synchronized void start() {
        this.rows.clear();
        this.thread = new Thread((Runnable)this, "AsyncLoader");
        this.thread.setDaemon(true);
        this.thread.setPriority(1);
        this.running = true;
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TngTableRow r2) {
        ArrayList<TngTableRow> arrayList = this.rows;
        synchronized (arrayList) {
            this.rows.add(r2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(TngTableRow r2) {
        ArrayList<TngTableRow> arrayList = this.rows;
        synchronized (arrayList) {
            this.rows.remove(r2);
        }
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Thread.sleep(8L);
                this.loadRow();
            }
            catch (InterruptedException e2) {
                // empty catch block
                break;
            }
        }
        this.thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRow() {
        TngTableRow r2 = null;
        ArrayList<TngTableRow> arrayList = this.rows;
        synchronized (arrayList) {
            int count = this.rows.size();
            if (count > 0) {
                r2 = this.rows.remove(count - 1);
            }
        }
        if (r2 != null) {
            this.model.loadRowAsync(r2);
        }
    }
}

