/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.table.model;

import java.sql.ResultSetMetaData;
import tangram.library.TngConnection;
import tangram.swing.table.component.TngTableColumn;
import tangram.swing.table.component.TngTableColumnSql;
import tangram.swing.table.model.TngTableModelSql;
import tangram.swing.table.visualizer.TngTableVisualizer;
import tangram.swing.table.visualizer.TngTableVisualizerDate;
import tangram.swing.table.visualizer.TngTableVisualizerQuantity;

public class TngTableModelSqlView
extends TngTableModelSql {
    private String sqlSelectCustom;

    public TngTableModelSqlView() {
    }

    public TngTableModelSqlView(TngConnection connection) {
        super(connection);
    }

    public void setSqlSelectCustomWithRowCount(String sqlSelectCustom) {
        this.sqlSelectCustom = sqlSelectCustom;
    }

    public void setSqlColumns(String sqlColumns) {
        this.sqlColumns = sqlColumns;
    }

    @Override
    protected String createSqlColumns() {
        if (this.sqlColumns == null || this.sqlColumns.length() == 0) {
            return "*";
        }
        return this.sqlColumns;
    }

    @Override
    protected void prepareData() throws Exception {
        super.prepareData();
        this.createColumns();
    }

    @Override
    protected String createSqlSelect() {
        if (this.sqlSelectCustom != null) {
            return this.sqlSelectCustom;
        }
        return super.createSqlSelect();
    }

    protected void createColumns() throws Exception {
        if (this.resData == null) {
            return;
        }
        ResultSetMetaData resMeta = this.resData.getMetaData();
        int c2 = resMeta.getColumnCount() - 1;
        TngTableColumn[] columns = new TngTableColumnSql[c2];
        this.sqlColumnIndexes = new int[c2];
        for (int i2 = 1; i2 <= c2; ++i2) {
            TngTableVisualizer visualizer = null;
            int type = resMeta.getColumnType(i2);
            if (type == -5 || type == 3 || type == 8 || type == 6 || type == 4 || type == 2 || type == 7) {
                visualizer = new TngTableVisualizerQuantity(resMeta.getScale(i2));
            } else if (type == 91 || type == 93) {
                visualizer = new TngTableVisualizerDate();
            } else if (resMeta.getPrecision(i2) < 4) {
                visualizer = new TngTableVisualizer(0);
            }
            this.sqlColumnIndexes[i2 - 1] = i2;
            columns[i2 - 1] = new TngTableColumnSql(resMeta.getColumnName(i2), "col" + i2, visualizer);
        }
        this.setColumns(columns);
    }
}

