/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.table.visualizer;

import java.math.BigDecimal;
import tangram.library.TngUtilities;
import tangram.swing.table.component.TngTableColumnType;
import tangram.swing.table.visualizer.TngTableVisualizer;

public class TngTableVisualizerPercent
extends TngTableVisualizer {
    private int minDecimals;

    public TngTableVisualizerPercent() {
        this(0);
    }

    public TngTableVisualizerPercent(int minDecimals) {
        super(4, TngTableColumnType.DECIMAL);
        this.minDecimals = minDecimals;
    }

    @Override
    public String getString(Object value) {
        if (value == null) {
            return "";
        }
        try {
            if (value instanceof BigDecimal) {
                BigDecimal perc = (BigDecimal)value;
                perc = TngUtilities.fixDecimals(perc, this.minDecimals);
                return TngUtilities.numberToString(perc) + "%";
            }
            return value.toString();
        }
        catch (Exception e2) {
            return e2.toString();
        }
    }
}

