/*
 * Decompiled with CFR 0.152.
 */
package tangram.updater;

import java.util.ArrayList;
import java.util.Collections;
import tangram.dm.Version;
import tangram.library.Nat;
import tangram.updater.Core;
import tangram.updater.Observer;
import tangram.updater.Project;

public class Updater {
    protected Core core;
    protected Project project;
    protected Observer observer;

    public void setCore(Core core) {
        this.core = core;
    }

    public Core getCore() {
        return this.core;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public void setObserver(Observer observer) {
        this.observer = observer;
    }

    public Observer getObserver() {
        return this.observer;
    }

    private void check() throws Exception {
        if (this.core == null) {
            throw new Exception(Nat.x("Nebolo definovan\u00e9 jadro aktualiz\u00e1cie"));
        }
        if (this.project == null) {
            throw new Exception(Nat.x("Nebol definovan\u00fd projekt aktualiz\u00e1cie"));
        }
        if (this.observer == null) {
            throw new Exception(Nat.x("Nebol definovan\u00fd log aktualiz\u00e1cie"));
        }
        this.project.check();
        if (!this.project.isInstalled()) {
            throw new Exception(Nat.x("Projekt %1 nie je nain\u0161talovan\u00fd", this.project.name));
        }
    }

    public void updateToVersion(String sourcesPath, Version version) throws Exception {
        this.check();
        String[] sources = this.getSources(sourcesPath);
        this.core.findProjectSourceVersion(this.project, sources, version);
        if (this.project.srcFile == null) {
            throw new Exception(Nat.x("Zdrojov\u00fd adres\u00e1r neobsahuje aktualiza\u010dn\u00e9 s\u00fabory pre projekt %1 vo verzii %2", this.project.name, version));
        }
        this.core.updateProject(this.project, this.observer);
    }

    public String[] getSources(String sourcesPath) throws Exception {
        String[] sources = this.core.getSources(sourcesPath);
        if (sources.length == 0) {
            throw new Exception(Nat.x("Zdrojov\u00fd adres\u00e1r neobsahuje \u017eiadne aktualiza\u010dn\u00e9 s\u00fabory"));
        }
        return sources;
    }

    public ArrayList<Version> readVersions(String sourcesPath) throws Exception {
        String[] sources = this.core.getSources(sourcesPath);
        ArrayList<Version> versions = new ArrayList<Version>();
        this.core.findProjectSources(versions, this.project, sources);
        Collections.sort(versions);
        return versions;
    }
}

