/*
 * Decompiled with CFR 0.152.
 */
package tangram.xml;

import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import tangram.library.TngConnection;
import tangram.xml.XmlColumn;

public class XmlColumns {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<XmlColumn> getColumns(TngConnection connection, String schemaAndTable) throws Exception {
        Statement st = null;
        try {
            st = connection.execStatement(st, "SELECT * FROM " + schemaAndTable + " WHERE 1=0");
            List<XmlColumn> list = XmlColumns.getColumns(st.getResultSet().getMetaData(), false);
            connection.close(st);
            return list;
        }
        catch (Throwable throwable) {
            connection.close(st);
            throw throwable;
        }
    }

    public static List<XmlColumn> getColumns(ResultSetMetaData metaData, boolean firstColumnIsRecordsCount) throws Exception {
        int i2;
        int count = metaData.getColumnCount();
        ArrayList<XmlColumn> columns = new ArrayList<XmlColumn>(count);
        int n2 = i2 = firstColumnIsRecordsCount ? 2 : 1;
        while (i2 <= count) {
            XmlColumn col = new XmlColumn();
            col.name = metaData.getColumnName(i2).toUpperCase();
            col.type = metaData.getColumnTypeName(i2);
            col.precision = metaData.getPrecision(i2);
            col.scale = metaData.getScale(i2);
            boolean bl = col.notNull = metaData.isNullable(i2) == 0;
            if ("LONG".equals(col.type)) {
                col.precision = 0;
            }
            columns.add(col);
            ++i2;
        }
        return columns;
    }

    public static String[] getNames(List<XmlColumn> columns) {
        String[] names = new String[columns.size()];
        for (int i2 = 0; i2 < names.length; ++i2) {
            names[i2] = columns.get((int)i2).name;
        }
        return names;
    }

    public static XmlColumn findColumn(String name, List<XmlColumn> columns) {
        for (int i2 = 0; i2 < columns.size(); ++i2) {
            if (!name.equals(columns.get((int)i2).name)) continue;
            return columns.get(i2);
        }
        return null;
    }

    public static void compare(List<XmlColumn> src, List<XmlColumn> dst, List<String> importCols, List<String> differCols, List<String> missingInSrc, List<String> missingInDst) {
        XmlColumn a2;
        int i2;
        for (i2 = 0; i2 < dst.size(); ++i2) {
            a2 = dst.get(i2);
            XmlColumn b2 = XmlColumns.findColumn(a2.name, src);
            if (b2 == null) {
                missingInSrc.add(a2.name);
                continue;
            }
            importCols.add(a2.name);
            if (a2.type.equals(b2.type) && a2.precision == b2.precision && a2.scale == b2.scale) continue;
            differCols.add(a2.name);
        }
        for (i2 = 0; i2 < src.size(); ++i2) {
            a2 = src.get(i2);
            if (XmlColumns.findColumn(a2.name, dst) != null) continue;
            missingInDst.add(a2.name);
        }
    }
}

