/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare;

import com.bysquare.BysquareEncoder;
import com.bysquare.BysquareException;
import com.bysquare.Header;
import com.bysquare.IBysquareQREncoder;
import com.bysquare.document.BysquareDocument;
import com.bysquare.logo.DirectoryLogoFactory;
import com.bysquare.logo.Logo;
import com.bysquare.logo.LogoFactory;
import com.bysquare.logo.LogoKey;
import com.bysquare.qr.IQREncoder;
import com.bysquare.qr.ZXingQREncoder;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class BysquareQREncoder
extends BysquareEncoder
implements IBysquareQREncoder {
    private File directory;
    private int imageSize;
    private LogoFactory logoFactory;
    private LogoKey logoKey;
    protected final IQREncoder qrEncoder = new ZXingQREncoder();
    private boolean useLogo;

    public BysquareQREncoder(File file) {
        this(new DirectoryLogoFactory(file));
    }

    public BysquareQREncoder() {
        this((LogoFactory)null);
    }

    public BysquareQREncoder(LogoFactory logoFactory) {
        this.logoFactory = logoFactory;
        this.logoKey = new LogoKey();
        this.useLogo = true;
        this.imageSize = 0;
        if (this.logoFactory instanceof DirectoryLogoFactory) {
            this.directory = ((DirectoryLogoFactory)this.logoFactory).getDirectory();
        }
    }

    public int getImageSize() {
        return this.imageSize;
    }

    public File getLogoDirectory() {
        return this.directory;
    }

    public boolean getLogoFrame() {
        return this.logoKey.getFrame();
    }

    public Logo.Rotation getLogoRotation() {
        return this.logoKey.getRotation();
    }

    public Logo.Variation getLogoVariation() {
        return this.logoKey.getVariation();
    }

    public boolean getUseLogo() {
        return this.useLogo;
    }

    public BufferedImage qrEncodeBase32hex(byte[] byArray) throws BysquareException {
        if (byArray == null) {
            throw new NullPointerException("Base32hex cannot be null. ");
        }
        Header header = this.decodeHeader(byArray);
        if (this.useLogo) {
            return this.wrapQRImage(this.qrEncoder.encode(byArray), Header.Type.values()[header.getBysquareType()]);
        }
        return this.qrEncoder.encode(byArray, this.imageSize);
    }

    public BufferedImage qrEncodeBase32hex(String string) throws BysquareException {
        if (string == null) {
            throw new NullPointerException("Base32hex cannot be null. ");
        }
        Header header = this.decodeHeader(string);
        if (this.useLogo) {
            return this.wrapQRImage(this.qrEncoder.encode(string), Header.Type.values()[header.getBysquareType()]);
        }
        return this.qrEncoder.encode(string, this.imageSize);
    }

    public BufferedImage qrEncodeDocument(BysquareDocument bysquareDocument) throws BysquareException {
        if (bysquareDocument == null) {
            throw new NullPointerException("Document cannot be null. ");
        }
        return this.qrEncodeBase32hex(this.encodeDocument(bysquareDocument));
    }

    public BufferedImage qrEncodeXML(InputStream inputStream) throws BysquareException, IOException {
        if (inputStream == null) {
            throw new NullPointerException("XML cannot be null. ");
        }
        return this.qrEncodeBase32hex(this.encodeXML(inputStream));
    }

    public BufferedImage qrEncodeXML(Reader reader) throws BysquareException, IOException {
        if (reader == null) {
            throw new NullPointerException("XML cannot be null. ");
        }
        return this.qrEncodeBase32hex(this.encodeXML(reader));
    }

    public void setImageSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Image size cannot be negative. ");
        }
        this.imageSize = n;
    }

    public void setLogoDirectory(File file) {
        this.logoFactory = new DirectoryLogoFactory(file);
        this.directory = file;
    }

    public void setLogoFrame(boolean bl) {
        this.logoKey.setFrame(bl);
    }

    public void setLogoKey(LogoKey logoKey) {
        this.logoKey.copyFrom(logoKey);
    }

    public void setLogoRotation(Logo.Rotation rotation) {
        this.logoKey.setRotation(rotation);
    }

    public void setLogoVariation(Logo.Variation variation) {
        this.logoKey.setVariation(variation);
    }

    public void setUseLogo(boolean bl) {
        this.useLogo = bl;
    }

    public BufferedImage wrapQRImage(Image image, Header.Type type) throws BysquareException {
        if (image == null || type == null) {
            throw new NullPointerException("Image nor type cannot be null. ");
        }
        this.logoKey.setType(type);
        Logo logo = this.logoFactory.getLogo(this.logoKey);
        return logo.wrap(image);
    }
}

