/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.checksum;

import com.bysquare.checksum.ChecksumException;
import com.bysquare.checksum.IChecksum;
import com.bysquare.utilities.IOUtils;
import java.util.zip.CRC32;

public class CRC32Checksum
implements IChecksum {
    private static final int SIZE = 4;
    private final CRC32 crc32 = new CRC32();

    public byte[] add(byte[] byArray) {
        long l = this.calculate(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[byArray.length + 4];
        byArray2[0] = (byte)l;
        byArray2[1] = (byte)(l >> 8);
        byArray2[2] = (byte)(l >> 16);
        byArray2[3] = (byte)(l >> 24);
        System.arraycopy(byArray, 0, byArray2, 4, byArray.length);
        return byArray2;
    }

    private long calculate(byte[] byArray, int n, int n2) {
        this.crc32.reset();
        this.crc32.update(byArray, n, n2);
        long l = this.crc32.getValue();
        return l;
    }

    public byte[] remove(byte[] byArray) throws ChecksumException {
        if (byArray.length < 4) {
            throw new ChecksumException("Checksum not found. ");
        }
        int n = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24;
        int n2 = (int)this.calculate(byArray, 4, byArray.length - 4);
        if (n2 != n) {
            throw new ChecksumException("Checksum mismatch. ");
        }
        return IOUtils.copyOfRange(byArray, 4, byArray.length - 4);
    }
}

