/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.compression;

import SevenZip.Compression.LZMA.Decoder;
import SevenZip.Compression.LZMA.Encoder;
import com.bysquare.compression.CompressionException;
import com.bysquare.compression.ICompressor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class LZMACompressor
implements ICompressor {
    private static int DEFAULT_LC = 3;
    private static int DEFAULT_LP = 0;
    private static int DEFAULT_PB = 2;
    private static int DEFAULT_DICTIONARY_SIZE = 131072;
    private final Encoder lzmaEncoder = new Encoder();
    private final Decoder lzmaDecoder = new Decoder();

    public LZMACompressor() {
        this.lzmaEncoder.SetLcLpPb(DEFAULT_LC, DEFAULT_LP, DEFAULT_PB);
        this.lzmaEncoder.SetDictionarySize(DEFAULT_DICTIONARY_SIZE);
        this.lzmaDecoder.SetLcLpPb(DEFAULT_LC, DEFAULT_LP, DEFAULT_PB);
        this.lzmaDecoder.SetDictionarySize(DEFAULT_DICTIONARY_SIZE);
    }

    public byte[] compress(byte[] byArray) throws CompressionException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        long l = byArray.length;
        byteArrayOutputStream.write((byte)l);
        byteArrayOutputStream.write((byte)(l >> 8));
        try {
            this.lzmaEncoder.Code(byteArrayInputStream, byteArrayOutputStream, -1L, -1L, null);
        }
        catch (Exception exception) {
            throw new CompressionException("Compression error. ", exception);
        }
        if (byteArrayOutputStream.size() == 0) {
            throw new CompressionException("Compression error. ");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] decompress(byte[] byArray) throws CompressionException {
        if (byArray.length < 2) {
            throw new CompressionException("Invalid compressed data. ");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n = (byteArrayInputStream.read() & 0xFF) + ((byteArrayInputStream.read() & 0xFF) << 8);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        try {
            this.lzmaDecoder.Code(byteArrayInputStream, byteArrayOutputStream, n);
        }
        catch (Exception exception) {
            throw new CompressionException("Decompression error. ", exception);
        }
        if (byteArrayOutputStream.size() == 0) {
            throw new CompressionException("Decompression error. ");
        }
        return byteArrayOutputStream.toByteArray();
    }
}

