/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.document.invoice;

import com.bysquare.document.IVerifiable;
import com.bysquare.document.InvalidValueException;
import com.bysquare.document.Verify;
import com.bysquare.document.invoice.InvoiceBase;
import java.util.Date;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;

@Order(elements={"OrderLineID", "DeliveryNoteLineID", "ItemName", "ItemEANCode", "PeriodFromDate", "PeriodToDate", "InvoicedQuantity", "UnitPriceTaxExclusiveAmount", "UnitPriceTaxInclusiveAmount", "UnitPriceTaxAmount"})
@Root(name="SingleInvoiceLine", strict=false)
public class SingleInvoiceLine
implements IVerifiable {
    protected String orderLineID;
    protected String deliveryNoteLineID;
    protected String itemName;
    protected String itemEANCode;
    @Element(name="PeriodFromDate", required=false)
    protected Date periodFromDate;
    @Element(name="PeriodToDate", required=false)
    protected Date periodToDate;
    protected Double invoicedQuantity;
    transient InvoiceBase invoice;

    @Element(name="OrderLineID", required=false)
    public String getOrderLineID() {
        return this.orderLineID;
    }

    @Element(name="OrderLineID", required=false)
    public void setOrderLineID(String string) {
        this.orderLineID = Verify.trim(string);
    }

    @Element(name="DeliveryNoteLineID", required=false)
    public String getDeliveryNoteLineID() {
        return this.deliveryNoteLineID;
    }

    @Element(name="DeliveryNoteLineID", required=false)
    public void setDeliveryNoteLineID(String string) {
        this.deliveryNoteLineID = Verify.trim(string);
    }

    @Element(name="ItemName", required=false)
    public String getItemName() {
        return this.itemName;
    }

    @Element(name="ItemName", required=false)
    public void setItemName(String string) {
        this.itemName = Verify.trim(string);
    }

    @Element(name="ItemEANCode", required=false)
    public String getItemEANCode() {
        return this.itemEANCode;
    }

    @Element(name="ItemEANCode", required=false)
    public void setItemEANCode(String string) {
        this.itemEANCode = Verify.trimAll(string);
    }

    public Date getPeriodFromDate() {
        return this.periodFromDate;
    }

    public void setPeriodFromDate(Date date) {
        this.periodFromDate = date;
    }

    public Date getPeriodToDate() {
        return this.periodToDate;
    }

    public void setPeriodToDate(Date date) {
        this.periodToDate = date;
    }

    @Element(name="InvoicedQuantity", required=false)
    public Double getInvoicedQuantity() {
        if (this.invoicedQuantity == null) {
            this.invoicedQuantity = 0.0;
        }
        return this.invoicedQuantity;
    }

    @Element(name="InvoicedQuantity", required=false)
    public void setInvoicedQuantity(Double d) {
        this.invoicedQuantity = d;
    }

    @Element(name="UnitPriceTaxExclusiveAmount", required=false)
    public Double getUnitPriceTaxExclusiveAmount() {
        if (this.invoice != null && this.getInvoicedQuantity() != 0.0) {
            return this.invoice.getMonetarySummary().getTaxExclusiveAmount() / this.getInvoicedQuantity();
        }
        return 0.0;
    }

    @Deprecated
    @Element(name="UnitPriceTaxExclusiveAmount", required=false)
    public void setUnitPriceTaxExclusiveAmount(Double d) {
    }

    @Element(name="UnitPriceTaxInclusiveAmount", required=false)
    public Double getUnitPriceTaxInclusiveAmount() {
        if (this.invoice != null && this.getInvoicedQuantity() != 0.0) {
            return this.invoice.getMonetarySummary().getTaxInclusiveAmount() / this.getInvoicedQuantity();
        }
        return 0.0;
    }

    @Deprecated
    @Element(name="UnitPriceTaxInclusiveAmount", required=false)
    public void setUnitPriceTaxInclusiveAmount(Double d) {
    }

    @Element(name="UnitPriceTaxAmount", required=false)
    public Double getUnitPriceTaxAmount() {
        if (this.invoice != null && this.getInvoicedQuantity() != 0.0) {
            return this.invoice.getMonetarySummary().getTaxAmount() / this.getInvoicedQuantity();
        }
        return 0.0;
    }

    @Deprecated
    @Element(name="UnitPriceTaxAmount", required=false)
    public void setUnitPriceTaxAmount(Double d) {
    }

    public boolean isEmpty() {
        return this.orderLineID == null && this.deliveryNoteLineID == null && this.itemName == null && this.itemEANCode == null && this.periodFromDate == null && this.periodToDate == null && this.getInvoicedQuantity() == 0.0;
    }

    public void verify() throws InvalidValueException {
        Verify.choice("ItemName ItemEANCode", this.getItemName(), this.getItemEANCode());
        Verify.periodFromToDate(this.getPeriodFromDate(), this.getPeriodToDate());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof SingleInvoiceLine)) {
            return false;
        }
        SingleInvoiceLine singleInvoiceLine = (SingleInvoiceLine)object;
        if (this.deliveryNoteLineID == null ? singleInvoiceLine.deliveryNoteLineID != null : !this.deliveryNoteLineID.equals(singleInvoiceLine.deliveryNoteLineID)) {
            return false;
        }
        if (!this.getInvoicedQuantity().equals(singleInvoiceLine.getInvoicedQuantity())) {
            return false;
        }
        if (this.itemEANCode == null ? singleInvoiceLine.itemEANCode != null : !this.itemEANCode.equals(singleInvoiceLine.itemEANCode)) {
            return false;
        }
        if (this.itemName == null ? singleInvoiceLine.itemName != null : !this.itemName.equals(singleInvoiceLine.itemName)) {
            return false;
        }
        if (this.orderLineID == null ? singleInvoiceLine.orderLineID != null : !this.orderLineID.equals(singleInvoiceLine.orderLineID)) {
            return false;
        }
        if (this.periodFromDate == null ? singleInvoiceLine.periodFromDate != null : !this.periodFromDate.equals(singleInvoiceLine.periodFromDate)) {
            return false;
        }
        return !(this.periodToDate == null ? singleInvoiceLine.periodToDate != null : !this.periodToDate.equals(singleInvoiceLine.periodToDate));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.deliveryNoteLineID == null ? 0 : this.deliveryNoteLineID.hashCode());
        n = 31 * n + this.getInvoicedQuantity().hashCode();
        n = 31 * n + (this.itemEANCode == null ? 0 : this.itemEANCode.hashCode());
        n = 31 * n + (this.itemName == null ? 0 : this.itemName.hashCode());
        n = 31 * n + (this.orderLineID == null ? 0 : this.orderLineID.hashCode());
        n = 31 * n + (this.periodFromDate == null ? 0 : this.periodFromDate.hashCode());
        n = 31 * n + (this.periodToDate == null ? 0 : this.periodToDate.hashCode());
        return n;
    }
}

