/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.document.pay;

import com.bysquare.document.IVerifiable;
import com.bysquare.document.InvalidValueException;
import com.bysquare.document.Verify;
import com.bysquare.document.pay.DirectDebitScheme;
import com.bysquare.document.pay.DirectDebitType;
import java.util.Date;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;

@Order(elements={"DirectDebitScheme", "DirectDebitType", "VariableSymbol", "SpecificSymbol", "OriginatorsReferenceInformation", "MandateID", "CreditorID", "ContractID", "MaxAmount", "ValidTillDate"})
@Root(name="DirectDebitExt", strict=false)
public class DirectDebitExt
implements IVerifiable {
    @Element(name="DirectDebitScheme", required=false)
    protected DirectDebitScheme directDebitScheme;
    @Element(name="DirectDebitType", required=false)
    protected DirectDebitType directDebitType;
    protected String variableSymbol;
    protected String specificSymbol;
    protected String originatorsReferenceInformation;
    protected String mandateID;
    protected String creditorID;
    protected String contractID;
    @Element(name="MaxAmount", required=false)
    protected Double maxAmount;
    @Element(name="ValidTillDate", required=false)
    protected Date validTillDate;

    public DirectDebitScheme getDirectDebitScheme() {
        return this.directDebitScheme;
    }

    public void setDirectDebitScheme(DirectDebitScheme directDebitScheme) {
        this.directDebitScheme = directDebitScheme;
    }

    public DirectDebitType getDirectDebitType() {
        return this.directDebitType;
    }

    public void setDirectDebitType(DirectDebitType directDebitType) {
        this.directDebitType = directDebitType;
    }

    @Element(name="VariableSymbol", required=false)
    public String getVariableSymbol() {
        return this.variableSymbol;
    }

    @Element(name="VariableSymbol", required=false)
    public void setVariableSymbol(String string) {
        this.variableSymbol = Verify.trimAll(string);
    }

    @Element(name="SpecificSymbol", required=false)
    public String getSpecificSymbol() {
        return this.specificSymbol;
    }

    @Element(name="SpecificSymbol", required=false)
    public void setSpecificSymbol(String string) {
        this.specificSymbol = Verify.trimAll(string);
    }

    @Element(name="OriginatorsReferenceInformation", required=false)
    public String getOriginatorsReferenceInformation() {
        return this.originatorsReferenceInformation;
    }

    @Element(name="OriginatorsReferenceInformation", required=false)
    public void setOriginatorsReferenceInformation(String string) {
        this.originatorsReferenceInformation = Verify.trim(string);
    }

    @Element(name="MandateID", required=false)
    public String getMandateID() {
        return this.mandateID;
    }

    @Element(name="MandateID", required=false)
    public void setMandateID(String string) {
        this.mandateID = Verify.trim(string);
    }

    @Element(name="CreditorID", required=false)
    public String getCreditorID() {
        return this.creditorID;
    }

    @Element(name="CreditorID", required=false)
    public void setCreditorID(String string) {
        this.creditorID = Verify.trim(string);
    }

    @Element(name="ContractID", required=false)
    public String getContractID() {
        return this.contractID;
    }

    @Element(name="ContractID", required=false)
    public void setContractID(String string) {
        this.contractID = Verify.trim(string);
    }

    public Double getMaxAmount() {
        return this.maxAmount;
    }

    public void setMaxAmount(Double d) {
        this.maxAmount = d;
    }

    public Date getValidTillDate() {
        return this.validTillDate;
    }

    public void setValidTillDate(Date date) {
        this.validTillDate = date;
    }

    public void verify() throws InvalidValueException {
        Verify.notNull("DirectDebitScheme", (Object)this.getDirectDebitScheme());
        Verify.notNull("DirectDebitType", (Object)this.getDirectDebitType());
        String string = "MandateID, CreditorID and ContractID are used";
        String string2 = "OriginatorsReferenceInformation is used";
        if (this.getDirectDebitScheme() == DirectDebitScheme.SEPA || this.getMandateID() != null || this.getCreditorID() != null || this.getContractID() != null) {
            Verify.notNull("MandateID", this.getMandateID());
            Verify.notNull("CreditorID", this.getCreditorID());
            if (this.getDirectDebitScheme() == DirectDebitScheme.SEPA) {
                string = "SEPA direct debit scheme selected";
            }
            Verify.isNull("VariableSymbol", this.getVariableSymbol(), string);
            Verify.isNull("SpecificSymbol", this.getSpecificSymbol(), string);
            Verify.isNull("OriginatorsReferenceInformation", this.getOriginatorsReferenceInformation(), string);
        } else if (this.getOriginatorsReferenceInformation() != null) {
            Verify.isNull("VariableSymbol", this.getVariableSymbol(), string2);
            Verify.isNull("SpecificSymbol", this.getSpecificSymbol(), string2);
        }
        Verify.nullOrMatch("VariableSymbol", this.getVariableSymbol(), "[0-9]{0,10}");
        Verify.nullOrMatch("SpecificSymbol", this.getSpecificSymbol(), "[0-9]{0,10}");
        Verify.nullOrPositive("MaxAmount", this.getMaxAmount());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DirectDebitExt)) {
            return false;
        }
        DirectDebitExt directDebitExt = (DirectDebitExt)object;
        if (this.contractID == null ? directDebitExt.contractID != null : !this.contractID.equals(directDebitExt.contractID)) {
            return false;
        }
        if (this.creditorID == null ? directDebitExt.creditorID != null : !this.creditorID.equals(directDebitExt.creditorID)) {
            return false;
        }
        if (this.directDebitScheme != directDebitExt.directDebitScheme) {
            return false;
        }
        if (this.directDebitType != directDebitExt.directDebitType) {
            return false;
        }
        if (this.mandateID == null ? directDebitExt.mandateID != null : !this.mandateID.equals(directDebitExt.mandateID)) {
            return false;
        }
        if (this.maxAmount == null ? directDebitExt.maxAmount != null : !this.maxAmount.equals(directDebitExt.maxAmount)) {
            return false;
        }
        if (this.originatorsReferenceInformation == null ? directDebitExt.originatorsReferenceInformation != null : !this.originatorsReferenceInformation.equals(directDebitExt.originatorsReferenceInformation)) {
            return false;
        }
        if (this.specificSymbol == null ? directDebitExt.specificSymbol != null : !this.specificSymbol.equals(directDebitExt.specificSymbol)) {
            return false;
        }
        if (this.validTillDate == null ? directDebitExt.validTillDate != null : !this.validTillDate.equals(directDebitExt.validTillDate)) {
            return false;
        }
        return !(this.variableSymbol == null ? directDebitExt.variableSymbol != null : !this.variableSymbol.equals(directDebitExt.variableSymbol));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.contractID == null ? 0 : this.contractID.hashCode());
        n = 31 * n + (this.creditorID == null ? 0 : this.creditorID.hashCode());
        n = 31 * n + (this.directDebitScheme == null ? 0 : this.directDebitScheme.hashCode());
        n = 31 * n + (this.directDebitType == null ? 0 : this.directDebitType.hashCode());
        n = 31 * n + (this.mandateID == null ? 0 : this.mandateID.hashCode());
        n = 31 * n + (this.maxAmount == null ? 0 : this.maxAmount.hashCode());
        n = 31 * n + (this.originatorsReferenceInformation == null ? 0 : this.originatorsReferenceInformation.hashCode());
        n = 31 * n + (this.specificSymbol == null ? 0 : this.specificSymbol.hashCode());
        n = 31 * n + (this.validTillDate == null ? 0 : this.validTillDate.hashCode());
        n = 31 * n + (this.variableSymbol == null ? 0 : this.variableSymbol.hashCode());
        return n;
    }
}

