/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.document.pay;

import com.bysquare.document.IVerifiable;
import com.bysquare.document.InvalidValueException;
import com.bysquare.document.Verify;
import com.bysquare.document.pay.BankAccounts;
import com.bysquare.document.pay.DirectDebitExt;
import com.bysquare.document.pay.PaymentOption;
import com.bysquare.document.pay.StandingOrderExt;
import com.bysquare.xml.helper.PaymentOptionsConverter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.convert.Convert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Order(elements={"PaymentOptions", "Amount", "CurrencyCode", "PaymentDueDate", "VariableSymbol", "ConstantSymbol", "SpecificSymbol", "OriginatorsReferenceInformation", "PaymentNote", "BankAccounts", "StandingOrderExt", "DirectDebitExt"})
@Root(name="Payment", strict=false)
public class Payment
implements IVerifiable {
    protected List<PaymentOption> paymentOptions;
    @Element(name="Amount", required=false)
    protected Double amount;
    protected String currencyCode;
    @Element(name="PaymentDueDate", required=false)
    protected Date paymentDueDate;
    protected String variableSymbol;
    protected String constantSymbol;
    protected String specificSymbol;
    protected String originatorsReferenceInformation;
    protected String paymentNote;
    protected BankAccounts bankAccounts;
    @Element(name="StandingOrderExt", required=false)
    protected StandingOrderExt standingOrderExt;
    @Element(name="DirectDebitExt", required=false)
    protected DirectDebitExt directDebitExt;

    @Element(name="PaymentOptions", required=false)
    @Convert(value=PaymentOptionsConverter.class)
    public List<PaymentOption> getPaymentOptions() {
        if (this.paymentOptions == null) {
            this.paymentOptions = new ArrayList<PaymentOption>();
        }
        return this.paymentOptions;
    }

    @Element(name="PaymentOptions", required=false)
    @Convert(value=PaymentOptionsConverter.class)
    public void setPaymentOptions(List<PaymentOption> list) {
        this.paymentOptions = list;
    }

    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double d) {
        this.amount = d;
    }

    @Element(name="CurrencyCode", required=false)
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @Element(name="CurrencyCode", required=false)
    public void setCurrencyCode(String string) {
        this.currencyCode = Verify.trimAllToUpperCase(string);
    }

    public Date getPaymentDueDate() {
        return this.paymentDueDate;
    }

    public void setPaymentDueDate(Date date) {
        this.paymentDueDate = date;
    }

    @Element(name="VariableSymbol", required=false)
    public String getVariableSymbol() {
        return this.variableSymbol;
    }

    @Element(name="VariableSymbol", required=false)
    public void setVariableSymbol(String string) {
        this.variableSymbol = Verify.trimAll(string);
    }

    @Element(name="ConstantSymbol", required=false)
    public String getConstantSymbol() {
        return this.constantSymbol;
    }

    @Element(name="ConstantSymbol", required=false)
    public void setConstantSymbol(String string) {
        this.constantSymbol = Verify.trimAll(string);
    }

    @Element(name="SpecificSymbol", required=false)
    public String getSpecificSymbol() {
        return this.specificSymbol;
    }

    @Element(name="SpecificSymbol", required=false)
    public void setSpecificSymbol(String string) {
        this.specificSymbol = Verify.trimAll(string);
    }

    @Element(name="OriginatorsReferenceInformation", required=false)
    public String getOriginatorsReferenceInformation() {
        return this.originatorsReferenceInformation;
    }

    @Element(name="OriginatorsReferenceInformation", required=false)
    public void setOriginatorsReferenceInformation(String string) {
        this.originatorsReferenceInformation = Verify.trim(string);
    }

    @Element(name="PaymentNote", required=false)
    public String getPaymentNote() {
        return this.paymentNote;
    }

    @Element(name="PaymentNote", required=false)
    public void setPaymentNote(String string) {
        this.paymentNote = Verify.trim(string);
    }

    @Element(name="BankAccounts", required=false)
    public BankAccounts getBankAccounts() {
        if (this.bankAccounts == null) {
            this.bankAccounts = new BankAccounts();
        }
        return this.bankAccounts;
    }

    @Element(name="BankAccounts", required=false)
    public void setBankAccounts(BankAccounts bankAccounts) {
        this.bankAccounts = bankAccounts;
    }

    public StandingOrderExt getStandingOrderExt() {
        return this.standingOrderExt;
    }

    public void setStandingOrderExt(StandingOrderExt standingOrderExt) {
        this.standingOrderExt = standingOrderExt;
    }

    public DirectDebitExt getDirectDebitExt() {
        return this.directDebitExt;
    }

    public void setDirectDebitExt(DirectDebitExt directDebitExt) {
        this.directDebitExt = directDebitExt;
    }

    @Override
    public void verify() throws InvalidValueException {
        String string;
        Verify.enumList("PaymentOptions", this.getPaymentOptions(), PaymentOption.class);
        Verify.notNullAndMatch("CurrencyCode", this.getCurrencyCode(), "[A-Z]{3}");
        if (this.getOriginatorsReferenceInformation() != null) {
            string = "OriginatorsReferenceInformation is used";
            Verify.isNull("VariableSymbol", this.getVariableSymbol(), string);
            Verify.isNull("ConstantSymbol", this.getConstantSymbol(), string);
            Verify.isNull("SpecificSymbol", this.getSpecificSymbol(), string);
        } else {
            Verify.nullOrMatch("VariableSymbol", this.getVariableSymbol(), "[0-9]{0,10}");
            Verify.nullOrMatch("ConstantSymbol", this.getConstantSymbol(), "[0-9]{0,4}");
            Verify.nullOrMatch("SpecificSymbol", this.getSpecificSymbol(), "[0-9]{0,10}");
        }
        Verify.notNullAndVerify("BankAccounts", this.getBankAccounts());
        string = "List of PaymentOptions does not contain ";
        if (this.getPaymentOptions().contains((Object)PaymentOption.standingorder)) {
            Verify.notNullAndVerify("StandingOrderExt", this.getStandingOrderExt());
        } else {
            Verify.isNull("StandingOrderExt", this.getStandingOrderExt(), string + "standingorder");
        }
        if (this.getPaymentOptions().contains((Object)PaymentOption.directdebit)) {
            Verify.notNullAndVerify("DirectDebitExt", this.getDirectDebitExt());
        } else {
            Verify.isNull("DirectDebitExt", this.getDirectDebitExt(), string + "directdebit");
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.amount == null ? 0 : this.amount.hashCode());
        n = 31 * n + this.getBankAccounts().hashCode();
        n = 31 * n + (this.constantSymbol == null ? 0 : this.constantSymbol.hashCode());
        n = 31 * n + (this.currencyCode == null ? 0 : this.currencyCode.hashCode());
        n = 31 * n + (this.directDebitExt == null ? 0 : this.directDebitExt.hashCode());
        n = 31 * n + (this.originatorsReferenceInformation == null ? 0 : this.originatorsReferenceInformation.hashCode());
        n = 31 * n + (this.paymentDueDate == null ? 0 : this.paymentDueDate.hashCode());
        n = 31 * n + (this.paymentNote == null ? 0 : this.paymentNote.hashCode());
        n = 31 * n + (this.paymentOptions == null ? 0 : this.paymentOptions.hashCode());
        n = 31 * n + (this.specificSymbol == null ? 0 : this.specificSymbol.hashCode());
        n = 31 * n + (this.standingOrderExt == null ? 0 : this.standingOrderExt.hashCode());
        n = 31 * n + (this.variableSymbol == null ? 0 : this.variableSymbol.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Payment)) {
            return false;
        }
        Payment payment = (Payment)object;
        if (this.amount == null ? payment.amount != null : !this.amount.equals(payment.amount)) {
            return false;
        }
        if (!this.getBankAccounts().equals(payment.getBankAccounts())) {
            return false;
        }
        if (this.constantSymbol == null ? payment.constantSymbol != null : !this.constantSymbol.equals(payment.constantSymbol)) {
            return false;
        }
        if (this.currencyCode == null ? payment.currencyCode != null : !this.currencyCode.equals(payment.currencyCode)) {
            return false;
        }
        if (this.directDebitExt == null ? payment.directDebitExt != null : !this.directDebitExt.equals(payment.directDebitExt)) {
            return false;
        }
        if (this.originatorsReferenceInformation == null ? payment.originatorsReferenceInformation != null : !this.originatorsReferenceInformation.equals(payment.originatorsReferenceInformation)) {
            return false;
        }
        if (this.paymentDueDate == null ? payment.paymentDueDate != null : !this.paymentDueDate.equals(payment.paymentDueDate)) {
            return false;
        }
        if (this.paymentNote == null ? payment.paymentNote != null : !this.paymentNote.equals(payment.paymentNote)) {
            return false;
        }
        if (this.paymentOptions == null ? payment.paymentOptions != null : !this.paymentOptions.equals(payment.paymentOptions)) {
            return false;
        }
        if (this.specificSymbol == null ? payment.specificSymbol != null : !this.specificSymbol.equals(payment.specificSymbol)) {
            return false;
        }
        if (this.standingOrderExt == null ? payment.standingOrderExt != null : !this.standingOrderExt.equals(payment.standingOrderExt)) {
            return false;
        }
        return !(this.variableSymbol == null ? payment.variableSymbol != null : !this.variableSymbol.equals(payment.variableSymbol));
    }
}

