/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.logo;

import com.bysquare.logo.Logo;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class FrameLogo
extends Logo {
    private final int x;
    private final int y;
    private final int xRange;
    private final int yRange;
    private final int error;

    public FrameLogo(BufferedImage bufferedImage) {
        this(bufferedImage, true);
    }

    private FrameLogo(BufferedImage bufferedImage, boolean bl) {
        super(bufferedImage, bl);
        int n;
        int n2;
        int n3 = n2 = this.width >> 1;
        int n4 = n2;
        int n5 = n = this.height >> 1;
        int n6 = n;
        int n7 = this.logo.getRGB(n4, n6);
        while (--n3 > -1 && this.logo.getRGB(n3, n6) == n7) {
        }
        ++n3;
        while (++n2 < this.width && this.logo.getRGB(n2, n6) == n7) {
        }
        --n2;
        while (--n5 > -1 && this.logo.getRGB(n4, n5) == n7) {
        }
        ++n5;
        while (++n < this.height && this.logo.getRGB(n4, n) == n7) {
        }
        this.x = n3;
        this.xRange = n2 - this.x + 1;
        this.y = n5;
        this.yRange = --n - this.y + 1;
        this.error = this.xRange - this.yRange;
    }

    public FrameLogo(File file) throws IOException {
        this(ImageIO.read(file), false);
    }

    public FrameLogo(InputStream inputStream) throws IOException {
        this(ImageIO.read(inputStream), false);
    }

    public int getError() {
        return this.error;
    }

    public BufferedImage wrap(Image image) {
        if (image == null) {
            throw new NullPointerException();
        }
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(Color.WHITE);
        graphics2D.clearRect(0, 0, this.width, this.height);
        graphics2D.drawImage((Image)this.logo, 0, 0, null);
        graphics2D.drawImage(image, this.x, this.y, this.xRange, this.yRange, null);
        graphics2D.dispose();
        return bufferedImage;
    }
}

