/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.qr;

import com.bysquare.qr.IQREncoder;
import com.bysquare.qr.QRException;
import com.bysquare.utilities.IOUtils;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.Map;

public class ZXingQREncoder
implements IQREncoder {
    private final QRCodeWriter writer = new QRCodeWriter();
    private final Map<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();

    public ZXingQREncoder() {
        this.setECLevel(IQREncoder.ECLevel.L);
    }

    public void setECLevel(IQREncoder.ECLevel eCLevel) {
        ErrorCorrectionLevel errorCorrectionLevel = ErrorCorrectionLevel.L;
        switch (eCLevel) {
            case L: {
                errorCorrectionLevel = ErrorCorrectionLevel.L;
                break;
            }
            case M: {
                errorCorrectionLevel = ErrorCorrectionLevel.M;
                break;
            }
            case Q: {
                errorCorrectionLevel = ErrorCorrectionLevel.Q;
                break;
            }
            case H: {
                errorCorrectionLevel = ErrorCorrectionLevel.H;
            }
        }
        this.hints.put(EncodeHintType.ERROR_CORRECTION, errorCorrectionLevel);
    }

    public BufferedImage encode(byte[] byArray) throws QRException {
        return this.encode(IOUtils.toString(byArray));
    }

    public BufferedImage encode(byte[] byArray, int n) throws QRException {
        return this.encode(IOUtils.toString(byArray), n);
    }

    public BufferedImage encode(String string) throws QRException {
        BitMatrix bitMatrix;
        try {
            bitMatrix = this.writer.encode(string, BarcodeFormat.QR_CODE, 0, 0, this.hints);
        }
        catch (WriterException writerException) {
            throw new QRException(writerException);
        }
        int n = bitMatrix.getWidth();
        int n2 = bitMatrix.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 6);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                bufferedImage.setRGB(i, j, bitMatrix.get(i, j) ? -16777216 : 0xFFFFFF);
            }
        }
        return bufferedImage;
    }

    public BufferedImage encode(String string, int n) throws QRException {
        if (n == 0) {
            return this.encode(string);
        }
        if (n < 0) {
            n = -n;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n, 6);
        BufferedImage bufferedImage2 = this.encode(string);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(bufferedImage2, 0, 0, n, n, null);
        graphics2D.dispose();
        return bufferedImage;
    }
}

