/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.sequence;

import com.bysquare.document.BysquareDocument;
import com.bysquare.document.invoice.Contact;
import com.bysquare.document.invoice.CustomerParty;
import com.bysquare.document.invoice.InvoiceBase;
import com.bysquare.document.invoice.MonetarySummary;
import com.bysquare.document.invoice.Party;
import com.bysquare.document.invoice.PostalAddress;
import com.bysquare.document.invoice.SingleInvoiceLine;
import com.bysquare.document.invoice.SupplierParty;
import com.bysquare.document.invoice.TaxCategorySummaries;
import com.bysquare.document.invoice.TaxCategorySummary;
import com.bysquare.sequence.SequenceEncoder;

class InvoiceBaseEncoder
extends SequenceEncoder {
    InvoiceBaseEncoder() {
    }

    private void encode(Contact contact) {
        if (contact != null) {
            this.add(contact.getName(), 13, 20);
            this.add(contact.getTelephone(), 14, 12);
            this.add(contact.getEMail(), 15, 40);
        } else {
            this.skip();
            this.skip();
            this.skip();
        }
    }

    private void encodeParty(Party party) {
        if (party != null) {
            this.add(party.getPartyName(), 17, 20);
            this.add(party.getCompanyTaxID(), 20, 12);
            this.add(party.getCompanyVATID(), 19, 14);
            this.add(party.getCompanyRegisterID(), 18, 14);
        } else {
            this.skip();
            this.skip();
            this.skip();
            this.skip();
        }
    }

    private void encode(CustomerParty customerParty) {
        this.encodeParty(customerParty);
        if (customerParty != null) {
            this.add(customerParty.getPartyIdentification(), 16, 20);
        } else {
            this.skip();
        }
    }

    private void encode(PostalAddress postalAddress) {
        if (postalAddress != null) {
            this.add(postalAddress.getStreetName(), 12, 20);
            this.add(postalAddress.getBuildingNumber(), 11, 3);
            this.add(postalAddress.getCityName(), 10, 20);
            this.add(postalAddress.getPostalZone(), 9, 10);
            this.add(postalAddress.getState(), 6, 10);
            this.add(postalAddress.getCountry());
        } else {
            this.skip();
            this.skip();
            this.skip();
            this.skip();
            this.skip();
            this.skip();
        }
    }

    private void encode(SupplierParty supplierParty) {
        this.encodeParty(supplierParty);
        if (supplierParty != null) {
            this.encode(supplierParty.getPostalAddress());
            this.encode(supplierParty.getContact());
        } else {
            this.encode((PostalAddress)null);
            this.encode((Contact)null);
        }
    }

    private void encode(SingleInvoiceLine singleInvoiceLine) {
        if (singleInvoiceLine != null) {
            this.add(singleInvoiceLine.getOrderLineID(), 5, 10);
            this.add(singleInvoiceLine.getDeliveryNoteLineID(), 4, 10);
            this.add(singleInvoiceLine.getItemName(), 2, 30);
            this.add(singleInvoiceLine.getItemEANCode(), 3, 30);
            this.add(singleInvoiceLine.getPeriodFromDate());
            this.add(singleInvoiceLine.getPeriodToDate());
            this.add(singleInvoiceLine.getInvoicedQuantity());
        } else {
            this.skip();
            this.skip();
            this.skip();
            this.skip();
            this.skip();
            this.skip();
            this.skip();
        }
    }

    private void encode(TaxCategorySummary taxCategorySummary) {
        if (taxCategorySummary != null) {
            this.add(taxCategorySummary.getClassifiedTaxCategory());
            this.add(taxCategorySummary.getTaxExclusiveAmount());
            this.add(taxCategorySummary.getTaxAmount());
            this.add(taxCategorySummary.getAlreadyClaimedTaxExclusiveAmount());
            this.add(taxCategorySummary.getAlreadyClaimedTaxAmount());
        } else {
            this.skip();
            this.skip();
            this.skip();
            this.skip();
            this.skip();
        }
    }

    private void encode(TaxCategorySummaries taxCategorySummaries) {
        this.add(taxCategorySummaries.size());
        for (TaxCategorySummary taxCategorySummary : taxCategorySummaries) {
            this.encode(taxCategorySummary);
        }
    }

    private void encode(MonetarySummary monetarySummary) {
        if (monetarySummary != null) {
            this.add(monetarySummary.getPayableRoundingAmount());
            this.add(monetarySummary.getPaidDepositsAmount());
        } else {
            this.skip();
            this.skip();
        }
    }

    private void encode(InvoiceBase invoiceBase) {
        this.add(invoiceBase.getInvoiceID(), 21, 10);
        this.add(invoiceBase.getIssueDate());
        this.add(invoiceBase.getTaxPointDate());
        this.add(invoiceBase.getOrderID(), 7, 10);
        this.add(invoiceBase.getDeliveryNoteID(), 8, 10);
        this.add(invoiceBase.getLocalCurrencyCode());
        this.add(invoiceBase.getForeignCurrencyCode());
        this.add(invoiceBase.getCurrRate());
        this.add(invoiceBase.getReferenceCurrRate());
        this.encode(invoiceBase.getSupplierParty());
        this.encode(invoiceBase.getCustomerParty());
        this.add(invoiceBase.getNumberOfInvoiceLines());
        this.add(invoiceBase.getInvoiceDescription(), 1, 30);
        this.encode(invoiceBase.getSingleInvoiceLine());
        this.encode(invoiceBase.getTaxCategorySummaries());
        this.encode(invoiceBase.getMonetarySummary());
        this.add(invoiceBase.getPaymentMeans());
    }

    protected void encodeInternal(BysquareDocument bysquareDocument) {
        this.encode((InvoiceBase)bysquareDocument);
    }

    protected int getFieldCount(BysquareDocument bysquareDocument) {
        return 40 + ((InvoiceBase)bysquareDocument).getTaxCategorySummaries().size() * 5;
    }
}

