/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.sequence;

import com.bysquare.document.BysquareDocument;
import com.bysquare.document.pay.BankAccount;
import com.bysquare.document.pay.BankAccounts;
import com.bysquare.document.pay.DirectDebitExt;
import com.bysquare.document.pay.DirectDebitScheme;
import com.bysquare.document.pay.DirectDebitType;
import com.bysquare.document.pay.Month;
import com.bysquare.document.pay.PayBase;
import com.bysquare.document.pay.Payment;
import com.bysquare.document.pay.PaymentOption;
import com.bysquare.document.pay.Payments;
import com.bysquare.document.pay.Periodicity;
import com.bysquare.document.pay.StandingOrderExt;
import com.bysquare.sequence.SequenceDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PayBaseDecoder
extends SequenceDecoder {
    PayBaseDecoder(Class<? extends BysquareDocument> clazz) {
        super(clazz);
    }

    private BankAccount decodeBankAccount() {
        BankAccount bankAccount = new BankAccount();
        bankAccount.setIBAN(this.nextString());
        bankAccount.setBIC(this.nextString());
        return bankAccount;
    }

    private BankAccounts decodeBankAccounts() {
        BankAccounts bankAccounts = new BankAccounts();
        int n = this.nextInt();
        while (n-- > 0) {
            bankAccounts.add(this.decodeBankAccount());
        }
        return bankAccounts;
    }

    private StandingOrderExt decodeStandingOrderExt() {
        if (this.nextInt() == 0) {
            return null;
        }
        StandingOrderExt standingOrderExt = new StandingOrderExt();
        standingOrderExt.setDay(this.nextInteger());
        standingOrderExt.setMonth(this.nextEnumList(Month.class));
        standingOrderExt.setPeriodicity(Periodicity.fromShortcut(this.nextString()));
        standingOrderExt.setLastDate(this.nextDate());
        return standingOrderExt;
    }

    private DirectDebitExt decodeDirectDebitExt() {
        if (this.nextInt() == 0) {
            return null;
        }
        DirectDebitExt directDebitExt = new DirectDebitExt();
        directDebitExt.setDirectDebitScheme(this.nextEnum(DirectDebitScheme.class));
        directDebitExt.setDirectDebitType(this.nextEnum(DirectDebitType.class));
        directDebitExt.setVariableSymbol(this.nextString());
        directDebitExt.setSpecificSymbol(this.nextString());
        directDebitExt.setOriginatorsReferenceInformation(this.nextString());
        directDebitExt.setMandateID(this.nextString());
        directDebitExt.setCreditorID(this.nextString());
        directDebitExt.setContractID(this.nextString());
        directDebitExt.setMaxAmount(this.nextDouble());
        directDebitExt.setValidTillDate(this.nextDate());
        return directDebitExt;
    }

    private Payment decodePayment() {
        Payment payment = new Payment();
        payment.setPaymentOptions(this.nextEnumList(PaymentOption.class));
        payment.setAmount(this.nextDouble());
        payment.setCurrencyCode(this.nextString());
        payment.setPaymentDueDate(this.nextDate());
        payment.setVariableSymbol(this.nextString());
        payment.setConstantSymbol(this.nextString());
        payment.setSpecificSymbol(this.nextString());
        payment.setOriginatorsReferenceInformation(this.nextString());
        payment.setPaymentNote(this.nextString());
        payment.setBankAccounts(this.decodeBankAccounts());
        payment.setStandingOrderExt(this.decodeStandingOrderExt());
        payment.setDirectDebitExt(this.decodeDirectDebitExt());
        return payment;
    }

    private Payments decodePayments() {
        Payments payments = new Payments();
        int n = this.nextInt();
        while (n-- > 0) {
            payments.add(this.decodePayment());
        }
        return payments;
    }

    @Override
    protected PayBase decode() {
        PayBase payBase = (PayBase)this.newDocument();
        payBase.setInvoiceID(this.nextString());
        payBase.setPayments(this.decodePayments());
        return payBase;
    }
}

