/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.sequence;

import com.bysquare.document.BysquareDocument;
import com.bysquare.document.invoice.InvoiceBase;
import com.bysquare.document.invoiceitems.InvoiceItemsBase;
import com.bysquare.document.pay.PayBase;
import com.bysquare.sequence.InvoiceBaseDecoder;
import com.bysquare.sequence.InvoiceItemsBaseDecoder;
import com.bysquare.sequence.PayBaseDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SequenceDecoder {
    private final Class<? extends BysquareDocument> clazz;
    private final SimpleDateFormat dateFormat;
    private String[] fields;
    private int index;

    public static SequenceDecoder getInstance(Class<? extends BysquareDocument> clazz) {
        if (PayBase.class.isAssignableFrom(clazz)) {
            return new PayBaseDecoder(clazz);
        }
        if (InvoiceBase.class.isAssignableFrom(clazz)) {
            return new InvoiceBaseDecoder(clazz);
        }
        if (InvoiceItemsBase.class.isAssignableFrom(clazz)) {
            return new InvoiceItemsBaseDecoder(clazz);
        }
        return null;
    }

    SequenceDecoder(Class<? extends BysquareDocument> clazz) {
        this.clazz = clazz;
        this.dateFormat = new SimpleDateFormat("yyyyMMdd");
        this.dateFormat.setLenient(false);
    }

    protected abstract BysquareDocument decode();

    public BysquareDocument decode(String string) {
        this.fields = string.split("\t");
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i].length() != 0) continue;
            this.fields[i] = null;
        }
        this.index = 0;
        BysquareDocument bysquareDocument = this.decode();
        this.fields = null;
        return bysquareDocument;
    }

    protected BysquareDocument newDocument() {
        try {
            return this.clazz.newInstance();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private String next() {
        if (this.index < this.fields.length) {
            return this.fields[this.index++];
        }
        return null;
    }

    protected Date nextDate() {
        String string = this.nextString();
        if (string == null || string.length() != 8) {
            return null;
        }
        try {
            return this.dateFormat.parse(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected Double nextDouble() {
        String string = this.nextString();
        if (string == null) {
            return null;
        }
        try {
            return Double.valueOf(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected <E extends Enum<E>> E nextEnum(Class<E> clazz) {
        Integer n = this.nextInteger();
        if (n == null) {
            return null;
        }
        try {
            return (E)((Enum[])clazz.getEnumConstants())[n];
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected <E extends Enum<E>> List<E> nextEnumList(Class<E> clazz) {
        int n = this.nextInt();
        if (n == 0) {
            return null;
        }
        ArrayList<Enum> arrayList = new ArrayList<Enum>(Integer.bitCount(n));
        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
            if ((1 << enum_.ordinal() & n) == 0) continue;
            arrayList.add(enum_);
        }
        return arrayList;
    }

    protected int nextInt() {
        String string = this.nextString();
        if (string == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    protected Integer nextInteger() {
        String string = this.nextString();
        if (string == null) {
            return null;
        }
        try {
            return Integer.valueOf(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected String nextString() {
        return this.next();
    }
}

