/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import java.util.Locale;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.data.StringTextValue;
import net.sf.jasperreports.engine.export.data.TextValue;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.TypeTextValueHandler;
import net.sf.jasperreports.engine.export.ooxml.XlsxStyleHelper;

public class XlsxCellHelper
extends BaseHelper {
    private XlsxStyleHelper styleHelper;
    private final TypeTextValueHandler textValueHandler = new TypeTextValueHandler();

    public XlsxCellHelper(JasperReportsContext jasperReportsContext, Writer writer, XlsxStyleHelper styleHelper) {
        super(jasperReportsContext, writer);
        this.styleHelper = styleHelper;
    }

    public void exportHeader(JRExporterGridCell gridCell, int rowIndex, int colIndex, int maxColIndex) {
        this.exportHeader(gridCell, rowIndex, colIndex, maxColIndex, null, null, null, true, false, false, false, false);
    }

    public void exportHeader(JRExporterGridCell gridCell, int rowIndex, int colIndex, int maxColIndex, TextValue textValue, String pattern, Locale locale, boolean isWrapText, boolean isHidden, boolean isLocked, boolean isShrinkToFit, boolean isIgnoreTextFormatting) {
        try {
            if (textValue != null) {
                textValue.handle(this.textValueHandler);
            } else {
                this.textValueHandler.handle((StringTextValue)null);
            }
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
        this.write("  <c r=\"" + JRXlsAbstractExporter.getColumIndexName(colIndex, maxColIndex) + (rowIndex + 1) + "\" s=\"" + this.styleHelper.getCellStyle(gridCell, pattern, locale, isWrapText, isHidden, isLocked, isShrinkToFit, isIgnoreTextFormatting) + "\"");
        String type = this.textValueHandler.getType();
        if (type != null) {
            this.write(" t=\"" + type + "\"");
        }
        this.write(">");
    }

    public void exportFooter() {
        this.write("</c>");
    }
}

