/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.fill.VirtualizerStore;
import net.sf.jasperreports.engine.util.JRSwapFile;
import net.sf.jasperreports.engine.util.StreamCompression;
import net.sf.jasperreports.engine.util.VirtualizationSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SwapFileVirtualizerStore
implements VirtualizerStore {
    private static final Log log = LogFactory.getLog(SwapFileVirtualizerStore.class);
    public static final String EXCEPTION_MESSAGE_KEY_DEVIRTUALIZING_ERROR = "util.swap.file.virtualizer.devirtualizing.error";
    public static final String EXCEPTION_MESSAGE_KEY_UNABLE_TO_READ_DATA = "util.swap.file.virtualizer.unable.to.read.data";
    public static final String EXCEPTION_MESSAGE_KEY_VIRTUALIZING_ERROR = "util.swap.file.virtualizer.virtualizing.error";
    private final JRSwapFile swap;
    private final boolean swapOwner;
    private final Map<String, JRSwapFile.SwapHandle> handles;
    private final StreamCompression compression;

    public SwapFileVirtualizerStore(JRSwapFile swap, boolean swapOwner) {
        this(swap, swapOwner, null);
    }

    public SwapFileVirtualizerStore(JRSwapFile swap, boolean swapOwner, StreamCompression compression) {
        this.swap = swap;
        this.swapOwner = swapOwner;
        this.handles = Collections.synchronizedMap(new HashMap());
        this.compression = compression;
    }

    public String toString() {
        return "SwapFileVirtualizerStore " + this.swap.toString();
    }

    protected boolean isStored(JRVirtualizable<?> o) {
        return this.handles.containsKey(o.getUID());
    }

    @Override
    public boolean store(JRVirtualizable<?> o, VirtualizationSerializer serializer) {
        if (this.isStored(o)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("object " + o.getUID() + " already stored"));
            }
            return false;
        }
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(3000);
            ByteArrayOutputStream out = this.compression == null ? bout : this.compression.compressedOutput(bout);
            serializer.writeData(o, out);
            ((OutputStream)out).close();
            byte[] data = bout.toByteArray();
            if (log.isTraceEnabled()) {
                log.trace((Object)("writing " + data.length + " for object " + o.getUID() + " to " + this.swap));
            }
            JRSwapFile.SwapHandle handle = this.swap.write(data);
            this.handles.put(o.getUID(), handle);
            return true;
        }
        catch (IOException e) {
            log.error((Object)("Error virtualizing object " + o.getUID() + " to " + this.swap), (Throwable)e);
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_VIRTUALIZING_ERROR, null, e);
        }
    }

    @Override
    public void retrieve(JRVirtualizable<?> o, boolean remove, VirtualizationSerializer serializer) {
        JRSwapFile.SwapHandle handle = this.handles.get(o.getUID());
        if (handle == null) {
            log.error((Object)("No swap handle found for " + o.getUID() + " in " + this));
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNABLE_TO_READ_DATA, (Object[])null);
        }
        try {
            byte[] data = this.swap.read(handle, remove);
            if (log.isTraceEnabled()) {
                log.trace((Object)("read " + data.length + " for object " + o.getUID() + " from " + this.swap));
            }
            ByteArrayInputStream rawInput = new ByteArrayInputStream(data);
            ByteArrayInputStream input = this.compression == null ? rawInput : this.compression.uncompressedInput(rawInput);
            serializer.readData(o, input);
            ((InputStream)input).close();
        }
        catch (IOException e) {
            log.error((Object)("Error reading object data " + o.getUID() + " from " + this.swap), (Throwable)e);
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_DEVIRTUALIZING_ERROR, null, e);
        }
        if (remove) {
            this.handles.remove(o.getUID());
        }
    }

    @Override
    public void remove(String objectId) {
        JRSwapFile.SwapHandle handle = this.handles.remove(objectId);
        if (handle == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("object " + objectId + " not found for removal"));
            }
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)("removing object " + objectId + " from " + this.swap));
            }
            this.swap.free(handle);
        }
    }

    @Override
    public void dispose() {
        this.handles.clear();
        if (this.swapOwner) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("disposing " + this.swap));
            }
            this.swap.dispose();
        }
    }
}

