/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.LineSpacingEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;
import net.sf.jasperreports.engine.xml.JRBaseFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;

public class JRTextElementFactory
extends JRBaseFactory {
    private static final Log log = LogFactory.getLog(JRTextElementFactory.class);

    public Object createObject(Attributes atts) {
        LineSpacingEnum lineSpacing;
        RotationEnum rotation;
        VerticalTextAlignEnum verticalTextAlign;
        JRDesignTextElement textElement = (JRDesignTextElement)this.digester.peek();
        HorizontalTextAlignEnum horizontalTextAlign = HorizontalTextAlignEnum.getByName(atts.getValue("textAlignment"));
        if (horizontalTextAlign != null) {
            textElement.setHorizontalTextAlign(horizontalTextAlign);
        }
        if ((verticalTextAlign = VerticalTextAlignEnum.getByName(atts.getValue("verticalAlignment"))) != null) {
            textElement.setVerticalTextAlign(verticalTextAlign);
        }
        if ((rotation = RotationEnum.getByName(atts.getValue("rotation"))) != null) {
            textElement.setRotation(rotation);
        }
        if ((lineSpacing = LineSpacingEnum.getByName(atts.getValue("lineSpacing"))) != null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"The 'lineSpacing' attribute is deprecated. Use the <paragraph> tag instead.");
            }
            textElement.getParagraph().setLineSpacing(lineSpacing);
        }
        textElement.setMarkup(atts.getValue("markup"));
        String isStyledText = atts.getValue("isStyledText");
        if (isStyledText != null && isStyledText.length() > 0) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"The 'isStyledText' attribute is deprecated. Use the 'markup' attribute instead.");
            }
            textElement.setMarkup(Boolean.valueOf(isStyledText) != false ? "styled" : "none");
        }
        return textElement;
    }
}

