/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import jxl.CellView;
import jxl.JXLException;
import jxl.Range;
import jxl.SheetSettings;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.biff.DisplayFormat;
import jxl.format.Alignment;
import jxl.format.BoldStyle;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.Orientation;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;
import jxl.format.Pattern;
import jxl.format.RGB;
import jxl.format.UnderlineStyle;
import jxl.format.VerticalAlignment;
import jxl.read.biff.BiffException;
import jxl.write.Blank;
import jxl.write.Boolean;
import jxl.write.DateFormat;
import jxl.write.DateTime;
import jxl.write.Formula;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableHyperlink;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.CellValue;
import jxl.write.biff.RowsExceededException;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRCommonGraphicElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.export.Cut;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.GenericElementJExcelApiHandler;
import net.sf.jasperreports.engine.export.HyperlinkUtil;
import net.sf.jasperreports.engine.export.JExcelApiExporterContext;
import net.sf.jasperreports.engine.export.JExcelApiExporterNature;
import net.sf.jasperreports.engine.export.JExcelApiLocalHyperlinkInfo;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterNature;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.OccupiedGridCell;
import net.sf.jasperreports.engine.export.XlsRowLevelInfo;
import net.sf.jasperreports.engine.export.data.BooleanTextValue;
import net.sf.jasperreports.engine.export.data.DateTextValue;
import net.sf.jasperreports.engine.export.data.NumberTextValue;
import net.sf.jasperreports.engine.export.data.StringTextValue;
import net.sf.jasperreports.engine.export.data.TextValue;
import net.sf.jasperreports.engine.export.data.TextValueHandler;
import net.sf.jasperreports.engine.export.type.ImageAnchorTypeEnum;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.type.RenderableTypeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.export.JxlExporterConfiguration;
import net.sf.jasperreports.export.JxlReportConfiguration;
import net.sf.jasperreports.export.XlsExporterConfiguration;
import net.sf.jasperreports.export.XlsReportConfiguration;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JExcelApiExporter
extends JRXlsAbstractExporter<JxlReportConfiguration, JxlExporterConfiguration, JExcelApiExporterContext> {
    private static final Log log = LogFactory.getLog(JExcelApiExporter.class);
    public static final String PROPERTY_USE_TEMP_FILE = "net.sf.jasperreports.export.jxl.use.temp.file";
    public static final String PROPERTY_COMPLEX_FORMAT = "net.sf.jasperreports.export.jxl.cell.complex.format";
    public static final String JXL_EXPORTER_KEY = "net.sf.jasperreports.jxl";
    protected static final Colour WHITE = Colour.WHITE;
    protected static final Colour BLACK = Colour.BLACK;
    protected static final String EMPTY_SHEET_NAME = "Sheet1";
    private static Map<Color, Colour> colorsCache = new ReferenceMap();
    private static final Colour[] FIXED_COLOURS = new Colour[]{WHITE, BLACK, Colour.PALETTE_BLACK, Colour.DEFAULT_BACKGROUND, Colour.DEFAULT_BACKGROUND1, Colour.AUTOMATIC, Colour.UNKNOWN};
    private Map<StyleInfo, WritableCellFormat> loadedCellStyles = new HashMap<StyleInfo, WritableCellFormat>();
    private WritableWorkbook workbook;
    private WritableSheet sheet;
    private Pattern backgroundMode = Pattern.SOLID;
    private Map<String, NumberFormat> numberFormats = new HashMap<String, NumberFormat>();
    private Map<String, DateFormat> dateFormats = new HashMap<String, DateFormat>();
    protected Map<Color, Colour> workbookColours = new HashMap<Color, Colour>();
    protected Map<Colour, RGB> usedColours = new HashMap<Colour, RGB>();
    protected Map<String, List<JExcelApiLocalHyperlinkInfo>> anchorLinks = new HashMap<String, List<JExcelApiLocalHyperlinkInfo>>();
    protected Map<Integer, List<JExcelApiLocalHyperlinkInfo>> pageLinks = new HashMap<Integer, List<JExcelApiLocalHyperlinkInfo>>();

    public JExcelApiExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JExcelApiExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.exporterContext = new ExporterContext();
        this.maxColumnIndex = 255;
    }

    @Override
    protected Class<JxlExporterConfiguration> getConfigurationInterface() {
        return JxlExporterConfiguration.class;
    }

    @Override
    protected Class<JxlReportConfiguration> getItemConfigurationInterface() {
        return JxlReportConfiguration.class;
    }

    @Override
    protected void initExport() {
        super.initExport();
        XlsExporterConfiguration configuration = (XlsExporterConfiguration)this.getCurrentConfiguration();
        if (configuration.isCreateCustomPalette().booleanValue()) {
            this.initCustomPalette();
        }
        this.sheet = null;
    }

    @Override
    protected void initReport() {
        super.initReport();
        XlsReportConfiguration configuration = (XlsReportConfiguration)this.getCurrentItemConfiguration();
        this.backgroundMode = configuration.isWhitePageBackground() != false ? Pattern.SOLID : Pattern.NONE;
        this.nature = new JExcelApiExporterNature(this.jasperReportsContext, this.filter, configuration.isIgnoreGraphics(), configuration.isIgnorePageMargins());
    }

    protected void initCustomPalette() {
        for (int i = 0; i < FIXED_COLOURS.length; ++i) {
            Colour colour = FIXED_COLOURS[i];
            this.setColourUsed(colour);
        }
    }

    protected void setColourUsed(Colour colour) {
        this.usedColours.put(colour, colour.getDefaultRGB());
    }

    protected void setColourUsed(Colour colour, Color reportColour) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Modifying palette colour " + colour.getValue() + " to " + reportColour));
        }
        int red = reportColour.getRed();
        int green = reportColour.getGreen();
        int blue = reportColour.getBlue();
        this.workbook.setColourRGB(colour, red, green, blue);
        RGB customRGB = new RGB(red, green, blue);
        this.usedColours.put(colour, customRGB);
    }

    @Override
    protected void openWorkbook(OutputStream os) throws JRException {
        JxlExporterConfiguration configuration = (JxlExporterConfiguration)this.getCurrentConfiguration();
        WorkbookSettings settings = new WorkbookSettings();
        settings.setUseTemporaryFileDuringWrite(configuration.isUseTempFile().booleanValue());
        InputStream templateIs = null;
        try {
            String lcWorkbookTemplate;
            String string = lcWorkbookTemplate = this.workbookTemplate == null ? configuration.getWorkbookTemplate() : this.workbookTemplate;
            if (lcWorkbookTemplate == null) {
                this.workbook = Workbook.createWorkbook((OutputStream)os, (WorkbookSettings)settings);
            } else {
                templateIs = RepositoryUtil.getInstance(this.jasperReportsContext).getInputStreamFromLocation(lcWorkbookTemplate);
                if (templateIs == null) {
                    throw new JRRuntimeException("export.xls.common.template.not.found", new Object[]{lcWorkbookTemplate});
                }
                Workbook template = Workbook.getWorkbook((InputStream)templateIs);
                this.workbook = Workbook.createWorkbook((OutputStream)os, (Workbook)template, (WorkbookSettings)settings);
                boolean keepSheets = this.keepTemplateSheets == null ? configuration.isKeepWorkbookTemplateSheets() : this.keepTemplateSheets;
                if (!keepSheets) {
                    for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
                        this.workbook.removeSheet(i);
                    }
                } else {
                    this.sheetIndex += this.workbook.getNumberOfSheets();
                }
            }
            this.firstPageNotSet = true;
            this.anchorLinks.clear();
            this.pageLinks.clear();
        }
        catch (IOException e) {
            throw new JRException("export.xls.common.report.generation.error", new Object[]{this.jasperPrint.getName()}, e);
        }
        catch (BiffException e) {
            throw new JRException("export.xls.common.report.generation.error", new Object[]{this.jasperPrint.getName()}, e);
        }
        finally {
            if (templateIs != null) {
                try {
                    templateIs.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    protected void createSheet(CutsInfo xCuts, JRXlsAbstractExporter.SheetInfo sheetInfo) {
        this.sheet = this.workbook.createSheet(sheetInfo.sheetName, Integer.MAX_VALUE);
        this.setSheetSettings(sheetInfo, this.sheet);
    }

    @Override
    protected void closeSheet() {
        if (this.sheet == null) {
            return;
        }
        if (this.sheetInfo.sheetPageScale != null && this.sheetInfo.sheetPageScale > 9 && this.sheetInfo.sheetPageScale < 401) {
            SheetSettings sheetSettings = this.sheet.getSettings();
            sheetSettings.setScaleFactor(this.sheetInfo.sheetPageScale.intValue());
            sheetSettings.setFitWidth(0);
            sheetSettings.setFitHeight(0);
            sheetSettings.setFitToPages(false);
        } else {
            JxlReportConfiguration configuration = (JxlReportConfiguration)this.getCurrentItemConfiguration();
            Integer fitWidth = configuration.getFitWidth();
            Integer fitHeight = configuration.getFitHeight();
            Integer n = fitHeight == null ? (java.lang.Boolean.TRUE == configuration.isAutoFitPageHeight() ? Integer.valueOf(this.pageIndex - this.sheetInfo.sheetFirstPageIndex) : null) : (fitHeight = fitHeight);
            if (fitWidth != null || fitWidth != null) {
                SheetSettings sheetSettings = this.sheet.getSettings();
                sheetSettings.setFitWidth(fitWidth == null ? 1 : fitWidth);
                sheetSettings.setFitHeight(fitHeight == null ? 1 : fitHeight);
                sheetSettings.setFitToPages(true);
            }
        }
    }

    @Override
    protected void closeWorkbook(OutputStream os) throws JRException {
        if (this.sheet == null) {
            this.workbook.createSheet(EMPTY_SHEET_NAME, Integer.MAX_VALUE);
        }
        Range[] range = null;
        List<JExcelApiLocalHyperlinkInfo> hyperlinkInfoList = null;
        for (String href : this.anchorLinks.keySet()) {
            range = this.workbook.findByName(href);
            hyperlinkInfoList = this.anchorLinks.get(href);
            if (range == null || hyperlinkInfoList == null) continue;
            for (JExcelApiLocalHyperlinkInfo hyperlinkInfo : hyperlinkInfoList) {
                WritableSheet anchorSheet = this.workbook.getSheet(range[0].getFirstSheetIndex());
                WritableHyperlink hyperlink = new WritableHyperlink(hyperlinkInfo.getCol(), hyperlinkInfo.getRow(), hyperlinkInfo.getLastCol(), hyperlinkInfo.getLastRow(), hyperlinkInfo.getDescription(), anchorSheet, range[0].getTopLeft().getColumn(), range[0].getTopLeft().getRow(), range[0].getBottomRight().getColumn(), range[0].getBottomRight().getRow());
                try {
                    hyperlinkInfo.getSheet().addHyperlink(hyperlink);
                }
                catch (Exception e) {
                    throw new JRException(e);
                }
            }
        }
        int index = 0;
        for (Integer linkPage : this.pageLinks.keySet()) {
            hyperlinkInfoList = this.pageLinks.get(linkPage);
            if (hyperlinkInfoList == null || hyperlinkInfoList.isEmpty()) continue;
            WritableSheet anchorSheet = null;
            for (JExcelApiLocalHyperlinkInfo hyperlinkInfo : hyperlinkInfoList) {
                index = this.onePagePerSheetMap.get(linkPage - 1) != null ? (((java.lang.Boolean)this.onePagePerSheetMap.get(linkPage - 1)).booleanValue() ? Math.max(0, linkPage - 1) : Math.max(0, (Integer)this.sheetsBeforeCurrentReportMap.get(linkPage))) : 0;
                anchorSheet = this.workbook.getSheet(index);
                WritableHyperlink hyperlink = new WritableHyperlink(hyperlinkInfo.getCol(), hyperlinkInfo.getRow(), hyperlinkInfo.getLastCol(), hyperlinkInfo.getLastRow(), hyperlinkInfo.getDescription(), anchorSheet, 0, 0, 0, 0);
                try {
                    hyperlinkInfo.getSheet().addHyperlink(hyperlink);
                }
                catch (Exception e) {
                    throw new JRException(e);
                }
            }
        }
        try {
            this.workbook.write();
            this.workbook.close();
        }
        catch (IOException e) {
            throw new JRException("export.xls.common.report.generation.error", new Object[]{this.jasperPrint.getName()}, e);
        }
        catch (WriteException e) {
            throw new JRException("export.xls.common.report.generation.error", new Object[]{this.jasperPrint.getName()}, e);
        }
    }

    @Override
    protected void setColumnWidth(int col, int width, boolean autoFit) {
        CellView cv = new CellView();
        if (autoFit) {
            cv.setAutosize(true);
        } else {
            cv.setSize(43 * width);
        }
        this.sheet.setColumnView(col, cv);
    }

    @Override
    protected void setRowHeight(int rowIndex, int lastRowHeight, Cut yCut, XlsRowLevelInfo levelInfo) throws JRException {
        boolean isAutoFit;
        boolean bl = isAutoFit = yCut.hasProperty("net.sf.jasperreports.export.xls.auto.fit.row") && (java.lang.Boolean)yCut.getProperty("net.sf.jasperreports.export.xls.auto.fit.row") != false;
        if (!isAutoFit) {
            try {
                this.sheet.setRowView(rowIndex, LengthUtil.twip(lastRowHeight));
            }
            catch (RowsExceededException e) {
                throw new JRException("export.xls.common.report.generation.error", new Object[]{this.jasperPrint.getName()}, e);
            }
        }
    }

    @Override
    protected void addRowBreak(int rowIndex) {
        this.sheet.addRowPageBreak(rowIndex);
    }

    @Override
    protected void addBlankCell(JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        Colour forecolor = BLACK;
        if (gridCell.getForecolor() != null) {
            forecolor = this.getWorkbookColour(gridCell.getForecolor());
        }
        Pattern mode = this.backgroundMode;
        Colour backcolor = WHITE;
        JxlReportConfiguration configuration = (JxlReportConfiguration)this.getCurrentItemConfiguration();
        if (!configuration.isIgnoreCellBackground().booleanValue() && gridCell.getCellBackcolor() != null) {
            mode = Pattern.SOLID;
            backcolor = this.getWorkbookColour(gridCell.getCellBackcolor(), true);
        }
        WritableFont cellFont = this.getLoadedFont(this.getDefaultFont(), forecolor.getValue(), this.getLocale());
        WritableCellFormat cellStyle = this.getLoadedCellStyle(mode, backcolor, cellFont, gridCell, true, false, false);
        try {
            this.sheet.addCell((WritableCell)new Blank(colIndex, rowIndex, (CellFormat)cellStyle));
        }
        catch (RowsExceededException e) {
            throw new JRException("export.xls.common.report.generation.error", new Object[]{this.jasperPrint.getName()}, e);
        }
        catch (WriteException e) {
            throw new JRException("export.xls.common.report.generation.error", new Object[]{this.jasperPrint.getName()}, e);
        }
    }

    @Override
    protected void addOccupiedCell(OccupiedGridCell occupiedGridCell, int colIndex, int rowIndex) throws JRException {
    }

    @Override
    protected void exportLine(JRPrintLine line, JRExporterGridCell gridCell, int col, int row) throws JRException {
        this.addMergeRegion(gridCell, col, row);
        Colour forecolor2 = this.getWorkbookColour(line.getLinePen().getLineColor());
        WritableFont cellFont2 = this.getLoadedFont(this.getDefaultFont(), forecolor2.getValue(), this.getLocale());
        Colour backcolor = WHITE;
        Pattern mode = this.backgroundMode;
        JxlReportConfiguration configuration = (JxlReportConfiguration)this.getCurrentItemConfiguration();
        if (!configuration.isIgnoreCellBackground().booleanValue() && gridCell.getCellBackcolor() != null) {
            mode = Pattern.SOLID;
            backcolor = this.getWorkbookColour(gridCell.getCellBackcolor(), true);
        }
        int side = 0;
        float ratio = line.getWidth() / line.getHeight();
        side = ratio > 1.0f ? (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? 0 : 2) : (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? 1 : 3);
        BoxStyle boxStyle = new BoxStyle(side, line.getLinePen());
        WritableCellFormat cellStyle2 = this.getLoadedCellStyle(mode, backcolor, cellFont2, boxStyle, this.isWrapText(line), this.isCellLocked(line), this.isShrinkToFit(line));
        Blank cell2 = new Blank(col, row, (CellFormat)cellStyle2);
        try {
            this.sheet.addCell((WritableCell)cell2);
        }
        catch (Exception e) {
            throw new JRException("export.xls.common.cannot.add.cell", null, e);
        }
    }

    @Override
    protected void exportRectangle(JRPrintGraphicElement element, JRExporterGridCell gridCell, int col, int row) throws JRException {
        this.addMergeRegion(gridCell, col, row);
        Colour backcolor = WHITE;
        Pattern mode = this.backgroundMode;
        JxlReportConfiguration configuration = (JxlReportConfiguration)this.getCurrentItemConfiguration();
        if (!configuration.isIgnoreCellBackground().booleanValue() && gridCell.getCellBackcolor() != null) {
            mode = Pattern.SOLID;
            backcolor = this.getWorkbookColour(gridCell.getCellBackcolor(), true);
        }
        Colour forecolor = this.getWorkbookColour(element.getLinePen().getLineColor());
        WritableFont cellFont2 = this.getLoadedFont(this.getDefaultFont(), forecolor.getValue(), this.getLocale());
        WritableCellFormat cellStyle2 = this.getLoadedCellStyle(mode, backcolor, cellFont2, gridCell, this.isWrapText(element), this.isCellLocked(element), this.isShrinkToFit(element));
        Blank cell2 = new Blank(col, row, (CellFormat)cellStyle2);
        try {
            this.sheet.addCell((WritableCell)cell2);
        }
        catch (Exception e) {
            throw new JRException("export.xls.common.cannot.add.cell", null, e);
        }
    }

    @Override
    public void exportText(JRPrintText text, JRExporterGridCell gridCell, int col, int row) throws JRException {
        this.addMergeRegion(gridCell, col, row);
        JRStyledText styledText = this.getStyledText(text);
        if (styledText != null) {
            java.lang.Boolean ignoreHyperlink;
            StyleInfo baseStyle;
            Colour forecolor = this.getWorkbookColour(text.getForecolor());
            WritableFont cellFont = this.getLoadedFont(text, forecolor.getValue(), this.getTextLocale(text));
            JRXlsAbstractExporter.TextAlignHolder alignment = JExcelApiExporter.getTextAlignHolder(text);
            int horizontalAlignment = this.getHorizontalAlignment(alignment);
            int verticalAlignment = this.getVerticalAlignment(alignment);
            int rotation = this.getRotation(alignment);
            Pattern mode = this.backgroundMode;
            Colour backcolor = WHITE;
            JxlReportConfiguration configuration = (JxlReportConfiguration)this.getCurrentItemConfiguration();
            if (!configuration.isIgnoreCellBackground().booleanValue() && gridCell.getCellBackcolor() != null) {
                mode = Pattern.SOLID;
                backcolor = this.getWorkbookColour(gridCell.getCellBackcolor(), true);
            }
            StyleInfo styleInfo = this.isIgnoreTextFormatting(text) ? new StyleInfo(mode, WHITE, horizontalAlignment, verticalAlignment, 0, null, (JRExporterGridCell)null, this.isWrapText(text) || java.lang.Boolean.TRUE.equals(((JRXlsExporterNature)this.nature).getColumnAutoFit(text)), this.isCellLocked(text), this.isShrinkToFit(text)) : (baseStyle = new StyleInfo(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, cellFont, gridCell, this.isWrapText(text) || java.lang.Boolean.TRUE.equals(((JExcelApiExporterNature)this.nature).getColumnAutoFit(text)), this.isCellLocked(text), this.isShrinkToFit(text)));
            if (!configuration.isIgnoreAnchors().booleanValue() && text.getAnchorName() != null) {
                int lastCol = Math.max(0, col + gridCell.getColSpan() - 1);
                int lastRow = Math.max(0, row + gridCell.getRowSpan() - 1);
                this.workbook.addNameArea(text.getAnchorName(), this.sheet, col, row, lastCol, lastRow);
            }
            if ((ignoreHyperlink = HyperlinkUtil.getIgnoreHyperlink("net.sf.jasperreports.export.xls.ignore.hyperlink", text)) == null) {
                ignoreHyperlink = configuration.isIgnoreHyperlink();
            }
            if (!ignoreHyperlink.booleanValue()) {
                this.exportHyperlink(text, styledText.getText(), gridCell, col, row);
            }
            try {
                this.addCell(col, row, text, styledText.getText(), baseStyle);
            }
            catch (Exception e) {
                throw new JRException("export.xls.common.cannot.add.cell", null, e);
            }
        }
    }

    public void exportHyperlink(JRPrintHyperlink link, String description, JRExporterGridCell gridCell, int col, int row) throws JRException {
        block10: {
            JRHyperlinkProducer customHandler;
            block9: {
                customHandler = this.getHyperlinkProducer(link);
                if (customHandler != null) break block9;
                switch (link.getHyperlinkTypeValue()) {
                    case REFERENCE: {
                        this.exportHyperlink(link.getHyperlinkReference(), col, row, col, row);
                        break;
                    }
                    case LOCAL_ANCHOR: {
                        String href;
                        if (!((JxlReportConfiguration)this.getCurrentItemConfiguration()).isIgnoreAnchors().booleanValue() && (href = link.getHyperlinkAnchor()) != null) {
                            int lastCol = Math.max(0, col + gridCell.getColSpan() - 1);
                            int lastRow = Math.max(0, row + gridCell.getRowSpan() - 1);
                            JExcelApiLocalHyperlinkInfo hyperlinkInfo = new JExcelApiLocalHyperlinkInfo(description, this.sheet, col, row, lastCol, lastRow);
                            if (this.anchorLinks.containsKey(href)) {
                                this.anchorLinks.get(href).add(hyperlinkInfo);
                                break;
                            }
                            ArrayList<JExcelApiLocalHyperlinkInfo> hyperlinkInfoList = new ArrayList<JExcelApiLocalHyperlinkInfo>();
                            hyperlinkInfoList.add(hyperlinkInfo);
                            this.anchorLinks.put(href, hyperlinkInfoList);
                            break;
                        }
                        break block10;
                    }
                    case LOCAL_PAGE: {
                        Integer href;
                        if (!((JxlReportConfiguration)this.getCurrentItemConfiguration()).isIgnoreAnchors().booleanValue() && (href = Integer.valueOf(((JxlReportConfiguration)this.getCurrentItemConfiguration()).isOnePagePerSheet() != false ? link.getHyperlinkPage() : 0)) != null) {
                            int lastCol = Math.max(0, col + gridCell.getColSpan() - 1);
                            int lastRow = Math.max(0, row + gridCell.getRowSpan() - 1);
                            JExcelApiLocalHyperlinkInfo hyperlinkInfo = new JExcelApiLocalHyperlinkInfo(description, this.sheet, col, row, lastCol, lastRow);
                            if (this.pageLinks.containsKey(this.sheetsBeforeCurrentReport + href)) {
                                this.pageLinks.get(this.sheetsBeforeCurrentReport + href).add(hyperlinkInfo);
                                break;
                            }
                            ArrayList<JExcelApiLocalHyperlinkInfo> hyperlinkInfoList = new ArrayList<JExcelApiLocalHyperlinkInfo>();
                            hyperlinkInfoList.add(hyperlinkInfo);
                            this.pageLinks.put(this.sheetsBeforeCurrentReport + href, hyperlinkInfoList);
                            break;
                        }
                        break block10;
                    }
                }
                break block10;
            }
            this.exportHyperlink(customHandler.getHyperlink(link), col, row, col, row);
        }
    }

    protected void exportHyperlink(String href, int col, int row, int lastCol, int lastRow) throws JRException {
        if (href != null) {
            try {
                URL url = new URL(href);
                WritableHyperlink hyperlink = new WritableHyperlink(col, row, lastCol, lastRow, url);
                this.sheet.addHyperlink(hyperlink);
            }
            catch (MalformedURLException e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Reference \"" + href + "\" could not be parsed as URL."), (Throwable)e);
                }
            }
            catch (Exception e) {
                throw new JRException(e);
            }
        }
    }

    protected void addCell(int x, int y, JRPrintText text, String textStr, StyleInfo baseStyle) throws WriteException, RowsExceededException, JRException {
        CellValue cellValue = null;
        TextValue textValue = null;
        String textFormula = this.getFormula(text);
        if (textFormula != null) {
            textValue = this.getTextValue(text, textStr);
            cellValue = this.getFormulaCellValue(x, y, text, textValue, textFormula, baseStyle, this.isComplexFormat(text));
        }
        if (cellValue == null) {
            JxlReportConfiguration configuration = (JxlReportConfiguration)this.getCurrentItemConfiguration();
            if (configuration.isDetectCellType().booleanValue()) {
                if (textFormula == null) {
                    textValue = this.getTextValue(text, textStr);
                }
                cellValue = this.getDetectedCellValue(x, y, text, textValue, baseStyle, this.isComplexFormat(text));
            } else {
                cellValue = this.getLabelCell(x, y, textStr, baseStyle);
            }
        }
        this.sheet.addCell(cellValue);
    }

    protected CellValue getFormulaCellValue(int x, int y, JRPrintText textElement, TextValue textValue, String formula, StyleInfo baseStyle, boolean complexFormat) throws JRException {
        FormulaTextValueHandler handler = new FormulaTextValueHandler(x, y, textElement, formula, baseStyle, complexFormat);
        textValue.handle(handler);
        return handler.getResult();
    }

    protected CellValue getDetectedCellValue(int x, int y, JRPrintText textElement, TextValue textValue, StyleInfo baseStyle, boolean complexFormat) throws JRException {
        CellTextValueHandler handler = new CellTextValueHandler(x, y, textElement, baseStyle, complexFormat);
        textValue.handle(handler);
        return handler.getResult();
    }

    protected NumberFormat getNumberFormat(String convertedPattern, boolean isComplexFormat) {
        NumberFormat cellFormat = this.numberFormats.get(convertedPattern);
        if (cellFormat == null) {
            cellFormat = isComplexFormat ? new NumberFormat(convertedPattern, NumberFormat.COMPLEX_FORMAT) : new NumberFormat(convertedPattern);
            this.numberFormats.put(convertedPattern, cellFormat);
        }
        return cellFormat;
    }

    protected DateFormat getDateFormat(String convertedPattern) {
        DateFormat cellFormat = this.dateFormats.get(convertedPattern);
        if (cellFormat == null) {
            cellFormat = new DateFormat(convertedPattern);
            this.dateFormats.put(convertedPattern, cellFormat);
        }
        return cellFormat;
    }

    protected CellValue getLabelCell(int x, int y, String textStr, StyleInfo baseStyle) throws JRException {
        WritableCellFormat cellStyle = this.getLoadedCellStyle(baseStyle);
        return new Label(x, y, textStr, (CellFormat)cellStyle);
    }

    protected void addMergeRegion(JRExporterGridCell gridCell, int x, int y) throws JRException {
        boolean isCollapseRowSpan = ((JxlReportConfiguration)this.getCurrentItemConfiguration()).isCollapseRowSpan();
        if (gridCell.getColSpan() > 1 || gridCell.getRowSpan() > 1 && !isCollapseRowSpan) {
            try {
                if (isCollapseRowSpan) {
                    this.sheet.mergeCells(x, y, x + gridCell.getColSpan() - 1, y);
                } else {
                    this.sheet.mergeCells(x, y, x + gridCell.getColSpan() - 1, y + gridCell.getRowSpan() - 1);
                }
            }
            catch (JXLException e) {
                throw new JRException("export.xls.common.cannot.merge.cells", null, e);
            }
        }
    }

    private int getHorizontalAlignment(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.horizontalAlignment) {
            case RIGHT: {
                return Alignment.RIGHT.getValue();
            }
            case CENTER: {
                return Alignment.CENTRE.getValue();
            }
            case JUSTIFIED: {
                return Alignment.JUSTIFY.getValue();
            }
        }
        return Alignment.LEFT.getValue();
    }

    private int getVerticalAlignment(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.verticalAlignment) {
            case BOTTOM: {
                return VerticalAlignment.BOTTOM.getValue();
            }
            case MIDDLE: {
                return VerticalAlignment.CENTRE.getValue();
            }
            case JUSTIFIED: {
                return VerticalAlignment.JUSTIFY.getValue();
            }
        }
        return VerticalAlignment.TOP.getValue();
    }

    private int getRotation(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.rotation) {
            case LEFT: {
                return Orientation.PLUS_90.getValue();
            }
            case RIGHT: {
                return Orientation.MINUS_90.getValue();
            }
        }
        return Orientation.HORIZONTAL.getValue();
    }

    @Override
    public void exportImage(JRPrintImage element, JRExporterGridCell gridCell, int col, int row, int emptyCols, int yCutsRow, JRGridLayout layout) throws JRException {
        this.addMergeRegion(gridCell, col, row);
        int topPadding = Math.max(element.getLineBox().getTopPadding(), this.getImageBorderCorrection(element.getLineBox().getTopPen()));
        int leftPadding = Math.max(element.getLineBox().getLeftPadding(), this.getImageBorderCorrection(element.getLineBox().getLeftPen()));
        int bottomPadding = Math.max(element.getLineBox().getBottomPadding(), this.getImageBorderCorrection(element.getLineBox().getBottomPen()));
        int rightPadding = Math.max(element.getLineBox().getRightPadding(), this.getImageBorderCorrection(element.getLineBox().getRightPen()));
        int availableImageWidth = element.getWidth() - leftPadding - rightPadding;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = element.getHeight() - topPadding - bottomPadding;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        Renderable renderer = element.getRenderable();
        if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
            if (renderer.getTypeValue() == RenderableTypeEnum.IMAGE) {
                renderer = RenderableUtil.getInstance(this.jasperReportsContext).getOnErrorRendererForImageData(renderer, element.getOnErrorTypeValue());
                if (renderer != null) {
                    renderer = RenderableUtil.getInstance(this.jasperReportsContext).getOnErrorRendererForDimension(renderer, element.getOnErrorTypeValue());
                }
            } else {
                renderer = new JRWrappingSvgRenderer(renderer, (Dimension2D)new Dimension(element.getWidth(), element.getHeight()), ModeEnum.OPAQUE == element.getModeValue() ? element.getBackcolor() : null);
            }
        } else {
            renderer = null;
        }
        if (renderer != null) {
            java.lang.Boolean ignoreHyperlink;
            int normalWidth = availableImageWidth;
            int normalHeight = availableImageHeight;
            Dimension2D dimension = renderer.getDimension(this.jasperReportsContext);
            if (dimension != null) {
                normalWidth = (int)dimension.getWidth();
                normalHeight = (int)dimension.getHeight();
            }
            float xalignFactor = 0.0f;
            switch (element.getHorizontalImageAlign()) {
                case RIGHT: {
                    xalignFactor = 1.0f;
                    break;
                }
                case CENTER: {
                    xalignFactor = 0.5f;
                    break;
                }
                default: {
                    xalignFactor = 0.0f;
                }
            }
            float yalignFactor = 0.0f;
            switch (element.getVerticalImageAlign()) {
                case BOTTOM: {
                    yalignFactor = 1.0f;
                    break;
                }
                case MIDDLE: {
                    yalignFactor = 0.5f;
                    break;
                }
                default: {
                    yalignFactor = 0.0f;
                }
            }
            byte[] imageData = null;
            int topOffset = 0;
            int leftOffset = 0;
            int bottomOffset = 0;
            int rightOffset = 0;
            switch (element.getScaleImageValue()) {
                case CLIP: {
                    int dpi = this.getPropertiesUtil().getIntegerProperty("net.sf.jasperreports.image.dpi", 72);
                    double scale = (double)dpi / 72.0;
                    BufferedImage bi = new BufferedImage((int)(scale * (double)availableImageWidth), (int)(scale * (double)availableImageHeight), 2);
                    Graphics2D grx = bi.createGraphics();
                    grx.scale(scale, scale);
                    grx.clip(new Rectangle(0, 0, availableImageWidth, availableImageHeight));
                    renderer.render(this.jasperReportsContext, grx, new Rectangle((int)(xalignFactor * (float)(availableImageWidth - normalWidth)), (int)(yalignFactor * (float)(availableImageHeight - normalHeight)), normalWidth, normalHeight));
                    topOffset = topPadding;
                    leftOffset = leftPadding;
                    bottomOffset = bottomPadding;
                    rightOffset = rightPadding;
                    imageData = JRImageLoader.getInstance(this.jasperReportsContext).loadBytesFromAwtImage((Image)bi, ImageTypeEnum.PNG);
                    break;
                }
                case FILL_FRAME: {
                    topOffset = topPadding;
                    leftOffset = leftPadding;
                    bottomOffset = bottomPadding;
                    rightOffset = rightPadding;
                    imageData = renderer.getImageData(this.jasperReportsContext);
                    break;
                }
                default: {
                    if (element.getHeight() <= 0) break;
                    double ratio = (double)normalWidth / (double)normalHeight;
                    if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                        normalWidth = availableImageWidth;
                        normalHeight = (int)((double)availableImageWidth / ratio);
                    } else {
                        normalWidth = (int)((double)availableImageHeight * ratio);
                        normalHeight = availableImageHeight;
                    }
                    topOffset = topPadding + (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                    leftOffset = leftPadding + (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                    bottomOffset = bottomPadding + (int)((1.0f - yalignFactor) * (float)(availableImageHeight - normalHeight));
                    rightOffset = rightPadding + (int)((1.0f - xalignFactor) * (float)(availableImageWidth - normalWidth));
                    imageData = renderer.getImageData(this.jasperReportsContext);
                }
            }
            Pattern mode = this.backgroundMode;
            Colour background = WHITE;
            JxlReportConfiguration configuration = (JxlReportConfiguration)this.getCurrentItemConfiguration();
            if (!configuration.isIgnoreCellBackground().booleanValue() && gridCell.getCellBackcolor() != null) {
                mode = Pattern.SOLID;
                background = this.getWorkbookColour(gridCell.getCellBackcolor(), true);
            }
            if (element.getModeValue() == ModeEnum.OPAQUE) {
                background = this.getWorkbookColour(element.getBackcolor(), true);
            }
            Colour forecolor = this.getWorkbookColour(element.getLineBox().getPen().getLineColor());
            WritableFont cellFont2 = this.getLoadedFont(this.getDefaultFont(), forecolor.getValue(), this.getLocale());
            WritableCellFormat cellStyle2 = this.getLoadedCellStyle(mode, background, cellFont2, gridCell, this.isWrapText(element), this.isCellLocked(element), this.isShrinkToFit(element));
            if (!configuration.isIgnoreAnchors().booleanValue() && element.getAnchorName() != null) {
                int lastCol = Math.max(0, col + gridCell.getColSpan() - 1);
                int lastRow = Math.max(0, row + gridCell.getRowSpan() - 1);
                this.workbook.addNameArea(element.getAnchorName(), this.sheet, col, row, lastCol, lastRow);
            }
            if ((ignoreHyperlink = HyperlinkUtil.getIgnoreHyperlink("net.sf.jasperreports.export.xls.ignore.hyperlink", element)) == null) {
                ignoreHyperlink = configuration.isIgnoreHyperlink();
            }
            if (!ignoreHyperlink.booleanValue()) {
                this.exportHyperlink(element, "", gridCell, col, row);
            }
            try {
                this.sheet.addCell((WritableCell)new Blank(col, row, (CellFormat)cellStyle2));
                double leftPos = this.getColumnRelativePosition(layout, col, leftOffset);
                double topPos = this.getRowRelativePosition(layout, yCutsRow, topOffset);
                double rightPos = this.getColumnRelativePosition(layout, col, element.getWidth() - rightOffset);
                double bottomPos = this.getRowRelativePosition(layout, yCutsRow, element.getHeight() - bottomOffset);
                WritableImage image = new WritableImage((double)col + leftPos, (double)row + topPos, rightPos - leftPos, bottomPos - topPos, imageData);
                ImageAnchorTypeEnum imageAnchorType = ImageAnchorTypeEnum.getByName(JRPropertiesUtil.getOwnProperty(element, "net.sf.jasperreports.export.xls.image.anchor.type"));
                if (imageAnchorType == null && (imageAnchorType = configuration.getImageAnchorType()) == null) {
                    imageAnchorType = ImageAnchorTypeEnum.MOVE_NO_SIZE;
                }
                this.setAnchorType(image, imageAnchorType);
                this.sheet.addImage(image);
            }
            catch (Exception ex) {
                throw new JRException("export.xls.common.cannot.add.cell", null, ex);
            }
            catch (Error err) {
                throw new JRException("export.xls.common.cannot.add.cell", null, err);
            }
        }
    }

    protected double getColumnRelativePosition(JRGridLayout layout, int col, int offset) {
        int colWidth;
        double colRelPos = 0.0;
        int colIndex = 0;
        for (int cumulativeColWidth = 0; cumulativeColWidth < offset; cumulativeColWidth += colWidth) {
            colWidth = this.sheet.getColumnView(col + colIndex).getSize() / 43;
            if (cumulativeColWidth + colWidth < offset) {
                ++colIndex;
                continue;
            }
            colRelPos += (double)colIndex + (double)(offset - cumulativeColWidth) / (double)colWidth;
        }
        return colRelPos;
    }

    protected double getRowRelativePosition(JRGridLayout layout, int row, int offset) {
        int rowHeight;
        boolean isCollapseRowSpan = ((JxlReportConfiguration)this.getCurrentItemConfiguration()).isCollapseRowSpan();
        double rowRelPos = 0.0;
        int rowIndex = 0;
        for (int cumulativeRowHeight = 0; cumulativeRowHeight < offset; cumulativeRowHeight += rowHeight) {
            int n = rowHeight = isCollapseRowSpan ? layout.getMaxRowHeight(row + rowIndex) : layout.getRowHeight(row + rowIndex);
            if (cumulativeRowHeight + rowHeight < offset) {
                ++rowIndex;
                continue;
            }
            rowRelPos += (double)rowIndex + (double)(offset - cumulativeRowHeight) / (double)rowHeight;
        }
        return rowRelPos;
    }

    protected Colour getWorkbookColour(Color awtColor, boolean isBackcolor) {
        if (isBackcolor && awtColor.getRGB() == Color.black.getRGB()) {
            return Colour.PALETTE_BLACK;
        }
        return this.getWorkbookColour(awtColor);
    }

    protected Colour getWorkbookColour(Color awtColor) {
        Colour colour;
        JxlExporterConfiguration configuration = (JxlExporterConfiguration)this.getCurrentConfiguration();
        if (configuration.isCreateCustomPalette().booleanValue()) {
            colour = this.workbookColours.get(awtColor);
            if (colour == null) {
                colour = this.determineWorkbookColour(awtColor);
                this.workbookColours.put(awtColor, colour);
            }
        } else {
            colour = JExcelApiExporter.getNearestColour(awtColor);
        }
        return colour;
    }

    protected Colour determineWorkbookColour(Color awtColor) {
        Colour workbookColour;
        int minDist = 999;
        Colour minColour = null;
        int minDistAvailable = 999;
        Colour minColourAvailable = null;
        Colour[] colors = Colour.getAllColours();
        for (int i = 0; i < colors.length; ++i) {
            Colour colour = colors[i];
            RGB customRGB = this.usedColours.get(colour);
            RGB rgb = customRGB == null ? colour.getDefaultRGB() : customRGB;
            int dist = JExcelApiExporter.rgbDistance(awtColor, rgb);
            if (dist < minDist) {
                minDist = dist;
                minColour = colour;
            }
            if (dist == 0) break;
            if (customRGB != null || dist >= minDistAvailable) continue;
            minDistAvailable = dist;
            minColourAvailable = colour;
        }
        if (minDist == 0) {
            if (!this.usedColours.containsKey(minColour)) {
                this.setColourUsed(minColour);
            }
            workbookColour = minColour;
        } else if (minColourAvailable == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("No more available colours in the palette.  Using the nearest match for " + awtColor));
            }
            workbookColour = minColour;
        } else {
            this.setColourUsed(minColourAvailable, awtColor);
            workbookColour = minColourAvailable;
        }
        return workbookColour;
    }

    protected static Colour getNearestColour(Color awtColor) {
        Colour color = colorsCache.get(awtColor);
        if (color == null) {
            Colour[] colors = Colour.getAllColours();
            if (colors != null && colors.length > 0) {
                int minDiff = 999;
                for (int i = 0; i < colors.length; ++i) {
                    Colour crtColor = colors[i];
                    int diff = JExcelApiExporter.rgbDistance(awtColor, crtColor.getDefaultRGB());
                    if (diff >= minDiff) continue;
                    minDiff = diff;
                    color = crtColor;
                }
            }
            colorsCache.put(awtColor, color);
        }
        return color;
    }

    protected static int rgbDistance(Color awtColor, RGB rgb) {
        return Math.abs(rgb.getRed() - awtColor.getRed()) + Math.abs(rgb.getGreen() - awtColor.getGreen()) + Math.abs(rgb.getBlue() - awtColor.getBlue());
    }

    private WritableFont getLoadedFont(JRFont font, int forecolor, Locale locale) throws JRException {
        boolean isFontSizeFixEnabled = ((JxlReportConfiguration)this.getCurrentItemConfiguration()).isFontSizeFixEnabled();
        WritableFont cellFont = null;
        if (this.loadedFonts != null && this.loadedFonts.size() > 0) {
            for (int i = 0; i < this.loadedFonts.size(); ++i) {
                FontFamily family;
                String exportFont;
                WritableFont cf = (WritableFont)this.loadedFonts.get(i);
                int fontSize = (int)font.getFontsize();
                if (isFontSizeFixEnabled) {
                    --fontSize;
                }
                String fontName = font.getFontName();
                FontInfo fontInfo = FontUtil.getInstance(this.jasperReportsContext).getFontInfo(fontName, locale);
                if (fontInfo != null && (exportFont = (family = fontInfo.getFontFamily()).getExportFont(this.getExporterKey())) != null) {
                    fontName = exportFont;
                }
                if (!cf.getName().equals(fontName) || cf.getColour().getValue() != forecolor || cf.getPointSize() != fontSize || !(cf.getUnderlineStyle() == UnderlineStyle.SINGLE ? font.isUnderline() : !font.isUnderline()) || cf.isStruckout() != font.isStrikeThrough() || !(cf.getBoldWeight() == BoldStyle.BOLD.getValue() ? font.isBold() : !font.isBold()) || cf.isItalic() != font.isItalic()) continue;
                cellFont = cf;
                break;
            }
        }
        try {
            if (cellFont == null) {
                int fontSize = (int)font.getFontsize();
                if (isFontSizeFixEnabled) {
                    --fontSize;
                }
                String fontName = font.getFontName();
                cellFont = new WritableFont(WritableFont.createFont((String)fontName), fontSize, font.isBold() ? WritableFont.BOLD : WritableFont.NO_BOLD, font.isItalic(), font.isUnderline() ? UnderlineStyle.SINGLE : UnderlineStyle.NO_UNDERLINE, Colour.getInternalColour((int)forecolor));
                cellFont.setStruckout(font.isStrikeThrough());
                this.loadedFonts.add(cellFont);
            }
        }
        catch (Exception e) {
            throw new JRException("export.xls.common.loaded.fonts.error", null, e);
        }
        return cellFont;
    }

    private WritableCellFormat getLoadedCellStyle(Pattern mode, Colour backcolor, WritableFont font, JRExporterGridCell gridCell, boolean wrapText, boolean cellLocked, boolean shrinkToFit) throws JRException {
        StyleInfo styleKey = new StyleInfo(mode, backcolor, Alignment.LEFT.getValue(), VerticalAlignment.TOP.getValue(), Orientation.HORIZONTAL.getValue(), font, gridCell, wrapText, cellLocked, shrinkToFit);
        return this.getLoadedCellStyle(styleKey);
    }

    private WritableCellFormat getLoadedCellStyle(Pattern mode, Colour backcolor, WritableFont font, BoxStyle box, boolean wrapText, boolean cellLocked, boolean shrinkToFit) throws JRException {
        StyleInfo styleKey = new StyleInfo(mode, backcolor, Alignment.LEFT.getValue(), VerticalAlignment.TOP.getValue(), Orientation.HORIZONTAL.getValue(), font, box, wrapText, cellLocked, shrinkToFit);
        return this.getLoadedCellStyle(styleKey);
    }

    protected WritableCellFormat getLoadedCellStyle(StyleInfo styleKey) throws JRException {
        WritableCellFormat cellStyle = this.loadedCellStyles.get(styleKey);
        if (cellStyle == null) {
            try {
                cellStyle = styleKey.font == null ? new WritableCellFormat() : (styleKey.getDisplayFormat() == null ? new WritableCellFormat(styleKey.font) : new WritableCellFormat(styleKey.font, styleKey.getDisplayFormat()));
                cellStyle.setBackground(styleKey.backcolor, styleKey.mode);
                cellStyle.setAlignment(Alignment.getAlignment((int)styleKey.horizontalAlignment));
                cellStyle.setVerticalAlignment(VerticalAlignment.getAlignment((int)styleKey.verticalAlignment));
                cellStyle.setOrientation(Orientation.getOrientation((int)styleKey.rotation));
                cellStyle.setWrap(styleKey.isWrapText);
                cellStyle.setLocked(styleKey.isCellLocked);
                cellStyle.setShrinkToFit(styleKey.isShrinkToFit);
                JxlReportConfiguration configuration = (JxlReportConfiguration)this.getCurrentItemConfiguration();
                if (!configuration.isIgnoreCellBorder().booleanValue() && styleKey.box != null) {
                    BoxStyle box = styleKey.box;
                    cellStyle.setBorder(Border.TOP, box.borderStyle[0], box.borderColour[0]);
                    cellStyle.setBorder(Border.BOTTOM, box.borderStyle[2], box.borderColour[2]);
                    cellStyle.setBorder(Border.LEFT, box.borderStyle[1], box.borderColour[1]);
                    cellStyle.setBorder(Border.RIGHT, box.borderStyle[3], box.borderColour[3]);
                }
            }
            catch (Exception e) {
                throw new JRException("export.xls.common.cell.format.template.error", null, e);
            }
            this.loadedCellStyles.put(styleKey, cellStyle);
        }
        return cellStyle;
    }

    protected static BorderLineStyle getBorderLineStyle(JRPen pen) {
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth > 0.0f) {
            switch (pen.getLineStyleValue()) {
                case DOUBLE: {
                    return BorderLineStyle.DOUBLE;
                }
                case DOTTED: {
                    return BorderLineStyle.DOTTED;
                }
                case DASHED: {
                    if (lineWidth >= 1.0f) {
                        return BorderLineStyle.MEDIUM_DASHED;
                    }
                    return BorderLineStyle.DASHED;
                }
            }
            if (lineWidth >= 2.0f) {
                return BorderLineStyle.THICK;
            }
            if (lineWidth >= 1.0f) {
                return BorderLineStyle.MEDIUM;
            }
            if (lineWidth >= 0.5f) {
                return BorderLineStyle.THIN;
            }
            return BorderLineStyle.HAIR;
        }
        return BorderLineStyle.NONE;
    }

    private final void setSheetSettings(JRXlsAbstractExporter.SheetInfo sheetInfo, WritableSheet sheet) {
        String sheetFooterRight;
        String sheetFooterCenter;
        String sheetFooterLeft;
        String sheetHeaderRight;
        String sheetHeaderCenter;
        String sheetHeaderLeft;
        PageOrientation po = this.pageFormat.getOrientation() == OrientationEnum.PORTRAIT ? PageOrientation.PORTRAIT : PageOrientation.LANDSCAPE;
        PaperSize ps = this.getSuitablePaperSize();
        if (ps != null) {
            sheet.setPageSetup(po, ps, 0.0, 0.0);
        } else {
            sheet.setPageSetup(po);
        }
        SheetSettings sheets = sheet.getSettings();
        JxlReportConfiguration configuration = (JxlReportConfiguration)this.getCurrentItemConfiguration();
        sheets.setTopMargin(0.0);
        sheets.setLeftMargin(0.0);
        sheets.setRightMargin(0.0);
        sheets.setBottomMargin(0.0);
        sheets.setHeaderMargin(0.0);
        sheets.setFooterMargin(0.0);
        String password = configuration.getPassword();
        if (password != null) {
            sheets.setPassword(password);
            sheets.setProtected(true);
        }
        if ((sheetHeaderLeft = configuration.getSheetHeaderLeft()) != null) {
            sheets.getHeader().getLeft().append(sheetHeaderLeft);
        }
        if ((sheetHeaderCenter = configuration.getSheetHeaderCenter()) != null) {
            sheets.getHeader().getCentre().append(sheetHeaderCenter);
        }
        if ((sheetHeaderRight = configuration.getSheetHeaderRight()) != null) {
            sheets.getHeader().getRight().append(sheetHeaderRight);
        }
        if ((sheetFooterLeft = configuration.getSheetFooterLeft()) != null) {
            sheets.getFooter().getLeft().append(sheetFooterLeft);
        }
        if ((sheetFooterCenter = configuration.getSheetFooterCenter()) != null) {
            sheets.getFooter().getCentre().append(sheetFooterCenter);
        }
        if ((sheetFooterRight = configuration.getSheetFooterRight()) != null) {
            sheets.getFooter().getRight().append(sheetFooterRight);
        }
        if (sheetInfo.sheetFirstPageNumber != null && sheetInfo.sheetFirstPageNumber > 0) {
            sheets.setPageStart(sheetInfo.sheetFirstPageNumber.intValue());
            this.firstPageNotSet = false;
        } else {
            Integer documentFirstPageNumber = configuration.getFirstPageNumber();
            if (documentFirstPageNumber != null && documentFirstPageNumber > 0 && this.firstPageNotSet) {
                sheets.setPageStart(documentFirstPageNumber.intValue());
                this.firstPageNotSet = false;
            }
        }
        if (!this.firstPageNotSet && sheets.getFooter().getCentre().empty()) {
            sheets.getFooter().getCentre().append("Page ");
            sheets.getFooter().getCentre().appendPageNumber();
        }
        boolean showGridlines = true;
        if (sheetInfo.sheetShowGridlines == null) {
            java.lang.Boolean documentShowGridlines = configuration.isShowGridLines();
            if (documentShowGridlines != null) {
                showGridlines = documentShowGridlines;
            }
        } else {
            showGridlines = sheetInfo.sheetShowGridlines;
        }
        sheets.setShowGridLines(showGridlines);
        this.maxRowFreezeIndex = 0;
        this.maxColumnFreezeIndex = 0;
        this.onePagePerSheetMap.put(this.sheetIndex, configuration.isOnePagePerSheet());
        this.sheetsBeforeCurrentReportMap.put(this.sheetIndex, this.sheetsBeforeCurrentReport);
    }

    private final PaperSize getSuitablePaperSize() {
        if (this.pageFormat == null) {
            return null;
        }
        long width = 0L;
        long height = 0L;
        PaperSize ps = null;
        if (this.pageFormat.getPageWidth() != 0 && this.pageFormat.getPageHeight() != 0) {
            double dWidth = (double)this.pageFormat.getPageWidth().intValue() / 72.0;
            double dHeight = (double)this.pageFormat.getPageHeight().intValue() / 72.0;
            height = Math.round(dHeight * 25.4);
            width = Math.round(dWidth * 25.4);
            for (int i = 3; i < 6; ++i) {
                int w = this.calculateWidthForDinAN(i);
                int h = this.calculateHeightForDinAN(i);
                if (((long)w != width || (long)h != height) && ((long)h != width || (long)w != height)) continue;
                if (i == 3) {
                    ps = PaperSize.A3;
                    break;
                }
                if (i == 4) {
                    ps = PaperSize.A4;
                    break;
                }
                if (i != 5) break;
                ps = PaperSize.A5;
                break;
            }
            if (ps == null) {
                if (width == 216L && height == 279L || width == 279L && height == 216L) {
                    ps = PaperSize.LETTER;
                }
                if (width == 216L && height == 356L || width == 356L && height == 216L) {
                    ps = PaperSize.LEGAL;
                }
            }
        }
        return ps;
    }

    public static JRXlsAbstractExporter.TextAlignHolder getTextAlignHolder(JRPrintText textElement) {
        HorizontalTextAlignEnum horizontalAlignment;
        VerticalTextAlignEnum verticalAlignment;
        RotationEnum rotation = textElement.getRotationValue();
        block0 : switch (textElement.getRotationValue()) {
            case LEFT: {
                switch (textElement.getHorizontalTextAlign()) {
                    case RIGHT: {
                        verticalAlignment = VerticalTextAlignEnum.TOP;
                        break;
                    }
                    case CENTER: {
                        verticalAlignment = VerticalTextAlignEnum.MIDDLE;
                        break;
                    }
                    default: {
                        verticalAlignment = VerticalTextAlignEnum.BOTTOM;
                    }
                }
                switch (textElement.getVerticalTextAlign()) {
                    case BOTTOM: {
                        horizontalAlignment = HorizontalTextAlignEnum.RIGHT;
                        break block0;
                    }
                    case MIDDLE: {
                        horizontalAlignment = HorizontalTextAlignEnum.CENTER;
                        break block0;
                    }
                }
                horizontalAlignment = HorizontalTextAlignEnum.LEFT;
                break;
            }
            case RIGHT: {
                switch (textElement.getHorizontalTextAlign()) {
                    case RIGHT: {
                        verticalAlignment = VerticalTextAlignEnum.BOTTOM;
                        break;
                    }
                    case CENTER: {
                        verticalAlignment = VerticalTextAlignEnum.MIDDLE;
                        break;
                    }
                    default: {
                        verticalAlignment = VerticalTextAlignEnum.TOP;
                    }
                }
                switch (textElement.getVerticalTextAlign()) {
                    case TOP: {
                        horizontalAlignment = HorizontalTextAlignEnum.RIGHT;
                        break block0;
                    }
                    case MIDDLE: {
                        horizontalAlignment = HorizontalTextAlignEnum.CENTER;
                        break block0;
                    }
                    case BOTTOM: {
                        horizontalAlignment = HorizontalTextAlignEnum.LEFT;
                        break block0;
                    }
                }
                horizontalAlignment = HorizontalTextAlignEnum.RIGHT;
                break;
            }
            default: {
                horizontalAlignment = textElement.getHorizontalTextAlign();
                verticalAlignment = textElement.getVerticalTextAlign();
            }
        }
        return new JRXlsAbstractExporter.TextAlignHolder(horizontalAlignment, verticalAlignment, rotation);
    }

    @Override
    protected void exportFrame(JRPrintFrame frame, JRExporterGridCell gridCell, int col, int row) throws JRException {
        this.addMergeRegion(gridCell, col, row);
        Colour forecolor = this.getWorkbookColour(frame.getForecolor());
        Colour backcolor = WHITE;
        Pattern mode = this.backgroundMode;
        if (frame.getModeValue() == ModeEnum.OPAQUE) {
            mode = Pattern.SOLID;
            backcolor = this.getWorkbookColour(frame.getBackcolor(), true);
        }
        WritableFont cellFont = this.getLoadedFont(this.getDefaultFont(), forecolor.getValue(), this.getLocale());
        WritableCellFormat cellStyle = this.getLoadedCellStyle(mode, backcolor, cellFont, gridCell, true, this.isCellLocked(frame), this.isShrinkToFit(frame));
        Blank cell = new Blank(col, row, (CellFormat)cellStyle);
        try {
            this.sheet.addCell((WritableCell)cell);
        }
        catch (JXLException e) {
            throw new JRException("export.xls.common.cannot.add.cell", null, e);
        }
    }

    @Override
    protected void exportGenericElement(JRGenericPrintElement element, JRExporterGridCell gridCell, int colIndex, int rowIndex, int emptyCols, int yCutsRow, JRGridLayout layout) throws JRException {
        GenericElementJExcelApiHandler handler = (GenericElementJExcelApiHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(element.getGenericType(), JXL_EXPORTER_KEY);
        if (handler != null) {
            handler.exportElement((JExcelApiExporterContext)this.exporterContext, element, gridCell, colIndex, rowIndex, emptyCols, yCutsRow, layout);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No XLS generic element handler for " + element.getGenericType()));
        }
    }

    @Override
    protected Integer getMaxRowsPerSheet() {
        Integer maxRowsPerSheet = super.getMaxRowsPerSheet();
        return maxRowsPerSheet == null || maxRowsPerSheet == 0 || maxRowsPerSheet > 65536 ? 65536 : maxRowsPerSheet;
    }

    @Override
    public String getExporterKey() {
        return JXL_EXPORTER_KEY;
    }

    @Override
    public String getExporterPropertiesPrefix() {
        return "net.sf.jasperreports.export.xls.";
    }

    protected boolean isComplexFormat(JRPrintElement element) {
        if (element.hasProperties() && element.getPropertiesMap().containsProperty(PROPERTY_COMPLEX_FORMAT)) {
            return this.getPropertiesUtil().getBooleanProperty(element, PROPERTY_COMPLEX_FORMAT, (boolean)((JxlReportConfiguration)this.getCurrentItemConfiguration()).isComplexFormat());
        }
        return ((JxlReportConfiguration)this.getCurrentItemConfiguration()).isComplexFormat();
    }

    @Override
    protected void setFreezePane(int rowIndex, int colIndex, boolean isRowEdge, boolean isColumnEdge) {
        int maxRowIndex;
        int n = this.isFreezeRowEdge ? Math.max(rowIndex, this.maxRowFreezeIndex) : (maxRowIndex = isRowEdge ? rowIndex : Math.max(rowIndex, this.maxRowFreezeIndex));
        int maxColIndex = this.isFreezeColumnEdge ? Math.max(colIndex, this.maxColumnFreezeIndex) : (isColumnEdge ? colIndex : Math.max(colIndex, this.maxColumnFreezeIndex));
        SheetSettings settings = this.sheet.getSettings();
        settings.setVerticalFreeze(maxRowIndex);
        settings.setHorizontalFreeze(maxColIndex);
        this.maxRowFreezeIndex = maxRowIndex;
        this.maxColumnFreezeIndex = maxColIndex;
        this.isFreezeRowEdge = isRowEdge;
        this.isFreezeColumnEdge = isColumnEdge;
    }

    @Override
    protected void setSheetName(String sheetName) {
        this.sheet.setName(sheetName);
    }

    @Override
    protected void setAutoFilter(String autoFilterRange) {
    }

    @Override
    protected void setRowLevels(XlsRowLevelInfo levelInfo, String level) {
        SortedMap<String, Integer> levelMap = levelInfo.getLevelMap();
        try {
            if (levelMap != null && levelMap.size() > 0) {
                for (String l : levelMap.keySet()) {
                    if (level != null && l.compareTo(level) < 0) continue;
                    Integer startIndex = (Integer)levelMap.get(l);
                    if (levelInfo.getEndIndex() < startIndex) continue;
                    this.sheet.setRowGroup(startIndex.intValue(), levelInfo.getEndIndex().intValue(), false);
                }
            }
        }
        catch (RowsExceededException e) {
            throw new JRRuntimeException(e);
        }
        catch (WriteException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected void setAnchorType(WritableImage image, ImageAnchorTypeEnum anchorType) {
        switch (anchorType) {
            case MOVE_SIZE: {
                image.setImageAnchor(WritableImage.MOVE_AND_SIZE_WITH_CELLS);
                break;
            }
            case NO_MOVE_NO_SIZE: {
                image.setImageAnchor(WritableImage.NO_MOVE_OR_SIZE_WITH_CELLS);
                break;
            }
            default: {
                image.setImageAnchor(WritableImage.MOVE_WITH_CELLS);
            }
        }
    }

    protected class StyleInfo {
        protected final Pattern mode;
        protected final Colour backcolor;
        protected final int horizontalAlignment;
        protected final int verticalAlignment;
        protected final int rotation;
        protected final WritableFont font;
        protected final BoxStyle box;
        protected final boolean isWrapText;
        protected final boolean isCellLocked;
        protected final boolean isShrinkToFit;
        private DisplayFormat displayFormat;
        private int hashCode;

        protected StyleInfo(Pattern mode, Colour backcolor, int horizontalAlignment, int verticalAlignment, int rotation, WritableFont font, JRExporterGridCell gridCell, boolean wrapText, boolean cellLocked, boolean shrinkToFit) {
            this(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, jExcelApiExporter.new BoxStyle(gridCell), wrapText, cellLocked, shrinkToFit);
        }

        protected StyleInfo(Pattern mode, Colour backcolor, int horizontalAlignment, int verticalAlignment, int rotation, WritableFont font, BoxStyle box, boolean wrapText, boolean cellLocked, boolean shrinkToFit) {
            this.mode = mode;
            this.backcolor = backcolor;
            this.horizontalAlignment = horizontalAlignment;
            this.verticalAlignment = verticalAlignment;
            this.rotation = rotation;
            this.font = font;
            this.box = box;
            this.isWrapText = shrinkToFit ? false : wrapText;
            this.isCellLocked = cellLocked;
            this.isShrinkToFit = shrinkToFit;
            this.computeHash();
        }

        protected void computeHash() {
            int hash = this.mode.hashCode();
            hash = 31 * hash + this.backcolor.hashCode();
            hash = 31 * hash + this.horizontalAlignment;
            hash = 31 * hash + this.verticalAlignment;
            hash = 31 * hash + this.rotation;
            hash = 31 * hash + (this.font == null ? 0 : this.font.hashCode());
            hash = 31 * hash + (this.box == null ? 0 : this.box.hashCode());
            hash = 31 * hash + (this.displayFormat == null ? 0 : this.displayFormat.hashCode());
            hash = 31 * hash + (this.isWrapText ? 0 : 1);
            hash = 31 * hash + (this.isCellLocked ? 0 : 1);
            this.hashCode = hash = 31 * hash + (this.isShrinkToFit ? 0 : 1);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            StyleInfo k = (StyleInfo)o;
            return k.mode.equals(this.mode) && k.backcolor.equals(this.backcolor) && k.horizontalAlignment == this.horizontalAlignment && k.verticalAlignment == this.verticalAlignment && k.rotation == this.rotation && (k.font == null ? this.font == null : k.font.equals((Object)this.font)) && (k.box == null ? this.box == null : this.box != null && k.box.equals(this.box)) && (k.displayFormat == null ? this.displayFormat == null : this.displayFormat != null && k.displayFormat.equals(this.displayFormat) && k.isWrapText == this.isWrapText && k.isCellLocked == this.isCellLocked && k.isShrinkToFit == this.isShrinkToFit);
        }

        public DisplayFormat getDisplayFormat() {
            return this.displayFormat;
        }

        public void setDisplayFormat(DisplayFormat displayFormat) {
            this.displayFormat = displayFormat;
            this.computeHash();
        }

        public String toString() {
            return "(" + this.mode + "," + this.backcolor + "," + this.horizontalAlignment + "," + this.verticalAlignment + "," + this.rotation + "," + this.font + "," + this.box + "," + this.displayFormat + "," + this.isWrapText + "," + this.isCellLocked + "," + this.isShrinkToFit + ")";
        }
    }

    protected class BoxStyle {
        protected static final int TOP = 0;
        protected static final int LEFT = 1;
        protected static final int BOTTOM = 2;
        protected static final int RIGHT = 3;
        protected BorderLineStyle[] borderStyle = new BorderLineStyle[]{BorderLineStyle.NONE, BorderLineStyle.NONE, BorderLineStyle.NONE, BorderLineStyle.NONE};
        protected Colour[] borderColour = new Colour[]{BLACK, BLACK, BLACK, BLACK};
        private int hash;

        public BoxStyle(int side, JRPen pen) {
            this.borderStyle[side] = JExcelApiExporter.getBorderLineStyle(pen);
            this.borderColour[side] = JExcelApiExporter.this.getWorkbookColour(pen.getLineColor());
            this.hash = this.computeHash();
        }

        public BoxStyle(JRExporterGridCell gridCell) {
            if (gridCell != null) {
                JRPrintElement element;
                JRLineBox lineBox = gridCell.getBox();
                if (lineBox != null) {
                    this.setBox(lineBox);
                }
                if ((element = gridCell.getElement()) instanceof JRCommonGraphicElement) {
                    this.setPen(((JRCommonGraphicElement)((Object)element)).getLinePen());
                }
                this.hash = this.computeHash();
            }
        }

        public void setBox(JRLineBox box) {
            this.borderStyle[0] = JExcelApiExporter.getBorderLineStyle(box.getTopPen());
            this.borderColour[0] = JExcelApiExporter.this.getWorkbookColour(box.getTopPen().getLineColor());
            this.borderStyle[2] = JExcelApiExporter.getBorderLineStyle(box.getBottomPen());
            this.borderColour[2] = JExcelApiExporter.this.getWorkbookColour(box.getBottomPen().getLineColor());
            this.borderStyle[1] = JExcelApiExporter.getBorderLineStyle(box.getLeftPen());
            this.borderColour[1] = JExcelApiExporter.this.getWorkbookColour(box.getLeftPen().getLineColor());
            this.borderStyle[3] = JExcelApiExporter.getBorderLineStyle(box.getRightPen());
            this.borderColour[3] = JExcelApiExporter.this.getWorkbookColour(box.getRightPen().getLineColor());
            this.hash = this.computeHash();
        }

        public void setPen(JRPen pen) {
            if (this.borderStyle[0] == BorderLineStyle.NONE && this.borderStyle[1] == BorderLineStyle.NONE && this.borderStyle[2] == BorderLineStyle.NONE && this.borderStyle[3] == BorderLineStyle.NONE) {
                BorderLineStyle style = JExcelApiExporter.getBorderLineStyle(pen);
                Colour colour = JExcelApiExporter.this.getWorkbookColour(pen.getLineColor());
                this.borderStyle[0] = style;
                this.borderStyle[1] = style;
                this.borderStyle[2] = style;
                this.borderStyle[3] = style;
                this.borderColour[0] = colour;
                this.borderColour[1] = colour;
                this.borderColour[2] = colour;
                this.borderColour[3] = colour;
            }
            this.hash = this.computeHash();
        }

        private int computeHash() {
            int hashCode = this.borderStyle[0].hashCode();
            hashCode = 31 * hashCode + this.borderColour[0].hashCode();
            hashCode = 31 * hashCode + this.borderStyle[2].hashCode();
            hashCode = 31 * hashCode + this.borderColour[2].hashCode();
            hashCode = 31 * hashCode + this.borderStyle[1].hashCode();
            hashCode = 31 * hashCode + this.borderColour[1].hashCode();
            hashCode = 31 * hashCode + this.borderStyle[3].hashCode();
            hashCode = 31 * hashCode + this.borderColour[3].hashCode();
            return hashCode;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            BoxStyle b = (BoxStyle)o;
            return b.borderStyle[0].equals(this.borderStyle[0]) && b.borderColour[0].equals(this.borderColour[0]) && b.borderStyle[1].equals(this.borderStyle[1]) && b.borderColour[1].equals(this.borderColour[1]) && b.borderStyle[2].equals(this.borderStyle[2]) && b.borderColour[2].equals(this.borderColour[2]) && b.borderStyle[3].equals(this.borderStyle[3]) && b.borderColour[3].equals(this.borderColour[3]);
        }

        public String toString() {
            return "(" + this.borderStyle[0].getValue() + "/" + this.borderColour[0].getValue() + "," + this.borderStyle[2].getValue() + "/" + this.borderColour[2].getValue() + "," + this.borderStyle[1].getValue() + "/" + this.borderColour[1].getValue() + "," + this.borderStyle[3].getValue() + "/" + this.borderColour[3].getValue() + ")";
        }
    }

    protected class CellTextValueHandler
    implements TextValueHandler {
        private final int x;
        private final int y;
        private final JRPrintText textElement;
        private final StyleInfo baseStyle;
        private final boolean cellComplexFormat;
        private CellValue result;

        public CellTextValueHandler(int x, int y, JRPrintText textElement, StyleInfo baseStyle, boolean cellComplexFormat) {
            this.x = x;
            this.y = y;
            this.textElement = textElement;
            this.baseStyle = baseStyle;
            this.cellComplexFormat = cellComplexFormat;
        }

        @Override
        public void handle(StringTextValue textValue) throws JRException {
            WritableCellFormat cellStyle = JExcelApiExporter.this.getLoadedCellStyle(this.baseStyle);
            this.result = new Label(this.x, this.y, textValue.getText(), (CellFormat)cellStyle);
        }

        @Override
        public void handle(NumberTextValue textValue) throws JRException {
            String convertedPattern = JExcelApiExporter.this.getConvertedPattern(this.textElement, textValue.getPattern());
            if (convertedPattern != null) {
                this.baseStyle.setDisplayFormat((DisplayFormat)JExcelApiExporter.this.getNumberFormat(convertedPattern, this.cellComplexFormat));
            }
            WritableCellFormat cellStyle = JExcelApiExporter.this.getLoadedCellStyle(this.baseStyle);
            this.result = textValue.getValue() == null ? this.blank(cellStyle) : new Number(this.x, this.y, textValue.getValue().doubleValue(), (CellFormat)cellStyle);
        }

        @Override
        public void handle(DateTextValue textValue) throws JRException {
            String convertedPattern = JExcelApiExporter.this.getConvertedPattern(this.textElement, textValue.getPattern());
            if (convertedPattern != null) {
                this.baseStyle.setDisplayFormat((DisplayFormat)JExcelApiExporter.this.getDateFormat(convertedPattern));
            }
            WritableCellFormat cellStyle = JExcelApiExporter.this.getLoadedCellStyle(this.baseStyle);
            Date date = textValue.getValue();
            if (date == null) {
                this.result = this.blank(cellStyle);
            } else {
                date = JExcelApiExporter.this.translateDateValue(this.textElement, date);
                this.result = new DateTime(this.x, this.y, date, (CellFormat)cellStyle);
            }
        }

        @Override
        public void handle(BooleanTextValue textValue) throws JRException {
            WritableCellFormat cellStyle = JExcelApiExporter.this.getLoadedCellStyle(this.baseStyle);
            this.result = textValue.getValue() == null ? this.blank(cellStyle) : new Boolean(this.x, this.y, textValue.getValue().booleanValue(), (CellFormat)cellStyle);
        }

        protected Blank blank(WritableCellFormat cellStyle) {
            return new Blank(this.x, this.y, (CellFormat)cellStyle);
        }

        public CellValue getResult() {
            return this.result;
        }

        public boolean isCellComplexFormat() {
            return this.cellComplexFormat;
        }
    }

    protected class FormulaTextValueHandler
    implements TextValueHandler {
        private final int x;
        private final int y;
        private final JRPrintText textElement;
        private final String formula;
        private final StyleInfo baseStyle;
        private final boolean cellComplexFormat;
        private CellValue result;

        public FormulaTextValueHandler(int x, int y, JRPrintText textElement, String formula, StyleInfo baseStyle, boolean cellComplexFormat) {
            this.x = x;
            this.y = y;
            this.textElement = textElement;
            this.formula = formula;
            this.baseStyle = baseStyle;
            this.cellComplexFormat = cellComplexFormat;
        }

        @Override
        public void handle(StringTextValue textValue) throws JRException {
            this.result = this.formula();
        }

        @Override
        public void handle(NumberTextValue textValue) throws JRException {
            String convertedPattern = JExcelApiExporter.this.getConvertedPattern(this.textElement, textValue.getPattern());
            if (convertedPattern != null) {
                this.baseStyle.setDisplayFormat((DisplayFormat)JExcelApiExporter.this.getNumberFormat(convertedPattern, this.cellComplexFormat));
            }
            this.result = this.formula();
        }

        @Override
        public void handle(DateTextValue textValue) throws JRException {
            String convertedPattern = JExcelApiExporter.this.getConvertedPattern(this.textElement, textValue.getPattern());
            if (convertedPattern != null) {
                this.baseStyle.setDisplayFormat((DisplayFormat)JExcelApiExporter.this.getDateFormat(convertedPattern));
            }
            this.result = this.formula();
        }

        @Override
        public void handle(BooleanTextValue textValue) throws JRException {
            this.result = this.formula();
        }

        protected Formula formula() throws JRException {
            try {
                return new Formula(this.x, this.y, this.formula, (CellFormat)JExcelApiExporter.this.getLoadedCellStyle(this.baseStyle));
            }
            catch (Exception e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
                return null;
            }
        }

        public CellValue getResult() {
            return this.result;
        }
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JExcelApiExporterContext {
        protected ExporterContext() {
        }
    }
}

