/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Compression.LZMA;

import SevenZip.Compression.LZ.OutWindow;
import SevenZip.Compression.LZMA.Base;
import SevenZip.Compression.RangeCoder.BitTreeDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Decoder {
    OutWindow m_OutWindow = new OutWindow();
    SevenZip.Compression.RangeCoder.Decoder m_RangeDecoder = new SevenZip.Compression.RangeCoder.Decoder();
    short[] m_IsMatchDecoders = new short[192];
    short[] m_IsRepDecoders = new short[12];
    short[] m_IsRepG0Decoders = new short[12];
    short[] m_IsRepG1Decoders = new short[12];
    short[] m_IsRepG2Decoders = new short[12];
    short[] m_IsRep0LongDecoders = new short[192];
    BitTreeDecoder[] m_PosSlotDecoder = new BitTreeDecoder[4];
    short[] m_PosDecoders = new short[114];
    BitTreeDecoder m_PosAlignDecoder = new BitTreeDecoder(4);
    LenDecoder m_LenDecoder = new LenDecoder();
    LenDecoder m_RepLenDecoder = new LenDecoder();
    LiteralDecoder m_LiteralDecoder = new LiteralDecoder();
    int m_DictionarySize = -1;
    int m_DictionarySizeCheck = -1;
    int m_PosStateMask;

    public Decoder() {
        for (int i = 0; i < 4; ++i) {
            this.m_PosSlotDecoder[i] = new BitTreeDecoder(6);
        }
    }

    public boolean SetDictionarySize(int n) {
        if (n < 0) {
            return false;
        }
        if (this.m_DictionarySize != n) {
            this.m_DictionarySize = n;
            this.m_DictionarySizeCheck = Math.max(this.m_DictionarySize, 1);
            this.m_OutWindow.Create(Math.max(this.m_DictionarySizeCheck, 4096));
        }
        return true;
    }

    public boolean SetLcLpPb(int n, int n2, int n3) {
        if (n > 8 || n2 > 4 || n3 > 4) {
            return false;
        }
        this.m_LiteralDecoder.Create(n2, n);
        int n4 = 1 << n3;
        this.m_LenDecoder.Create(n4);
        this.m_RepLenDecoder.Create(n4);
        this.m_PosStateMask = n4 - 1;
        return true;
    }

    void Init() throws IOException {
        this.m_OutWindow.Init(false);
        SevenZip.Compression.RangeCoder.Decoder.InitBitModels(this.m_IsMatchDecoders);
        SevenZip.Compression.RangeCoder.Decoder.InitBitModels(this.m_IsRep0LongDecoders);
        SevenZip.Compression.RangeCoder.Decoder.InitBitModels(this.m_IsRepDecoders);
        SevenZip.Compression.RangeCoder.Decoder.InitBitModels(this.m_IsRepG0Decoders);
        SevenZip.Compression.RangeCoder.Decoder.InitBitModels(this.m_IsRepG1Decoders);
        SevenZip.Compression.RangeCoder.Decoder.InitBitModels(this.m_IsRepG2Decoders);
        SevenZip.Compression.RangeCoder.Decoder.InitBitModels(this.m_PosDecoders);
        this.m_LiteralDecoder.Init();
        for (int i = 0; i < 4; ++i) {
            this.m_PosSlotDecoder[i].Init();
        }
        this.m_LenDecoder.Init();
        this.m_RepLenDecoder.Init();
        this.m_PosAlignDecoder.Init();
        this.m_RangeDecoder.Init();
    }

    public boolean Code(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        this.m_RangeDecoder.SetStream(inputStream);
        this.m_OutWindow.SetStream(outputStream);
        this.Init();
        int n = Base.StateInit();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        long l2 = 0L;
        byte by = 0;
        while (l < 0L || l2 < l) {
            int n6;
            int n7;
            int n8 = (int)l2 & this.m_PosStateMask;
            if (this.m_RangeDecoder.DecodeBit(this.m_IsMatchDecoders, (n << 4) + n8) == 0) {
                LiteralDecoder.Decoder2 decoder2 = this.m_LiteralDecoder.GetDecoder((int)l2, by);
                by = !Base.StateIsCharState(n) ? decoder2.DecodeWithMatchByte(this.m_RangeDecoder, this.m_OutWindow.GetByte(n2)) : decoder2.DecodeNormal(this.m_RangeDecoder);
                this.m_OutWindow.PutByte(by);
                n = Base.StateUpdateChar(n);
                ++l2;
                continue;
            }
            if (this.m_RangeDecoder.DecodeBit(this.m_IsRepDecoders, n) == 1) {
                n7 = 0;
                if (this.m_RangeDecoder.DecodeBit(this.m_IsRepG0Decoders, n) == 0) {
                    if (this.m_RangeDecoder.DecodeBit(this.m_IsRep0LongDecoders, (n << 4) + n8) == 0) {
                        n = Base.StateUpdateShortRep(n);
                        n7 = 1;
                    }
                } else {
                    if (this.m_RangeDecoder.DecodeBit(this.m_IsRepG1Decoders, n) == 0) {
                        n6 = n3;
                    } else {
                        if (this.m_RangeDecoder.DecodeBit(this.m_IsRepG2Decoders, n) == 0) {
                            n6 = n4;
                        } else {
                            n6 = n5;
                            n5 = n4;
                        }
                        n4 = n3;
                    }
                    n3 = n2;
                    n2 = n6;
                }
                if (n7 == 0) {
                    n7 = this.m_RepLenDecoder.Decode(this.m_RangeDecoder, n8) + 2;
                    n = Base.StateUpdateRep(n);
                }
            } else {
                n5 = n4;
                n4 = n3;
                n3 = n2;
                n7 = 2 + this.m_LenDecoder.Decode(this.m_RangeDecoder, n8);
                n = Base.StateUpdateMatch(n);
                n6 = this.m_PosSlotDecoder[Base.GetLenToPosState(n7)].Decode(this.m_RangeDecoder);
                if (n6 >= 4) {
                    int n9 = (n6 >> 1) - 1;
                    n2 = (2 | n6 & 1) << n9;
                    if (n6 < 14) {
                        n2 += BitTreeDecoder.ReverseDecode(this.m_PosDecoders, n2 - n6 - 1, this.m_RangeDecoder, n9);
                    } else {
                        n2 += this.m_RangeDecoder.DecodeDirectBits(n9 - 4) << 4;
                        if ((n2 += this.m_PosAlignDecoder.ReverseDecode(this.m_RangeDecoder)) < 0) {
                            if (n2 == -1) break;
                            return false;
                        }
                    }
                } else {
                    n2 = n6;
                }
            }
            if ((long)n2 >= l2 || n2 >= this.m_DictionarySizeCheck) {
                return false;
            }
            this.m_OutWindow.CopyBlock(n2, n7);
            l2 += (long)n7;
            by = this.m_OutWindow.GetByte(0);
        }
        this.m_OutWindow.Flush();
        this.m_OutWindow.ReleaseStream();
        this.m_RangeDecoder.ReleaseStream();
        return true;
    }

    public boolean SetDecoderProperties(byte[] byArray) {
        if (byArray.length < 5) {
            return false;
        }
        int n = byArray[0] & 0xFF;
        int n2 = n % 9;
        int n3 = n / 9;
        int n4 = n3 % 5;
        int n5 = n3 / 5;
        int n6 = 0;
        for (int i = 0; i < 4; ++i) {
            n6 += (byArray[1 + i] & 0xFF) << i * 8;
        }
        if (!this.SetLcLpPb(n2, n4, n5)) {
            return false;
        }
        return this.SetDictionarySize(n6);
    }

    class LiteralDecoder {
        Decoder2[] m_Coders;
        int m_NumPrevBits;
        int m_NumPosBits;
        int m_PosMask;

        LiteralDecoder() {
        }

        public void Create(int n, int n2) {
            if (this.m_Coders != null && this.m_NumPrevBits == n2 && this.m_NumPosBits == n) {
                return;
            }
            this.m_NumPosBits = n;
            this.m_PosMask = (1 << n) - 1;
            this.m_NumPrevBits = n2;
            int n3 = 1 << this.m_NumPrevBits + this.m_NumPosBits;
            this.m_Coders = new Decoder2[n3];
            for (int i = 0; i < n3; ++i) {
                this.m_Coders[i] = new Decoder2();
            }
        }

        public void Init() {
            int n = 1 << this.m_NumPrevBits + this.m_NumPosBits;
            for (int i = 0; i < n; ++i) {
                this.m_Coders[i].Init();
            }
        }

        Decoder2 GetDecoder(int n, byte by) {
            return this.m_Coders[((n & this.m_PosMask) << this.m_NumPrevBits) + ((by & 0xFF) >>> 8 - this.m_NumPrevBits)];
        }

        class Decoder2 {
            short[] m_Decoders = new short[768];

            Decoder2() {
            }

            public void Init() {
                SevenZip.Compression.RangeCoder.Decoder.InitBitModels(this.m_Decoders);
            }

            public byte DecodeNormal(SevenZip.Compression.RangeCoder.Decoder decoder) throws IOException {
                int n = 1;
                while ((n = n << 1 | decoder.DecodeBit(this.m_Decoders, n)) < 256) {
                }
                return (byte)n;
            }

            public byte DecodeWithMatchByte(SevenZip.Compression.RangeCoder.Decoder decoder, byte by) throws IOException {
                int n = 1;
                do {
                    int n2 = by >> 7 & 1;
                    by = (byte)(by << 1);
                    int n3 = decoder.DecodeBit(this.m_Decoders, (1 + n2 << 8) + n);
                    n = n << 1 | n3;
                    if (n2 == n3) continue;
                    while (n < 256) {
                        n = n << 1 | decoder.DecodeBit(this.m_Decoders, n);
                    }
                    break;
                } while (n < 256);
                return (byte)n;
            }
        }
    }

    class LenDecoder {
        short[] m_Choice = new short[2];
        BitTreeDecoder[] m_LowCoder = new BitTreeDecoder[16];
        BitTreeDecoder[] m_MidCoder = new BitTreeDecoder[16];
        BitTreeDecoder m_HighCoder = new BitTreeDecoder(8);
        int m_NumPosStates = 0;

        LenDecoder() {
        }

        public void Create(int n) {
            while (this.m_NumPosStates < n) {
                this.m_LowCoder[this.m_NumPosStates] = new BitTreeDecoder(3);
                this.m_MidCoder[this.m_NumPosStates] = new BitTreeDecoder(3);
                ++this.m_NumPosStates;
            }
        }

        public void Init() {
            SevenZip.Compression.RangeCoder.Decoder.InitBitModels(this.m_Choice);
            for (int i = 0; i < this.m_NumPosStates; ++i) {
                this.m_LowCoder[i].Init();
                this.m_MidCoder[i].Init();
            }
            this.m_HighCoder.Init();
        }

        public int Decode(SevenZip.Compression.RangeCoder.Decoder decoder, int n) throws IOException {
            if (decoder.DecodeBit(this.m_Choice, 0) == 0) {
                return this.m_LowCoder[n].Decode(decoder);
            }
            int n2 = 8;
            n2 = decoder.DecodeBit(this.m_Choice, 1) == 0 ? (n2 += this.m_MidCoder[n].Decode(decoder)) : (n2 += 8 + this.m_HighCoder.Decode(decoder));
            return n2;
        }
    }
}

