/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare;

import com.bysquare.BysquareException;
import com.bysquare.Header;
import com.bysquare.IBysquareEncoder;
import com.bysquare.UnknownDocumentException;
import com.bysquare.base32hex.Base32hexEncoder;
import com.bysquare.checksum.CRC32Checksum;
import com.bysquare.checksum.IChecksum;
import com.bysquare.compression.ICompressor;
import com.bysquare.compression.LZMACompressor;
import com.bysquare.document.BysquareDocument;
import com.bysquare.sequence.SequenceEncoder;
import com.bysquare.utilities.IOUtils;
import com.bysquare.xml.IXMLMapper;
import com.bysquare.xml.SimpleXMLMapper;
import java.io.InputStream;
import java.io.Reader;

public class BysquareEncoder
implements IBysquareEncoder {
    protected final Base32hexEncoder base32hexEncoder = new Base32hexEncoder();
    protected final IChecksum checksum = new CRC32Checksum();
    protected final ICompressor compressor = new LZMACompressor();
    protected final IXMLMapper xmlMapper = new SimpleXMLMapper();
    private boolean truncated;
    private int sequenceLimit = 550;
    private int maxPriority = 0;

    void checkBase32hex(byte[] byArray) throws UnknownDocumentException {
        if (byArray == null) {
            throw new NullPointerException("Base32hex cannot be null. ");
        }
        if (byArray.length < 4) {
            throw new UnknownDocumentException("Header not found. ");
        }
    }

    void checkBase32hex(String string) throws UnknownDocumentException {
        if (string == null) {
            throw new NullPointerException("Base32hex cannot be null. ");
        }
        if (string.length() < 4) {
            throw new UnknownDocumentException("Header not found. ");
        }
    }

    public Header decodeHeader(byte[] byArray) throws BysquareException {
        this.checkBase32hex(byArray);
        byArray = IOUtils.copyOf(byArray, 4);
        return Header.find(this.base32hexEncoder.decode(byArray));
    }

    public Header decodeHeader(String string) throws BysquareException {
        this.checkBase32hex(string);
        string = string.substring(0, 4);
        return Header.find(this.base32hexEncoder.decode(string));
    }

    private byte[] encodeDocumentToData(BysquareDocument bysquareDocument) throws BysquareException {
        this.truncated = false;
        if (bysquareDocument == null) {
            throw new NullPointerException("Document cannot be null. ");
        }
        bysquareDocument.verify();
        try {
            Header header = Header.find(bysquareDocument);
            SequenceEncoder sequenceEncoder = SequenceEncoder.getInstance(header.getBysquareType());
            sequenceEncoder.setLimit(this.sequenceLimit);
            sequenceEncoder.setMaxPriority(this.maxPriority);
            byte[] byArray = sequenceEncoder.encode(bysquareDocument).getBytes("UTF-8");
            this.truncated = sequenceEncoder.wasTruncated();
            byte[] byArray2 = this.checksum.add(byArray);
            byArray = null;
            byte[] byArray3 = this.compressor.compress(byArray2);
            byArray2 = null;
            byte[] byArray4 = header.encode();
            byte[] byArray5 = new byte[byArray4.length + byArray3.length];
            System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
            System.arraycopy(byArray3, 0, byArray5, byArray4.length, byArray3.length);
            byArray3 = null;
            byArray4 = null;
            header = null;
            return byArray5;
        }
        catch (BysquareException bysquareException) {
            throw bysquareException;
        }
        catch (Throwable throwable) {
            throw new BysquareException("Unknown error. ", throwable);
        }
    }

    public byte[] encodeDocument(BysquareDocument bysquareDocument) throws BysquareException {
        return this.base32hexEncoder.encode(this.encodeDocumentToData(bysquareDocument));
    }

    public String encodeDocumentToString(BysquareDocument bysquareDocument) throws BysquareException {
        return this.base32hexEncoder.encodeToString(this.encodeDocumentToData(bysquareDocument));
    }

    public byte[] encodeXML(InputStream inputStream) throws BysquareException {
        return this.encodeDocument(this.xmlMapper.readXML(inputStream));
    }

    public String encodeXMLToString(InputStream inputStream) throws BysquareException {
        return this.encodeDocumentToString(this.xmlMapper.readXML(inputStream));
    }

    public byte[] encodeXML(Reader reader) throws BysquareException {
        return this.encodeDocument(this.xmlMapper.readXML(reader));
    }

    public String encodeXMLToString(Reader reader) throws BysquareException {
        return this.encodeDocumentToString(this.xmlMapper.readXML(reader));
    }

    public int getMaxPriority() {
        return this.maxPriority;
    }

    public int getSequenceLimit() {
        return this.sequenceLimit;
    }

    public void setMaxPriority(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Maximum truncation priority cannot be negative.");
        }
        this.maxPriority = n;
    }

    public void setSequenceLimit(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Sequence limit cannot be negative.");
        }
        this.sequenceLimit = n;
    }

    public boolean wasTruncated() {
        return this.truncated;
    }
}

