/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.base32hex;

import com.bysquare.base32hex.Base32hexException;
import com.bysquare.base32hex.IBase32hexEncoder;

public class Base32hexEncoder
implements IBase32hexEncoder {
    private static final String BASE32HEX = "0123456789ABCDEFGHIJKLMNOPQRSTUV";
    private static final char[] BASE32HEX_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUV".toCharArray();
    private static final byte[] BASE32HEX_BYTES = "0123456789ABCDEFGHIJKLMNOPQRSTUV".getBytes();
    private static final byte[] EMPTY = new byte[0];

    public byte[] decode(byte[] byArray) throws Base32hexException {
        if (byArray.length == 0) {
            return EMPTY;
        }
        int n = 0;
        byte[] byArray2 = new byte[byArray.length * 5 / 8];
        byte by = 0;
        int n2 = 8;
        for (byte by2 : byArray) {
            int n3;
            if (48 <= by2 && by2 <= 57) {
                n3 = by2 - 48;
            } else if (65 <= by2 && by2 <= 86) {
                n3 = by2 - 65 + 10;
            } else {
                throw new Base32hexException("Unable to decode byte: " + by2);
            }
            if (n2 > 5) {
                n2 = (byte)(n2 - 5);
                by = (byte)(by | n3 << n2);
                continue;
            }
            byArray2[n++] = (byte)(by | n3 >> 5 - n2);
            n2 = (byte)(n2 + 3);
            by = (byte)(n3 << n2);
        }
        if (n < byArray2.length) {
            byArray2[n] = by;
        }
        return byArray2;
    }

    public byte[] decode(String string) throws Base32hexException {
        int n = string.length();
        if (n == 0) {
            return EMPTY;
        }
        int n2 = 0;
        byte[] byArray = new byte[n * 5 / 8];
        byte by = 0;
        int n3 = 8;
        for (int i = 0; i < n; ++i) {
            int n4;
            char c = string.charAt(i);
            if ('0' <= c && c <= '9') {
                n4 = c - 48;
            } else if ('A' <= c && c <= 'V') {
                n4 = c - 65 + 10;
            } else {
                throw new Base32hexException("Unable to decode character: " + c);
            }
            if (n3 > 5) {
                n3 = (byte)(n3 - 5);
                by = (byte)(by | n4 << n3);
                continue;
            }
            byArray[n2++] = (byte)(by | n4 >> 5 - n3);
            n3 = (byte)(n3 + 3);
            by = (byte)(n4 << n3);
        }
        if (n2 < byArray.length) {
            byArray[n2] = by;
        }
        return byArray;
    }

    public byte[] encode(byte[] byArray) {
        if (byArray.length == 0) {
            return EMPTY;
        }
        byte[] byArray2 = new byte[(int)Math.ceil((double)(byArray.length * 8) / 5.0)];
        int n = 0;
        int n2 = 0;
        int n3 = 5;
        for (int n4 : byArray) {
            int n5 = n4 > -1 ? n4 : n4 + 256;
            n2 = (byte)(n2 | n5 >> 8 - n3);
            byArray2[n++] = BASE32HEX_BYTES[n2];
            if (n3 < 4) {
                n2 = (byte)(n5 >> 3 - n3 & 0x1F);
                byArray2[n++] = BASE32HEX_BYTES[n2];
                n3 = (byte)(n3 + 5);
            }
            n3 = (byte)(n3 - 3);
            n2 = (byte)(n5 << n3 & 0x1F);
        }
        if (n < byArray2.length) {
            byArray2[n] = BASE32HEX_BYTES[n2];
        }
        return byArray2;
    }

    public String encodeToString(byte[] byArray) {
        if (byArray.length == 0) {
            return "";
        }
        char[] cArray = new char[(int)Math.ceil((double)(byArray.length * 8) / 5.0)];
        int n = 0;
        int n2 = 0;
        int n3 = 5;
        for (int n4 : byArray) {
            int n5 = n4 > -1 ? n4 : n4 + 256;
            n2 = (byte)(n2 | n5 >> 8 - n3);
            cArray[n++] = BASE32HEX_CHARS[n2];
            if (n3 < 4) {
                n2 = (byte)(n5 >> 3 - n3 & 0x1F);
                cArray[n++] = BASE32HEX_CHARS[n2];
                n3 = (byte)(n3 + 5);
            }
            n3 = (byte)(n3 - 3);
            n2 = (byte)(n5 << n3 & 0x1F);
        }
        if (n < cArray.length) {
            cArray[n] = BASE32HEX_CHARS[n2];
        }
        return new String(cArray);
    }
}

