/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.document.invoice;

import com.bysquare.document.IVerifiable;
import com.bysquare.document.InvalidValueException;
import com.bysquare.document.invoice.InvoiceBase;
import com.bysquare.document.invoice.TaxCategorySummary;
import java.util.Collections;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Order(elements={"TaxExclusiveAmount", "TaxInclusiveAmount", "TaxAmount", "AlreadyClaimedTaxExclusiveAmount", "AlreadyClaimedTaxInclusiveAmount", "AlreadyClaimedTaxAmount", "DifferenceTaxExclusiveAmount", "DifferenceTaxInclusiveAmount", "DifferenceTaxAmount", "PayableRoundingAmount", "PaidDepositsAmount", "PayableAmount"})
@Root(name="MonetarySummary", strict=false)
public class MonetarySummary
implements IVerifiable {
    protected Double payableRoundingAmount;
    protected Double paidDepositsAmount;
    transient InvoiceBase invoice;

    @Element(name="TaxExclusiveAmount", required=false)
    public Double getTaxExclusiveAmount() {
        double d = 0.0;
        for (TaxCategorySummary taxCategorySummary : this.getTaxCategorySummaries()) {
            d += taxCategorySummary.getTaxExclusiveAmount().doubleValue();
        }
        return d;
    }

    @Deprecated
    @Element(name="TaxExclusiveAmount", required=false)
    public void setTaxExclusiveAmount(Double d) {
    }

    @Element(name="TaxInclusiveAmount", required=false)
    public Double getTaxInclusiveAmount() {
        double d = 0.0;
        for (TaxCategorySummary taxCategorySummary : this.getTaxCategorySummaries()) {
            d += taxCategorySummary.getTaxInclusiveAmount().doubleValue();
        }
        return d;
    }

    @Deprecated
    @Element(name="TaxInclusiveAmount", required=false)
    public void setTaxInclusiveAmount(Double d) {
    }

    @Element(name="TaxAmount", required=false)
    public Double getTaxAmount() {
        double d = 0.0;
        for (TaxCategorySummary taxCategorySummary : this.getTaxCategorySummaries()) {
            d += taxCategorySummary.getTaxAmount().doubleValue();
        }
        return d;
    }

    @Deprecated
    @Element(name="TaxAmount", required=false)
    public void setTaxAmount(Double d) {
    }

    @Element(name="AlreadyClaimedTaxExclusiveAmount", required=false)
    public Double getAlreadyClaimedTaxExclusiveAmount() {
        double d = 0.0;
        for (TaxCategorySummary taxCategorySummary : this.getTaxCategorySummaries()) {
            d += taxCategorySummary.getAlreadyClaimedTaxExclusiveAmount().doubleValue();
        }
        return d;
    }

    @Deprecated
    @Element(name="AlreadyClaimedTaxExclusiveAmount", required=false)
    public void setAlreadyClaimedTaxExclusiveAmount(Double d) {
    }

    @Element(name="AlreadyClaimedTaxInclusiveAmount", required=false)
    public Double getAlreadyClaimedTaxInclusiveAmount() {
        double d = 0.0;
        for (TaxCategorySummary taxCategorySummary : this.getTaxCategorySummaries()) {
            d += taxCategorySummary.getAlreadyClaimedTaxInclusiveAmount().doubleValue();
        }
        return d;
    }

    @Deprecated
    @Element(name="AlreadyClaimedTaxInclusiveAmount", required=false)
    public void setAlreadyClaimedTaxInclusiveAmount(Double d) {
    }

    @Element(name="AlreadyClaimedTaxAmount", required=false)
    public Double getAlreadyClaimedTaxAmount() {
        double d = 0.0;
        for (TaxCategorySummary taxCategorySummary : this.getTaxCategorySummaries()) {
            d += taxCategorySummary.getAlreadyClaimedTaxAmount().doubleValue();
        }
        return d;
    }

    @Deprecated
    @Element(name="AlreadyClaimedTaxAmount", required=false)
    public void setAlreadyClaimedTaxAmount(Double d) {
    }

    @Element(name="DifferenceTaxExclusiveAmount", required=false)
    public Double getDifferenceTaxExclusiveAmount() {
        double d = 0.0;
        for (TaxCategorySummary taxCategorySummary : this.getTaxCategorySummaries()) {
            d += taxCategorySummary.getDifferenceTaxExclusiveAmount().doubleValue();
        }
        return d;
    }

    @Deprecated
    @Element(name="DifferenceTaxExclusiveAmount", required=false)
    public void setDifferenceTaxExclusiveAmount(Double d) {
    }

    @Element(name="DifferenceTaxInclusiveAmount", required=false)
    public Double getDifferenceTaxInclusiveAmount() {
        double d = 0.0;
        for (TaxCategorySummary taxCategorySummary : this.getTaxCategorySummaries()) {
            d += taxCategorySummary.getDifferenceTaxInclusiveAmount().doubleValue();
        }
        return d;
    }

    @Deprecated
    @Element(name="DifferenceTaxInclusiveAmount", required=false)
    public void setDifferenceTaxInclusiveAmount(Double d) {
    }

    @Element(name="DifferenceTaxAmount", required=false)
    public Double getDifferenceTaxAmount() {
        double d = 0.0;
        for (TaxCategorySummary taxCategorySummary : this.getTaxCategorySummaries()) {
            d += taxCategorySummary.getDifferenceTaxAmount().doubleValue();
        }
        return d;
    }

    @Deprecated
    @Element(name="DifferenceTaxAmount", required=false)
    public void setDifferenceTaxAmount(Double d) {
    }

    @Element(name="PayableRoundingAmount", required=false)
    public Double getPayableRoundingAmount() {
        if (this.payableRoundingAmount == null) {
            this.payableRoundingAmount = 0.0;
        }
        return this.payableRoundingAmount;
    }

    @Element(name="PayableRoundingAmount", required=false)
    public void setPayableRoundingAmount(Double d) {
        this.payableRoundingAmount = d;
    }

    @Element(name="PaidDepositsAmount", required=false)
    public Double getPaidDepositsAmount() {
        if (this.paidDepositsAmount == null) {
            this.paidDepositsAmount = 0.0;
        }
        return this.paidDepositsAmount;
    }

    @Element(name="PaidDepositsAmount", required=false)
    public void setPaidDepositsAmount(Double d) {
        this.paidDepositsAmount = d;
    }

    @Element(name="PayableAmount", required=false)
    public Double getPayableAmount() {
        return this.getDifferenceTaxInclusiveAmount() - this.getPaidDepositsAmount() + this.getPayableRoundingAmount();
    }

    @Deprecated
    @Element(name="PayableAmount", required=false)
    public void setPayableAmount(Double d) {
    }

    private Iterable<TaxCategorySummary> getTaxCategorySummaries() {
        if (this.invoice != null) {
            return this.invoice.getTaxCategorySummaries();
        }
        return Collections.emptyList();
    }

    @Override
    public void verify() throws InvalidValueException {
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof MonetarySummary)) {
            return false;
        }
        MonetarySummary monetarySummary = (MonetarySummary)object;
        return this.getPaidDepositsAmount().equals(monetarySummary.getPaidDepositsAmount()) && this.getPayableRoundingAmount().equals(monetarySummary.getPayableRoundingAmount());
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.getPaidDepositsAmount().hashCode();
        n = 31 * n + this.getPayableRoundingAmount().hashCode();
        return n;
    }
}

