/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.document.invoice;

import com.bysquare.document.InvalidValueException;
import com.bysquare.document.Verify;
import com.bysquare.document.invoice.Contact;
import com.bysquare.document.invoice.Party;
import com.bysquare.document.invoice.PostalAddress;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;

@Order(elements={"PartyName", "CompanyTaxID", "CompanyVATID", "CompanyRegisterID", "PostalAddress", "Contact"})
@Root(name="SupplierParty", strict=false)
public class SupplierParty
extends Party {
    @Element(name="PostalAddress", required=false)
    protected PostalAddress postalAddress;
    @Element(name="Contact", required=false)
    protected Contact contact;

    public PostalAddress getPostalAddress() {
        if (this.postalAddress == null) {
            this.postalAddress = new PostalAddress();
        }
        return this.postalAddress;
    }

    public void setPostalAddress(PostalAddress postalAddress) {
        this.postalAddress = postalAddress;
    }

    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public boolean isEmpty() {
        return super.isEmpty() && this.getPostalAddress().isEmpty() && (this.contact == null || this.contact.isEmpty());
    }

    public void verify() throws InvalidValueException {
        super.verify();
        Verify.notNullAndVerify("PostalAddress", this.getPostalAddress());
        Verify.nullOrVerify(this.contact);
    }

    @Commit
    private void commit() {
        if (this.contact != null && this.contact.isEmpty()) {
            this.contact = null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SupplierParty)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        SupplierParty supplierParty = (SupplierParty)object;
        if (this.contact == null ? supplierParty.contact != null : !this.contact.equals(supplierParty.contact)) {
            return false;
        }
        return this.getPostalAddress().equals(supplierParty.getPostalAddress());
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.contact == null ? 0 : this.contact.hashCode());
        n = 31 * n + this.getPostalAddress().hashCode();
        return n;
    }
}

