/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.document.pay;

import com.bysquare.document.IVerifiable;
import com.bysquare.document.InvalidValueException;
import com.bysquare.document.Verify;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;

@Order(elements={"IBAN", "BIC"})
@Root(name="BankAccount", strict=false)
public class BankAccount
implements IVerifiable {
    protected String iban;
    protected String bic;

    @Element(name="IBAN", required=false)
    public String getIBAN() {
        return this.iban;
    }

    @Element(name="IBAN", required=false)
    public void setIBAN(String string) {
        this.iban = Verify.trimAllToUpperCase(string);
    }

    @Element(name="BIC", required=false)
    public String getBIC() {
        return this.bic;
    }

    @Element(name="BIC", required=false)
    public void setBIC(String string) {
        this.bic = Verify.trimAllToUpperCase(string);
    }

    public BankAccount() {
    }

    public BankAccount(String string, String string2) {
        this.setIBAN(string);
        this.setBIC(string2);
    }

    public void verify() throws InvalidValueException {
        Verify.notNullAndMatch("IBAN", this.iban, "[A-Z]{2}[0-9]{2}[A-Z0-9]{0,30}");
        Verify.notNullAndMatch("BIC", this.bic, "[A-Z]{4}[A-Z]{2}[A-Z0-9]{2}([A-Z0-9]{3})?");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof BankAccount)) {
            return false;
        }
        BankAccount bankAccount = (BankAccount)object;
        if (this.bic == null ? bankAccount.bic != null : !this.bic.equals(bankAccount.bic)) {
            return false;
        }
        return !(this.iban == null ? bankAccount.iban != null : !this.iban.equals(bankAccount.iban));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.bic == null ? 0 : this.bic.hashCode());
        n = 31 * n + (this.iban == null ? 0 : this.iban.hashCode());
        return n;
    }
}

