/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.document.pay;

import com.bysquare.document.IVerifiable;
import com.bysquare.document.InvalidValueException;
import com.bysquare.document.Verify;
import com.bysquare.document.pay.Month;
import com.bysquare.document.pay.Periodicity;
import com.bysquare.xml.helper.MonthsConverter;
import java.util.Date;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.convert.Convert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Order(elements={"Day", "Month", "Periodicity", "LastDate"})
@Root(name="StandingOrderExt", strict=false)
public class StandingOrderExt
implements IVerifiable {
    @Element(name="Day", required=false)
    protected Integer day;
    @Element(name="Month", required=false)
    @Convert(value=MonthsConverter.class)
    protected List<Month> month;
    @Element(name="Periodicity")
    protected Periodicity periodicity;
    @Element(name="LastDate", required=false)
    protected Date lastDate;

    public Integer getDay() {
        return this.day;
    }

    public void setDay(Integer n) {
        this.day = n;
    }

    public List<Month> getMonth() {
        return this.month;
    }

    public void setMonth(List<Month> list) {
        this.month = list;
    }

    public Periodicity getPeriodicity() {
        return this.periodicity;
    }

    public void setPeriodicity(Periodicity periodicity) {
        this.periodicity = periodicity;
    }

    public Date getLastDate() {
        return this.lastDate;
    }

    public void setLastDate(Date date) {
        this.lastDate = date;
    }

    @Override
    public void verify() throws InvalidValueException {
        Periodicity periodicity = this.getPeriodicity();
        Integer n = this.getDay();
        List<Month> list = this.getMonth();
        Verify.notNull("Periodicity", (Object)periodicity);
        if (!periodicity.useDayMonth()) {
            String string = String.format("periodicity %s does not allow Day or Month to be specifies.", new Object[]{periodicity});
            Verify.isNull("Day", n, string);
            Verify.isNull("Month", list, string);
        } else if (periodicity == Periodicity.Weekly || periodicity == Periodicity.Biweekly) {
            Verify.nullOrInRange("Day", n, 1, 7);
        } else {
            Verify.nullOrInRange("Day", n, 1, 31);
        }
        if (list != null) {
            Verify.enumList("Month", list, Month.class);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof StandingOrderExt)) {
            return false;
        }
        StandingOrderExt standingOrderExt = (StandingOrderExt)object;
        if (this.day == null ? standingOrderExt.day != null : !this.day.equals(standingOrderExt.day)) {
            return false;
        }
        if (this.lastDate == null ? standingOrderExt.lastDate != null : !this.lastDate.equals(standingOrderExt.lastDate)) {
            return false;
        }
        if (this.month == null ? standingOrderExt.month != null : !this.month.equals(standingOrderExt.month)) {
            return false;
        }
        return this.periodicity == standingOrderExt.periodicity;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.day == null ? 0 : this.day.hashCode());
        n = 31 * n + (this.lastDate == null ? 0 : this.lastDate.hashCode());
        n = 31 * n + (this.month == null ? 0 : this.month.hashCode());
        n = 31 * n + (this.periodicity == null ? 0 : this.periodicity.hashCode());
        return n;
    }
}

