/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.logo;

import com.bysquare.logo.Logo;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class NoFrameLogo
extends Logo {
    protected final boolean isVertical;
    protected final int resultWidth;
    protected final int resultHeight;
    protected final int logoX;
    protected final int logoY;
    protected final int qrX;
    protected final int qrY;
    protected final int qrSize;

    public NoFrameLogo(BufferedImage bufferedImage, Logo.Rotation rotation) {
        this(bufferedImage, rotation, true);
    }

    private NoFrameLogo(BufferedImage bufferedImage, Logo.Rotation rotation, boolean bl) {
        super(bufferedImage, bl);
        if (rotation == null) {
            throw new NullPointerException();
        }
        this.isVertical = rotation == Logo.Rotation.BOTTOM || rotation == Logo.Rotation.TOP;
        this.qrSize = this.isVertical ? this.width : this.height;
        this.resultWidth = this.isVertical ? this.qrSize : this.qrSize + this.width;
        this.resultHeight = this.isVertical ? this.qrSize + this.height : this.qrSize;
        this.logoX = rotation == Logo.Rotation.RIGHT ? this.qrSize : 0;
        this.logoY = rotation == Logo.Rotation.BOTTOM ? this.qrSize : 0;
        this.qrX = rotation == Logo.Rotation.LEFT ? this.width : 0;
        this.qrY = rotation == Logo.Rotation.TOP ? this.height : 0;
    }

    public NoFrameLogo(File file, Logo.Rotation rotation) throws IOException {
        this(ImageIO.read(file), rotation, false);
    }

    public NoFrameLogo(InputStream inputStream, Logo.Rotation rotation) throws IOException {
        this(ImageIO.read(inputStream), rotation, false);
    }

    public BufferedImage wrap(Image image) {
        if (image == null) {
            throw new NullPointerException();
        }
        BufferedImage bufferedImage = new BufferedImage(this.resultWidth, this.resultHeight, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(Color.WHITE);
        graphics2D.clearRect(0, 0, this.resultWidth, this.resultHeight);
        graphics2D.drawImage((Image)this.logo, this.logoX, this.logoY, null);
        graphics2D.drawImage(image, this.qrX, this.qrY, this.qrSize, this.qrSize, null);
        graphics2D.dispose();
        return bufferedImage;
    }
}

