/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.sequence;

import com.bysquare.document.BysquareDocument;
import com.bysquare.document.pay.BankAccount;
import com.bysquare.document.pay.BankAccounts;
import com.bysquare.document.pay.DirectDebitExt;
import com.bysquare.document.pay.PayBase;
import com.bysquare.document.pay.Payment;
import com.bysquare.document.pay.Payments;
import com.bysquare.document.pay.Periodicity;
import com.bysquare.document.pay.StandingOrderExt;
import com.bysquare.sequence.SequenceEncoder;

class PayBaseEncoder
extends SequenceEncoder {
    PayBaseEncoder() {
    }

    private void encode(BankAccount bankAccount) {
        if (bankAccount != null) {
            this.add(bankAccount.getIBAN());
            this.add(bankAccount.getBIC());
        } else {
            this.skip();
            this.skip();
        }
    }

    private void encode(BankAccounts bankAccounts) {
        this.add(bankAccounts.size());
        for (BankAccount bankAccount : bankAccounts) {
            this.encode(bankAccount);
        }
    }

    private void encode(Periodicity periodicity) {
        this.add(periodicity == null ? null : periodicity.getShortcut());
    }

    private void encode(StandingOrderExt standingOrderExt) {
        if (standingOrderExt != null) {
            this.add(1);
            this.add(standingOrderExt.getDay());
            this.add(standingOrderExt.getMonth());
            this.encode(standingOrderExt.getPeriodicity());
            this.add(standingOrderExt.getLastDate());
        } else {
            this.add(0);
        }
    }

    private void encode(DirectDebitExt directDebitExt) {
        if (directDebitExt != null) {
            this.add(1);
            this.add(directDebitExt.getDirectDebitScheme());
            this.add(directDebitExt.getDirectDebitType());
            this.add(directDebitExt.getVariableSymbol());
            this.add(directDebitExt.getSpecificSymbol());
            this.add(directDebitExt.getOriginatorsReferenceInformation(), 11, 35);
            this.add(directDebitExt.getMandateID(), 10, 35);
            this.add(directDebitExt.getCreditorID(), 9, 35);
            this.add(directDebitExt.getContractID(), 8, 35);
            this.add(directDebitExt.getMaxAmount());
            this.add(directDebitExt.getValidTillDate());
        } else {
            this.add(0);
        }
    }

    private void encode(Payment payment) {
        if (payment != null) {
            this.add(payment.getPaymentOptions());
            this.add(payment.getAmount());
            this.add(payment.getCurrencyCode());
            this.add(payment.getPaymentDueDate());
            this.add(payment.getVariableSymbol());
            this.add(payment.getConstantSymbol());
            this.add(payment.getSpecificSymbol());
            this.add(payment.getOriginatorsReferenceInformation(), 12, 35);
            this.add(payment.getPaymentNote(), 1, 140);
            this.encode(payment.getBankAccounts());
            this.encode(payment.getStandingOrderExt());
            this.encode(payment.getDirectDebitExt());
        } else {
            this.skip();
            this.skip();
            this.skip();
            this.skip();
            this.skip();
            this.skip();
            this.skip();
            this.skip();
            this.skip();
            this.skip();
            this.encode((StandingOrderExt)null);
            this.encode((DirectDebitExt)null);
        }
    }

    private void encode(Payments payments) {
        this.add(payments.size());
        for (Payment payment : payments) {
            this.encode(payment);
        }
    }

    private void encode(PayBase payBase) {
        this.add(payBase.getInvoiceID(), 2, 10);
        this.encode(payBase.getPayments());
    }

    protected void encodeInternal(BysquareDocument bysquareDocument) {
        this.encode((PayBase)bysquareDocument);
    }

    protected int getFieldCount(BysquareDocument bysquareDocument) {
        int n = 2;
        for (Payment payment : ((PayBase)bysquareDocument).getPayments()) {
            n += 12 + 2 * payment.getBankAccounts().size();
            if (payment.getStandingOrderExt() != null) {
                n += 4;
            }
            if (payment.getDirectDebitExt() == null) continue;
            n += 10;
        }
        return n;
    }
}

